/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import android.graphics.Matrix;
import androidx.annotation.Nullable;
import io.agora.base.AlphaStitchMode;
import io.agora.base.ColorSpace;
import io.agora.base.VideoFrameMetaInfo;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.JniCommon;
import io.agora.base.internal.RefCounted;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.WrappedNativeColorSpace;
import java.nio.ByteBuffer;

public class VideoFrame
implements RefCounted {
    private Buffer buffer;
    private int rotation;
    private long timestampNs;
    private ColorSpace colorSpace;
    private SourceType sourceType;
    private float sampleAspectRatio;
    private AlphaStitchMode alphaStitchMode = AlphaStitchMode.ALPHA_NO_STITCH;
    private VideoFrameMetaInfo metaInfo = new VideoFrameMetaInfo();
    private long renderStartTimeMs;
    @Nullable
    private ByteBuffer alphaBuffer;
    private long nativeAlphaBuffer;

    public VideoFrame(Buffer buffer, int rotation, long timestampNs) {
        this(buffer, rotation, timestampNs, new WrappedNativeColorSpace(), null, 0L, 1.0f, SourceType.kUnspecified.ordinal(), System.currentTimeMillis());
    }

    @CalledByNative
    public VideoFrame(Buffer buffer, int rotation, long timestampNs, ColorSpace colorSpace, ByteBuffer alphaBuffer, long nativeAlphaBuffer, float sampleAspectRatio, int sourceType, long renderStartTimeMs) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.colorSpace = colorSpace;
        this.alphaBuffer = alphaBuffer;
        this.nativeAlphaBuffer = nativeAlphaBuffer;
        this.sampleAspectRatio = sampleAspectRatio;
        this.sourceType = SourceType.values()[sourceType];
        this.renderStartTimeMs = renderStartTimeMs;
    }

    public long getRenderStartTimeMs() {
        return this.renderStartTimeMs;
    }

    @CalledByNative
    public SourceType getSourceType() {
        return this.sourceType;
    }

    public float getSampleAspectRatio() {
        return this.sampleAspectRatio;
    }

    @CalledByNative
    public Buffer getBuffer() {
        return this.buffer;
    }

    @CalledByNative
    public int getRotation() {
        return this.rotation;
    }

    @CalledByNative
    public int getAlphaStitchMode() {
        return this.alphaStitchMode.value();
    }

    @CalledByNative
    public void setAlphaStitchMode(int stitchMode) {
        this.alphaStitchMode = AlphaStitchMode.values()[stitchMode];
    }

    @CalledByNative
    public long getTimestampNs() {
        return this.timestampNs;
    }

    @CalledByNative
    public VideoFrameMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.alphaStitchMode == AlphaStitchMode.ALPHA_STITCH_LEFT || this.alphaStitchMode == AlphaStitchMode.ALPHA_STITCH_RIGHT ? this.buffer.getWidth() / 2 : this.buffer.getWidth();
        }
        return this.alphaStitchMode == AlphaStitchMode.ALPHA_STITCH_UP || this.alphaStitchMode == AlphaStitchMode.ALPHA_STITCH_BELOW ? this.buffer.getHeight() / 2 : this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.alphaStitchMode == AlphaStitchMode.ALPHA_STITCH_UP || this.alphaStitchMode == AlphaStitchMode.ALPHA_STITCH_BELOW ? this.buffer.getHeight() / 2 : this.buffer.getHeight();
        }
        return this.alphaStitchMode == AlphaStitchMode.ALPHA_STITCH_LEFT || this.alphaStitchMode == AlphaStitchMode.ALPHA_STITCH_RIGHT ? this.buffer.getWidth() / 2 : this.buffer.getWidth();
    }

    public void replaceBuffer(Buffer buffer, int rotation, long timestampNs) {
        this.release();
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
    }

    @CalledByNative
    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    @CalledByNative
    private int getColorSpaceRange() {
        if (this.colorSpace == null) {
            return ColorSpace.Range.Invalid.getRange();
        }
        return this.colorSpace.getRange().getRange();
    }

    @CalledByNative
    private int getColorSpaceMatrix() {
        if (this.colorSpace == null) {
            return ColorSpace.Matrix.Unspecified.getMatrix();
        }
        return this.colorSpace.getMatrix().getMatrix();
    }

    @CalledByNative
    private int getColorSpaceTransfer() {
        if (this.colorSpace == null) {
            return ColorSpace.Transfer.Unspecified.getTransfer();
        }
        return this.colorSpace.getTransfer().getTransfer();
    }

    @CalledByNative
    private int getColorSpacePrimary() {
        if (this.colorSpace == null) {
            return ColorSpace.Primary.Unspecified.getPrimary();
        }
        return this.colorSpace.getPrimary().getPrimary();
    }

    @CalledByNative
    public ByteBuffer getAlphaBuffer() {
        return this.alphaBuffer;
    }

    public void retainAlphaBuffer() {
        JniCommon.nativeAddRef(this.nativeAlphaBuffer);
    }

    public void releaseAlphaBuffer() {
        JniCommon.nativeReleaseRef(this.nativeAlphaBuffer);
    }

    public void fillAlphaData(ByteBuffer buffer) {
        this.alphaBuffer = buffer;
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    @CalledByNative
    public void release() {
        this.buffer.release();
    }

    public static enum SourceType {
        kFrontCamera,
        kBackCamera,
        kUnspecified;

    }

    public static interface Buffer
    extends RefCounted {
        @CalledByNative(value="Buffer")
        public int getWidth();

        @CalledByNative(value="Buffer")
        public int getHeight();

        @CalledByNative(value="Buffer")
        public I420Buffer toI420();

        @CalledByNative(value="Buffer")
        public I010Buffer toI010();

        @Override
        @CalledByNative(value="Buffer")
        public void release();

        @Override
        @CalledByNative(value="Buffer")
        public void retain();

        @CalledByNative(value="Buffer")
        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);

        @CalledByNative(value="Buffer")
        @Nullable
        public Buffer mirror(int var1);

        @CalledByNative(value="Buffer")
        @Nullable
        public Buffer rotate(int var1);

        @CalledByNative(value="Buffer")
        @Nullable
        public Buffer transform(int var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }

    public static interface TextureBuffer
    extends Buffer {
        public Type getType();

        @CalledByNative(value="TextureBuffer")
        public int getTextureId();

        public Matrix getTransformMatrix();

        @CalledByNative(value="TextureBuffer")
        public EglBase.Context getEglBaseContext();

        @CalledByNative(value="TextureBuffer")
        public Object getSourceTexturePool();

        @CalledByNative(value="TextureBuffer")
        public long getNativeEglContext();

        @CalledByNative(value="TextureBuffer")
        public int getEglContextType();

        @CalledByNative(value="TextureBuffer")
        public float[] getTransformMatrixArray();

        @CalledByNative(value="TextureBuffer")
        public int getSequence();

        @CalledByNative(value="TextureBuffer")
        public long getFenceObject();

        @CalledByNative(value="TextureBuffer")
        public boolean is10BitTexture();

        public static enum ContextType {
            EGL_CONTEXT_10,
            EGL_CONTEXT_14;

        }

        public static enum Type {
            OES(36197),
            RGB(3553);

            private final int glTarget;

            private Type(int glTarget) {
                this.glTarget = glTarget;
            }

            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }

    public static interface RgbaBuffer
    extends Buffer {
        @CalledByNative(value="RgbaBuffer")
        public ByteBuffer getData();
    }

    public static interface P010Buffer
    extends Buffer {
        @CalledByNative(value="P010Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="P010Buffer")
        public ByteBuffer getDataUV();

        @CalledByNative(value="P010Buffer")
        public int getStrideY();

        @CalledByNative(value="P010Buffer")
        public int getStrideUV();
    }

    public static interface I422Buffer
    extends Buffer {
        @CalledByNative(value="I422Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I422Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I422Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I422Buffer")
        public int getStrideY();

        @CalledByNative(value="I422Buffer")
        public int getStrideU();

        @CalledByNative(value="I422Buffer")
        public int getStrideV();
    }

    public static interface I010Buffer
    extends Buffer {
        @CalledByNative(value="I010Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I010Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I010Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I010Buffer")
        public int getStrideY();

        @CalledByNative(value="I010Buffer")
        public int getStrideU();

        @CalledByNative(value="I010Buffer")
        public int getStrideV();
    }

    public static interface I420Buffer
    extends Buffer {
        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I420Buffer")
        public int getStrideY();

        @CalledByNative(value="I420Buffer")
        public int getStrideU();

        @CalledByNative(value="I420Buffer")
        public int getStrideV();
    }
}

