/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import io.agora.utils2.internal.CommonUtility;
import io.agora.utils2.internal.Logging;
import java.lang.ref.WeakReference;

public class PowerChangeReceiver
extends BroadcastReceiver {
    private static final String TAG = "PowerChangeReceiver";
    private WeakReference<CommonUtility> mCommonUtility;

    public PowerChangeReceiver(CommonUtility cu) {
        this.mCommonUtility = new WeakReference<CommonUtility>(cu);
    }

    public void onReceive(Context context, Intent intent) {
        CommonUtility cu = (CommonUtility)this.mCommonUtility.get();
        if (cu == null) {
            Logging.w(TAG, "rtc engine is not ready");
            return;
        }
        if (intent != null) {
            int level = intent.getIntExtra("level", -1);
            int scale = intent.getIntExtra("scale", -1);
            if (scale != 0) {
                float batteryPct = (float)level / (float)scale;
                cu.onPowerChange((int)(batteryPct * 100.0f));
            }
        }
    }
}

