/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.content.Intent;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.rtc2.video.FocalLengthInfo;
import io.agora.rtc2.video.IVideoCapture;
import io.agora.rtc2.video.IVideoCaptureCamera;
import io.agora.rtc2.video.VideoCapture;
import io.agora.rtc2.video.VideoCaptureCamera;
import io.agora.rtc2.video.VideoCaptureCamera1;
import io.agora.rtc2.video.VideoCaptureCamera2;
import io.agora.rtc2.video.VideoCaptureCameraFallbackWrapper;
import io.agora.rtc2.video.VideoCaptureFormat;
import io.agora.rtc2.video.VideoCaptureParameter;
import io.agora.rtc2.video.VideoCaptureScreen;
import java.util.Arrays;
import java.util.List;

class VideoCaptureFactory {
    private static final String TAG = "VideoCaptureFactory";
    private static boolean enableCamera2BlackList = true;
    private static final List<String> TEXTURE_EXCEPTION_MODELS = Arrays.asList("LG-H848", "Pixel 4a", "SM-A7000", "MI MAX");
    private static final List<String> TEMPLATETYPE_EXCEPTION_MODELS = Arrays.asList("PRA-AL00X");

    VideoCaptureFactory() {
    }

    private static boolean isLReleaseOrLater() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @CalledByNative
    static boolean isLegacyOrDeprecatedDevice(int index) {
        return !VideoCaptureFactory.isLReleaseOrLater() || VideoCaptureCamera2.isLegacyDevice(index) || VideoCaptureFactory.isInCamera2BlackList();
    }

    static boolean isLessSelectedLevel(int index, int selectedLevel) {
        if (-1 == selectedLevel) {
            return false;
        }
        int supportedLevel = VideoCaptureCamera2.getCamera2SupportedLevel(index);
        if (supportedLevel != Integer.MIN_VALUE) {
            return VideoCaptureCamera2.ANDROID_CAMERA_HARDWARE_LEVEL_MAP.get(supportedLevel) <= VideoCaptureCamera2.ANDROID_CAMERA_HARDWARE_LEVEL_MAP.get(selectedLevel, 1);
        }
        return true;
    }

    @CalledByNative
    static IVideoCapture createCameraCapture(int index, long nativeVideoCaptureDeviceAndroid, boolean captureToTexture, boolean enableTextureCopy, int captureTextureBufferCount, boolean pqFirst, int skipControl, EglBase.Context sharedContext, VideoCaptureParameter parameter) {
        boolean isLowLevelCamera;
        boolean isExceptionDevice;
        String level = VideoCaptureFactory.getCamera2SupportedLevel(index);
        boolean bl = isExceptionDevice = "RMX3231".equalsIgnoreCase(Build.MODEL) && VideoCaptureFactory.getDeviceName(index).contains("front");
        if (isExceptionDevice) {
            Logging.w(TAG, "Not support for " + Build.MODEL);
        }
        parameter.setCaptureToTexture(captureToTexture);
        Logging.w(TAG, "createVideoCapture() " + index + ", captureToTexture: " + parameter.captureToTexture + ", camera_selected: " + parameter.lowCameraSelected + ", camera_selected_level: " + parameter.hardwareLevelSelected + ", enableTextureCopy: " + enableTextureCopy + ", captureTextureBufferCount: " + captureTextureBufferCount + ", pqFirst: " + pqFirst + ", templateType: " + parameter.templateType + ", noiseReduction: " + parameter.noiseReduce + ", autoFaceDetect: " + parameter.faceFocusing + ", extraSurface: " + parameter.extraSurface + ", autoWhiteBalance: " + parameter.autoWhiteBalance + ", hardware level: " + level + " focalLengthType: " + parameter.focalLengthType + " physicalId: " + parameter.physicalId + " pqFirstCaptureMode: " + parameter.pqFirstCaptureMode + " pqFirstDiff: " + parameter.pqFirstDiff + " cameraTimeout: " + parameter.cameraTimeout + " customMinFps: " + parameter.customMinFps + " customMaxFps: " + parameter.customMaxFps + " enableTargetFps: " + parameter.enableTargetFps + " customStrictMode: " + parameter.customStrictMode + " lowFpsLimit: " + parameter.lowFpsLimit);
        VideoCaptureFactory.applyDeviceSpecificAdjustments(parameter);
        boolean bl2 = isLowLevelCamera = parameter.lowCameraSelected == 0 || VideoCaptureFactory.isLessSelectedLevel(index, parameter.hardwareLevelSelected) || -1 == parameter.lowCameraSelected && -1 == parameter.hardwareLevelSelected && (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index) || isExceptionDevice);
        if (isLowLevelCamera) {
            return new VideoCaptureCamera1(index, nativeVideoCaptureDeviceAndroid, parameter.captureToTexture, enableTextureCopy, captureTextureBufferCount, pqFirst, skipControl, sharedContext, parameter.templateType, parameter);
        }
        VideoCaptureCamera2 capturer = new VideoCaptureCamera2(index, nativeVideoCaptureDeviceAndroid, parameter.captureToTexture, enableTextureCopy, captureTextureBufferCount, pqFirst, skipControl, sharedContext, parameter.templateType, parameter);
        return VideoCaptureFactory.createFallbackWrapper(capturer, index, nativeVideoCaptureDeviceAndroid, enableTextureCopy, captureTextureBufferCount, pqFirst, skipControl, sharedContext, parameter);
    }

    static IVideoCaptureCamera createFallbackWrapper(IVideoCaptureCamera camera, final int index, final long nativeVideoCaptureDeviceAndroid, final boolean enableTextureCopy, final int captureTextureBufferCount, final boolean pqFirst, final int skipControl, final EglBase.Context sharedContext, final VideoCaptureParameter parameter) {
        return new VideoCaptureCameraFallbackWrapper(camera, new VideoCaptureCameraFallbackWrapper.OnCameraFallbackListener(){

            @Override
            public IVideoCaptureCamera createFallbackCamera() {
                parameter.setPhysicalId(-1);
                return new VideoCaptureCamera1(index, nativeVideoCaptureDeviceAndroid, parameter.captureToTexture, enableTextureCopy, captureTextureBufferCount, pqFirst, skipControl, sharedContext, parameter.templateType, parameter);
            }
        });
    }

    private static void applyDeviceSpecificAdjustments(VideoCaptureParameter parameter) {
        if (Build.MODEL.toLowerCase().contains("sony")) {
            Logging.i(TAG, "sony equipment, must use old mode.");
            parameter.setPqFirstCaptureMode(0);
        }
        if (TEXTURE_EXCEPTION_MODELS.contains(Build.MODEL)) {
            Logging.w(TAG, "Not support for " + Build.MODEL);
            parameter.setCaptureToTexture(false);
        }
        if (TEMPLATETYPE_EXCEPTION_MODELS.contains(Build.MODEL)) {
            Logging.w(TAG, "templateType use preview, model: " + Build.MODEL);
            parameter.setTemplateType(0);
        }
        if (Build.MODEL.toLowerCase().contains("cph1853") && parameter.getLowCameraSelected() == -1) {
            Logging.i(TAG, "cph1853 use camera2");
            parameter.setLowCameraSelected(1);
        }
    }

    @CalledByNative
    static VideoCapture createScreenCapture(long nativeVideoCaptureDeviceAndroid, EglBase.Context sharedContext, Intent mediaProjectionPermissionResultData) {
        return new VideoCaptureScreen(nativeVideoCaptureDeviceAndroid, sharedContext, mediaProjectionPermissionResultData);
    }

    @CalledByNative
    static int getNumberOfCameras() {
        return ChromiumCameraInfo.getNumberOfCameras();
    }

    @CalledByNative
    static void setCacheCameraNumbers(boolean enable) {
        ChromiumCameraInfo.setCacheCameraNumbers(enable);
    }

    @CalledByNative
    static int getCaptureApiType(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getCaptureApiType(index);
        }
        return VideoCaptureCamera2.getCaptureApiType(index);
    }

    @CalledByNative
    static String getCamera2SupportedLevel(int index) {
        String level = "legacy";
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return level;
        }
        int ret = VideoCaptureCamera2.getCamera2SupportedLevel(index);
        if (ret == 0) {
            level = "limited";
        } else if (ret == 1) {
            level = "full";
        } else if (ret == 3) {
            level = "level_3";
        } else if (ret == 4) {
            level = "external";
        }
        return level;
    }

    @CalledByNative
    static int getFacingMode(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getFacingMode(index);
        }
        return VideoCaptureCamera2.getFacingMode(index);
    }

    @Nullable
    @CalledByNative
    static String getDeviceId(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getDeviceId(index);
        }
        return VideoCaptureCamera2.getDeviceId(index);
    }

    @Nullable
    @CalledByNative
    static String getDeviceName(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getName(index);
        }
        return VideoCaptureCamera2.getName(index);
    }

    @Nullable
    @CalledByNative
    static List<VideoCaptureFormat> getDeviceSupportedFormats(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getDeviceSupportedFormats(index);
        }
        return VideoCaptureCamera2.getDeviceSupportedFormats(index);
    }

    @Nullable
    @CalledByNative
    static List<FocalLengthInfo> queryCameraFocalLengthCapability(int camera_selected, boolean skip_physical_camera) {
        if (!VideoCaptureFactory.isLReleaseOrLater() || VideoCaptureFactory.isInCamera2BlackList() || 0 == camera_selected) {
            return VideoCaptureCamera1.queryCameraFocalLengthCapability();
        }
        return VideoCaptureCamera2.queryCameraFocalLengthCapability(skip_physical_camera);
    }

    @CalledByNative
    static void enableCamera2BlackList(boolean enable) {
        enableCamera2BlackList = enable;
        Logging.w(TAG, "enableCamera2BlackList: " + enable);
    }

    @CalledByNative
    static void enableCameraCaptureRequestActiveDetect(boolean enable) {
        VideoCaptureCamera.enableCameraCaptureRequestActiveDetect(enable);
        Logging.w(TAG, "enableCameraCaptureRequestActiveDetect: " + enable);
    }

    @CalledByNative
    static void setCameraSkipCaptureWidth(int width) {
        VideoCaptureCamera.setCameraSkipCaptureWidth(width);
    }

    @CalledByNative
    static void setCameraSkipCaptureHeight(int height) {
        VideoCaptureCamera.setCameraSkipCapturHeight(height);
    }

    static boolean isInCamera2BlackList() {
        if (!enableCamera2BlackList) {
            return false;
        }
        if ("ocean".equalsIgnoreCase(Build.DEVICE) && "oe106".equalsIgnoreCase(Build.MODEL)) {
            return true;
        }
        if ("trident".equalsIgnoreCase(Build.DEVICE) && "de106".equalsIgnoreCase(Build.MODEL)) {
            return true;
        }
        if ("shark".equalsIgnoreCase(Build.DEVICE) && "skr-a0".equalsIgnoreCase(Build.MODEL)) {
            return true;
        }
        if ("hnnem-h".equalsIgnoreCase(Build.DEVICE)) {
            return true;
        }
        if ("on7xelte".equals(Build.DEVICE) && "SM-G610F".equals(Build.MODEL)) {
            return true;
        }
        if ("m2c".equals(Build.DEVICE) || "M578CA".equals(Build.MODEL)) {
            return true;
        }
        if ("samsung".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && (Build.MODEL.contains("SM-G930") || Build.MODEL.contains("SM-G935") || Build.MODEL.contains("SM-G950") || Build.MODEL.contains("SM-G955") || "SC-02H".equals(Build.MODEL) || "SCV33".equals(Build.MODEL) || "SC-02J".equals(Build.MODEL) || "SCV36".equals(Build.MODEL) || "SM-G892A".equals(Build.MODEL) || "SM-G892U".equals(Build.MODEL) || "SC-03J".equals(Build.MODEL) || "SCV35".equals(Build.MODEL))) {
            return true;
        }
        if ("oneplus".equalsIgnoreCase(Build.MANUFACTURER)) {
            return true;
        }
        if ("PCAM00".equalsIgnoreCase(Build.MODEL)) {
            return true;
        }
        return "h8296".equalsIgnoreCase(Build.MODEL);
    }

    static @interface CAMERA_MODULE_SELECTED {
        public static final int ANDROID_CAMERA_AUTO = -1;
        public static final int ANDROID_CAMERA1 = 0;
        public static final int ANDROID_CAMERA2 = 1;
    }

    static class ChromiumCameraInfo {
        private static int sNumberOfSystemCameras = -1;
        private static boolean enableCameraCacheNumbers = true;

        ChromiumCameraInfo() {
        }

        private static void setCacheCameraNumbers(boolean enable) {
            Logging.w(VideoCaptureFactory.TAG, "setCacheCameraNumbers: " + enable);
            enableCameraCacheNumbers = enable;
        }

        static boolean getCameraCacheNumbers() {
            return enableCameraCacheNumbers;
        }

        private static int getNumberOfCameras() {
            if (sNumberOfSystemCameras <= 0 || !enableCameraCacheNumbers) {
                if (ContextUtils.getApplicationContext() == null) {
                    Logging.e(VideoCaptureFactory.TAG, "getNumberOfCameras error, context null");
                    return sNumberOfSystemCameras;
                }
                try {
                    if (Build.VERSION.SDK_INT < 23 && ContextUtils.getApplicationContext().getPackageManager().checkPermission("android.permission.CAMERA", ContextUtils.getApplicationContext().getPackageName()) != 0) {
                        sNumberOfSystemCameras = 0;
                        Logging.w(VideoCaptureFactory.TAG, "Missing android.permission.CAMERA permission, no system camera available.");
                    } else {
                        sNumberOfSystemCameras = VideoCaptureFactory.isLReleaseOrLater() ? VideoCaptureCamera2.getNumberOfCameras() : VideoCaptureCamera1.getNumberOfCameras();
                        Logging.i(VideoCaptureFactory.TAG, "getMaxNumberOfCameras: " + sNumberOfSystemCameras);
                    }
                }
                catch (Exception ex) {
                    Logging.e(VideoCaptureFactory.TAG, "getNumberOfCameras Exception: " + ex);
                }
            }
            return sNumberOfSystemCameras;
        }
    }
}

