/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Matrix;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.HdrUtil;
import io.agora.base.internal.video.IHandlerReplaceable;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.base.internal.video.TextureBufferPool;
import io.agora.base.internal.video.YuvConverter;
import java.util.concurrent.Callable;
import javax.microedition.khronos.egl.EGLContext;

public class VideoFrameSenderExImpl {
    private static final String TAG = "VideoFrameSenderEx";
    @Nullable
    private EglBase.Context eglContext = null;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper = null;
    @Nullable
    private Handler toI420Handler = null;
    @Nullable
    private YuvConverter yuvConverter = null;
    private boolean enableTextureCopy = false;
    private int textureBufferCount = 4;
    private final Object surfaceTextureHelperLock = new Object();
    private long prevFenceObject = 0L;

    static EglBase.Context createEglBaseContext(Object sharedEglContext) {
        EglBase.Context eglContext;
        if (sharedEglContext instanceof EglBase.Context) {
            eglContext = (EglBase.Context)sharedEglContext;
        } else if (sharedEglContext instanceof EGLContext) {
            eglContext = new EglBase10.Context((EGLContext)sharedEglContext);
        } else if (Build.VERSION.SDK_INT >= 17 && sharedEglContext instanceof android.opengl.EGLContext) {
            eglContext = new EglBase14.Context((android.opengl.EGLContext)sharedEglContext);
        } else {
            throw new IllegalArgumentException("illegal egl context");
        }
        return eglContext;
    }

    @CalledByNative
    VideoFrameSenderExImpl() {
        Logging.i(TAG, "constructor() enableTextureCopy:" + this.enableTextureCopy);
    }

    @Nullable
    @CalledByNative
    VideoFrame.Buffer reconstructTextureBuffer(VideoFrame.Buffer buffer, int transfer) {
        if (!(buffer instanceof IHandlerReplaceable) && !(buffer instanceof VideoFrame.TextureBuffer)) {
            return buffer;
        }
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.invoke(new Callable<Void>(){

                @Override
                public Void call() {
                    TextureBufferPool.deleteFenceObject(VideoFrameSenderExImpl.this.prevFenceObject, "VideoFrameSenderExImpl");
                    return null;
                }
            });
        }
        if (((VideoFrame.TextureBuffer)buffer).getFenceObject() != 0L) {
            this.prevFenceObject = ((VideoFrame.TextureBuffer)buffer).getFenceObject();
        }
        if (this.enableTextureCopy && !HdrUtil.is10BitLumaDepth(transfer)) {
            if (!this.reInitSurfaceTextureHelperIfNeed(((VideoFrame.TextureBuffer)buffer).getEglBaseContext(), transfer)) {
                return null;
            }
            VideoFrame.Buffer newBuffer = this.copyToNewTextureBuffer(buffer, transfer);
            return newBuffer;
        }
        IHandlerReplaceable replaceable = (IHandlerReplaceable)((Object)buffer);
        if (replaceable.getToI420Handler() != null && replaceable.getYuvConverter() != null) {
            return buffer;
        }
        VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
        EglBase.Context context = textureBuffer.getEglBaseContext();
        if (!this.reInitSurfaceTextureHelperIfNeed(context, transfer)) {
            return null;
        }
        if (this.toI420Handler != null && this.yuvConverter != null) {
            return replaceable.applyNewI420Handler(this.toI420Handler, this.yuvConverter);
        }
        Logging.e(TAG, "converter null");
        return null;
    }

    @Nullable
    @CalledByNative
    VideoFrame.Buffer newTextureBuffer(Object sharedEglContext, int width, int height, int pixelFormat, int id, long fence_object, float[] transformMatrix) {
        VideoFrame.TextureBuffer.Type type;
        EglBase.Context eglContext = VideoFrameSenderExImpl.createEglBaseContext(sharedEglContext);
        if (pixelFormat == 10) {
            type = VideoFrame.TextureBuffer.Type.RGB;
        } else if (pixelFormat == 11) {
            type = VideoFrame.TextureBuffer.Type.OES;
        } else {
            throw new IllegalArgumentException("illegal pixel format");
        }
        if (transformMatrix.length != 16) {
            throw new IllegalArgumentException("unsupported matrix");
        }
        Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix);
        TextureBuffer textureBuffer = new TextureBuffer(eglContext, width, height, type, id, fence_object, matrix, null, null, null);
        VideoFrame.Buffer result = this.reconstructTextureBuffer(textureBuffer, 0);
        textureBuffer.release();
        return result;
    }

    @Nullable
    private VideoFrame.Buffer copyToNewTextureBuffer(VideoFrame.Buffer originBuffer, int transfer) {
        if (!(originBuffer instanceof IHandlerReplaceable) && !(originBuffer instanceof VideoFrame.TextureBuffer)) {
            return originBuffer;
        }
        VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)originBuffer;
        IHandlerReplaceable replaceable = (IHandlerReplaceable)((Object)originBuffer);
        EglBase.Context context = textureBuffer.getEglBaseContext();
        boolean result = this.getSurfaceTextureHelper(context, transfer);
        if (!result) {
            Logging.e(TAG, "Failed to create surfaceTextureHelper in copyToNewTextureBuffer");
            return null;
        }
        VideoFrame.Buffer newTextureBuffer = replaceable.applyNewI420Handler(this.toI420Handler, this.yuvConverter);
        if (this.enableTextureCopy && !HdrUtil.is10BitLumaDepth(transfer)) {
            VideoFrame.TextureBuffer textureBufferCopy = this.surfaceTextureHelper.textureCopy((VideoFrame.TextureBuffer)newTextureBuffer, transfer);
            return textureBufferCopy;
        }
        return newTextureBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSurfaceTextureHelper(@NonNull EglBase.Context context, int transfer) {
        Object object = this.surfaceTextureHelperLock;
        synchronized (object) {
            if (this.surfaceTextureHelper != null) {
                return true;
            }
            Logging.e(TAG, "getSurfaceTextureHelper, transfer: " + transfer);
            this.surfaceTextureHelper = SurfaceTextureHelper.create("VideoFrameSender", context, this.textureBufferCount, transfer);
            if (this.surfaceTextureHelper == null) {
                Logging.e(TAG, "Failed to create surfaceTextureHelper");
                return false;
            }
            this.toI420Handler = this.surfaceTextureHelper.getHandler();
            this.yuvConverter = new YuvConverter();
            return true;
        }
    }

    private boolean reInitSurfaceTextureHelperIfNeed(EglBase.Context bufferBindContext, int transfer) {
        boolean result;
        boolean contextChanged;
        boolean bl = contextChanged = this.eglContext == null || !this.eglContext.equals(bufferBindContext);
        return !contextChanged || (result = this.reInitSurfaceTextureHelper(bufferBindContext, transfer));
    }

    private boolean reInitSurfaceTextureHelper(@NonNull EglBase.Context context, int transfer) {
        boolean result;
        Logging.i(TAG, "reInitI420Converter()");
        if (this.surfaceTextureHelper != null) {
            this.dispose();
        }
        if (!(result = this.getSurfaceTextureHelper(context, transfer))) {
            Logging.e(TAG, "Failed to create surfaceTextureHelper in reInitI420Converter");
            return false;
        }
        this.eglContext = context;
        return true;
    }

    @CalledByNative
    private void enableTextureCopy(boolean enable) {
        Logging.i(TAG, "enableTextureCopy new:" + enable + ", old:" + this.enableTextureCopy);
        this.enableTextureCopy = enable;
    }

    @CalledByNative
    private void setTextureBufferCount(int count) {
        Logging.i(TAG, "setTextureBufferCount bufferCount:" + count);
        this.textureBufferCount = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    void dispose() {
        Logging.i(TAG, "dispose()");
        Object object = this.surfaceTextureHelperLock;
        synchronized (object) {
            if (this.toI420Handler != null) {
                try {
                    ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Runnable(){

                        @Override
                        public void run() {
                            if (VideoFrameSenderExImpl.this.prevFenceObject != 0L) {
                                TextureBufferPool.deleteFenceObject(VideoFrameSenderExImpl.this.prevFenceObject, "VideoFrameSenderExImpl");
                            }
                            VideoFrameSenderExImpl.this.yuvConverter.release();
                        }
                    });
                }
                catch (Exception e) {
                    Logging.e(TAG, "yuvConverter release failed:" + e.toString());
                }
            }
            if (this.surfaceTextureHelper != null) {
                this.surfaceTextureHelper.dispose();
                this.surfaceTextureHelper = null;
            }
        }
    }

    static @interface VIDEO_PIXEL_FORMAT {
        public static final int VIDEO_TEXTURE_2D = 10;
        public static final int VIDEO_TEXTURE_OES = 11;
    }
}

