/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import java.util.HashSet;
import java.util.Set;

enum VideoCodecType {
    VP8("video/x-vnd.on2.vp8"),
    VP9("video/x-vnd.on2.vp9"),
    H264("video/avc"),
    H265("video/hevc"),
    AV1("video/av01"),
    UNKNOWN("video/unknown");

    private static Set<String> _values;
    private final String mimeType;

    private VideoCodecType(String mimeType) {
        this.mimeType = mimeType;
    }

    String mimeType() {
        return this.mimeType;
    }

    public static boolean contains(String value) {
        return _values.contains(value);
    }

    static {
        _values = new HashSet<String>();
        for (VideoCodecType choice : VideoCodecType.values()) {
            _values.add(choice.name());
        }
    }
}

