/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import androidx.annotation.Nullable;
import io.agora.base.JavaI420Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.RefCountDelegate;
import java.nio.ByteBuffer;

public class NV21Buffer
implements VideoFrame.Buffer {
    private final byte[] data;
    private final int width;
    private final int height;
    private final RefCountDelegate refCountDelegate;
    private int sliceHeight;
    private int stride;

    public NV21Buffer(byte[] data, int width, int height, @Nullable Runnable releaseCallback) {
        this.data = data;
        this.width = width;
        this.height = height;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    public NV21Buffer(int width, int height, int stride, int sliceHeight, ByteBuffer buffer, @Nullable Runnable releaseCallback) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        this.width = width;
        this.height = height;
        this.stride = stride;
        this.sliceHeight = sliceHeight;
        this.data = new byte[buffer.remaining()];
        buffer.get(this.data, 0, this.data.length);
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    @Override
    @Nullable
    public VideoFrame.I010Buffer toI010() {
        return null;
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(scaleWidth, scaleHeight);
        int w = this.stride == 0 ? this.width : this.stride;
        int h = this.sliceHeight == 0 ? this.height : this.sliceHeight;
        NV21Buffer.nativeCropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight, this.data, w, h, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV());
        return newBuffer;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer mirror(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer rotate(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer transform(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int rotation) {
        return null;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, ByteBuffer var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14);
}

