/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.live;

import io.agora.rtc2.video.AgoraImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LiveTranscoding {
    public int width = 360;
    public int height = 640;
    public int videoBitrate = 400;
    public int videoFramerate = 15;
    @Deprecated
    public boolean lowLatency = false;
    public int videoGop = 30;
    private ArrayList<AgoraImage> watermarkList;
    private ArrayList<AgoraImage> backgroundImageList;
    public AudioSampleRateType audioSampleRate;
    public int audioBitrate = 48;
    public int audioChannels = 1;
    public AudioCodecProfileType audioCodecProfile;
    public VideoCodecProfileType videoCodecProfile = VideoCodecProfileType.HIGH;
    public VideoCodecType videoCodecType = VideoCodecType.H264;
    @Deprecated
    public int userCount;
    @Deprecated
    public int backgroundColor = -16777216;
    public String userConfigExtraInfo = null;
    @Deprecated
    public String metadata = null;
    private Map<Integer, TranscodingUser> transcodingUsers;
    private Map<String, Boolean> advancedFeatures;

    public void addWatermark(AgoraImage watermark) {
        if (this.watermarkList == null) {
            this.watermarkList = new ArrayList();
        }
        this.watermarkList.add(watermark);
    }

    public boolean removeWatermark(AgoraImage watermark) {
        if (this.watermarkList == null) {
            return false;
        }
        return this.watermarkList.remove(watermark);
    }

    public ArrayList<AgoraImage> getWatermarkList() {
        return this.watermarkList;
    }

    public void addBackgroundImage(AgoraImage backgroundImage) {
        if (this.backgroundImageList == null) {
            this.backgroundImageList = new ArrayList();
        }
        this.backgroundImageList.add(backgroundImage);
    }

    public boolean removeBackgroundImage(AgoraImage backgroundImage) {
        if (this.backgroundImageList == null) {
            return false;
        }
        return this.backgroundImageList.remove(backgroundImage);
    }

    public ArrayList<AgoraImage> getBackgroundImageList() {
        return this.backgroundImageList;
    }

    public void setAdvancedFeatures(String featureName, Boolean opened) {
        this.advancedFeatures.put(featureName, opened);
    }

    public Map<String, Boolean> getAdvancedFeatures() {
        return this.advancedFeatures;
    }

    public LiveTranscoding() {
        this.audioSampleRate = AudioSampleRateType.TYPE_44100;
        this.audioCodecProfile = AudioCodecProfileType.LC_AAC;
        this.advancedFeatures = new HashMap<String, Boolean>();
        this.transcodingUsers = new HashMap<Integer, TranscodingUser>();
    }

    public int addUser(TranscodingUser user) {
        if (user == null) {
            return -2;
        }
        this.transcodingUsers.put(user.uid, user);
        this.userCount = this.transcodingUsers.size();
        return 0;
    }

    public final ArrayList<TranscodingUser> getUsers() {
        Collection<TranscodingUser> values = this.transcodingUsers.values();
        return new ArrayList<TranscodingUser>(values);
    }

    public void setUsers(ArrayList<TranscodingUser> users) {
        this.transcodingUsers.clear();
        if (users != null) {
            for (TranscodingUser user : users) {
                this.transcodingUsers.put(user.uid, user);
            }
        }
        this.userCount = this.transcodingUsers.size();
    }

    public void setUsers(Map<Integer, TranscodingUser> users) {
        this.transcodingUsers.clear();
        if (users != null) {
            this.transcodingUsers.putAll(users);
        }
        this.userCount = this.transcodingUsers.size();
    }

    public int removeUser(int uid) {
        if (!this.transcodingUsers.containsKey(uid)) {
            return -2;
        }
        this.transcodingUsers.remove(uid);
        this.userCount = this.transcodingUsers.size();
        return 0;
    }

    public int getUserCount() {
        return this.transcodingUsers.size();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
    }

    public void setBackgroundColor(int red, int green, int blue) {
        this.backgroundColor = red << 16 | green << 8 | blue;
    }

    @Deprecated
    public int getRed() {
        return this.backgroundColor >> 16 & 0xFF;
    }

    @Deprecated
    public int getGreen() {
        return this.backgroundColor >> 8 & 0xFF;
    }

    @Deprecated
    public int getBlue() {
        return this.backgroundColor & 0xFF;
    }

    @Deprecated
    public void setRed(int red) {
        int green = this.getGreen();
        int blue = this.getBlue();
        this.backgroundColor = red << 16 | green << 8 | blue;
    }

    @Deprecated
    public void setGreen(int green) {
        int red = this.getRed();
        int blue = this.getBlue();
        this.backgroundColor = red << 16 | green << 8 | blue;
    }

    @Deprecated
    public void setBlue(int blue) {
        int red = this.getRed();
        int green = this.getGreen();
        this.backgroundColor = red << 16 | green << 8 | blue;
    }

    public static enum VideoCodecProfileType {
        BASELINE(66),
        MAIN(77),
        HIGH(100);

        private int value;

        private VideoCodecProfileType(int v) {
            this.value = v;
        }

        public static int getValue(VideoCodecProfileType type) {
            return type.value;
        }
    }

    public static enum VideoCodecType {
        H264(1),
        H265(2);

        private int value;

        private VideoCodecType(int v) {
            this.value = v;
        }

        public static int getValue(VideoCodecType type) {
            return type.value;
        }
    }

    public static enum AudioSampleRateType {
        TYPE_32000(32000),
        TYPE_44100(44100),
        TYPE_48000(48000);

        private int value;

        private AudioSampleRateType(int v) {
            this.value = v;
        }

        public static int getValue(AudioSampleRateType type) {
            return type.value;
        }
    }

    public static enum AudioCodecProfileType {
        LC_AAC(0),
        HE_AAC(1),
        HE_AAC_V2(2);

        private int value;

        private AudioCodecProfileType(int v) {
            this.value = v;
        }

        public static int getValue(AudioCodecProfileType type) {
            return type.value;
        }
    }

    public static class TranscodingUser {
        public int uid = 0;
        public String userId;
        public int x;
        public int y;
        public int width;
        public int height;
        public int zOrder;
        public float alpha = 1.0f;
        public int audioChannel;
    }
}

