/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal.gdp;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import io.agora.utils2.internal.Logging;

public final class EglCore {
    private static final String TAG = "EglCore";
    private static boolean mockNonEGLContext = false;
    public static final int FLAG_RECORDABLE = 1;
    public static final int FLAG_TRY_GLES3 = 2;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;

    public static void setMockNonEGLContext(boolean mock) {
        mockNonEGLContext = mock;
    }

    public EglCore() {
        this(null, 0);
    }

    public EglCore(EGLContext sharedContext, int flags) {
        EGLContext context;
        EGLConfig config;
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            throw new IllegalStateException("EGL already set up");
        }
        if (sharedContext == null) {
            sharedContext = EGL14.EGL_NO_CONTEXT;
        }
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new IllegalStateException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEGLDisplay = null;
            throw new IllegalStateException("unable to initialize EGL14");
        }
        if ((flags & 2) != 0 && (config = this.getConfig(flags, 3)) != null) {
            int[] attrib3_list = new int[]{12440, 3, 12344};
            context = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (EGLContext)sharedContext, (int[])attrib3_list, (int)0);
            if (EGL14.eglGetError() == 12288) {
                this.mEGLConfig = config;
                this.mEGLContext = context;
            }
        }
        if (this.mEGLContext == EGL14.EGL_NO_CONTEXT || mockNonEGLContext) {
            config = this.getConfig(flags, 2);
            if (config == null) {
                throw new IllegalStateException("Unable to find a suitable EGLConfig");
            }
            int[] attrib2_list = new int[]{12440, 2, 12344};
            context = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (EGLContext)sharedContext, (int[])attrib2_list, (int)0);
            this.checkEglError("eglCreateContext");
            this.mEGLConfig = config;
            this.mEGLContext = context;
        }
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])values, (int)0);
        Logging.d(TAG, "EGLContext created, client version " + values[0]);
    }

    public EGLConfig getConfig(int flags, int version) {
        int[] numConfigs;
        EGLConfig[] configs;
        int renderableType = 4;
        if (version >= 3) {
            renderableType |= 0x40;
        }
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, renderableType, 12344, 0, 12344};
        if ((flags & 1) != 0) {
            attribList[attribList.length - 3] = 12610;
            attribList[attribList.length - 2] = 1;
        }
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])attribList, (int)0, (EGLConfig[])(configs = new EGLConfig[1]), (int)0, (int)configs.length, (int[])(numConfigs = new int[1]), (int)0)) {
            Logging.d(TAG, "unable to find RGB8888 / " + version + " EGLConfig");
            return null;
        }
        return configs[0];
    }

    public void release() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLConfig = null;
    }

    public void releaseSurface(EGLSurface eglSurface) {
        EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface);
    }

    public EGLSurface createOffscreenSurface(int width, int height) {
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        EGLSurface eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])surfaceAttribs, (int)0);
        this.checkEglError("eglCreatePbufferSurface");
        if (eglSurface == null) {
            throw new NullPointerException("surface was null");
        }
        return eglSurface;
    }

    public void makeCurrent(EGLSurface eglSurface) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            Logging.d(TAG, "NOTE: makeCurrent w/o display");
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (EGLSurface)eglSurface, (EGLContext)this.mEGLContext)) {
            throw new IllegalStateException("eglMakeCurrent failed");
        }
    }

    public void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new IllegalStateException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }
}

