/*
 * Decompiled with CFR 0.152.
 */
package io.agora.meta.internal;

import android.view.TextureView;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.meta.EnterSceneConfig;
import io.agora.meta.ILocalUserAvatar;
import io.agora.meta.IMetaScene;
import io.agora.meta.IMetaSceneEventHandler;
import io.agora.meta.SceneDisplayConfig;
import io.agora.meta.internal.LocalUserAvatarImpl;
import io.agora.rtc2.video.AgoraVideoFrame;
import io.agora.utils2.internal.Logging;
import java.util.concurrent.atomic.AtomicBoolean;

public class MetaSceneImpl
extends IMetaScene {
    private static final String TAG = MetaSceneImpl.class.getSimpleName();
    private long mNativeHandle = 0L;
    private final ILocalUserAvatar mLocalUserAvatar;
    private final AtomicBoolean mIsDestroying = new AtomicBoolean(false);

    @CalledByNative
    MetaSceneImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mLocalUserAvatar = new LocalUserAvatarImpl(this.nativeGetLocalUserAvatar(this.mNativeHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILocalUserAvatar getLocalUserAvatar() {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(getLocalUserAvatar)");
            return null;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (getLocalUserAvatar)");
                return null;
            }
            return this.mLocalUserAvatar;
        }
    }

    @Override
    public int release() {
        if (this.mNativeHandle != 0L) {
            this.mIsDestroying.set(true);
            MetaSceneImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
            this.mIsDestroying.set(false);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addEventHandler(IMetaSceneEventHandler eventHandler) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(addEventHandler)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (addEventHandler)");
                return -7;
            }
            return this.nativeAddEventHandler(this.mNativeHandle, eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeEventHandler(IMetaSceneEventHandler eventHandler) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(removeEventHandler)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (removeEventHandler)");
                return -7;
            }
            return this.nativeRemoveEventHandler(this.mNativeHandle, eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enterScene(EnterSceneConfig config) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(enterScene)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (enterScene)");
                return -7;
            }
            return this.nativeEnterScene(this.mNativeHandle, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int leaveScene() {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(leaveScene)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (leaveScene)");
                return -7;
            }
            return this.nativeLeaveScene(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendSceneMessage(byte[] message) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(sendSceneMessage)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (sendSceneMessage)");
                return -7;
            }
            return this.nativeSendSceneMessage(this.mNativeHandle, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setSceneParameters(String jsonParam) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(setSceneParameters)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (setSceneParameters)");
                return -7;
            }
            return this.nativeSetSceneParameters(this.mNativeHandle, jsonParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableVideoDisplay(String displayId, boolean enable) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(enableVideoDisplay)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (enableVideoDisplay)");
                return -7;
            }
            return this.nativeEnableVideoDisplay(this.mNativeHandle, displayId, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pushVideoFrameToDisplay(String displayId, VideoFrame frame) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(pushVideoFrameToDisplay(VideoFrame))");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (pushVideoFrameToDisplay)");
                return -7;
            }
            return this.nativePushVideoFrameToDisplay(this.mNativeHandle, displayId, frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pushVideoFrameToDisplay(String displayId, AgoraVideoFrame frame) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(pushVideoFrameToDisplay(AgoraVideoFrame))");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (pushVideoFrameToDisplay)");
                return -7;
            }
            return this.nativePushAgoraVideoFrameToDisplay(this.mNativeHandle, displayId, frame.format, frame.buf, frame.stride, frame.height, frame.timeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addSceneView(TextureView view, SceneDisplayConfig config) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(addSceneView)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (addSceneView)");
                return -7;
            }
            return this.nativeAddSceneView(this.mNativeHandle, view, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeSceneView(TextureView view) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(removeSceneView)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (removeSceneView)");
                return -7;
            }
            return this.nativeRemoveSceneView(this.mNativeHandle, view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableSceneVideoCapture(TextureView view, boolean enable) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(enableSceneVideoCapture)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (enableSceneVideoCapture)");
                return -7;
            }
            return this.nativeEnableSceneVideoCapture(this.mNativeHandle, view, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableFaceCapture(boolean enable) {
        if (this.mIsDestroying.get()) {
            Logging.e(TAG, "MetaScene is destroying(enableFaceCapture)");
            return -8;
        }
        MetaSceneImpl metaSceneImpl = this;
        synchronized (metaSceneImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "MetaScene does not initialize or it may be destroyed (enableFaceCapture)");
                return -7;
            }
            return this.nativeEnableFaceCapture(this.mNativeHandle, enable);
        }
    }

    private native long nativeGetLocalUserAvatar(long var1);

    private static native int nativeDestroy(long var0);

    private native int nativeAddEventHandler(long var1, Object var3);

    private native int nativeRemoveEventHandler(long var1, Object var3);

    private native int nativeEnterScene(long var1, EnterSceneConfig var3);

    private native int nativeLeaveScene(long var1);

    private native int nativeSendSceneMessage(long var1, byte[] var3);

    private native int nativeSetSceneParameters(long var1, String var3);

    private native int nativeEnableVideoDisplay(long var1, String var3, boolean var4);

    private native int nativePushVideoFrameToDisplay(long var1, String var3, VideoFrame var4);

    private native int nativePushAgoraVideoFrameToDisplay(long var1, String var3, int var4, byte[] var5, int var6, int var7, long var8);

    private native int nativeAddSceneView(long var1, TextureView var3, SceneDisplayConfig var4);

    private native int nativeRemoveSceneView(long var1, TextureView var3);

    private native int nativeEnableSceneVideoCapture(long var1, TextureView var3, boolean var4);

    private native int nativeEnableFaceCapture(long var1, boolean var3);
}

