/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import io.agora.base.JavaI010Buffer;
import io.agora.base.JavaP010Buffer;
import io.agora.base.NV12Buffer;
import io.agora.base.NV21Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;

public class TextureBufferUtil {
    @CalledByNative
    public static int getVideoFrameBufferType(VideoFrame.Buffer buffer) {
        if (buffer instanceof VideoFrame.I420Buffer) {
            return 0;
        }
        if (buffer instanceof NV12Buffer) {
            return 4;
        }
        if (buffer instanceof NV21Buffer) {
            return 3;
        }
        if (buffer instanceof VideoFrame.TextureBuffer) {
            VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
            if (VideoFrame.TextureBuffer.Type.OES.equals((Object)textureBuffer.getType())) {
                return 1;
            }
            if (VideoFrame.TextureBuffer.Type.RGB.equals((Object)textureBuffer.getType())) {
                return 2;
            }
        } else {
            if (buffer instanceof VideoFrame.I422Buffer) {
                return 5;
            }
            if (buffer instanceof VideoFrame.RgbaBuffer) {
                return 6;
            }
            if (buffer instanceof JavaI010Buffer) {
                return 7;
            }
            if (buffer instanceof JavaP010Buffer) {
                return 10;
            }
        }
        throw new IllegalStateException("unknown buffer type");
    }

    public static @interface BufferType {
        public static final int I420 = 0;
        public static final int OES_TEXTURE = 1;
        public static final int RGB_TEXTURE = 2;
        public static final int NV21 = 3;
        public static final int NV12 = 4;
        public static final int I422 = 5;
        public static final int RGBA = 6;
        public static final int I010 = 7;
        public static final int P010 = 10;
    }
}

