/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import android.util.SparseArray;
import io.agora.base.IMetaInfo;
import io.agora.base.internal.CalledByNative;
import java.util.HashMap;
import java.util.Map;

public final class VideoFrameMetaInfo {
    private Map<String, SparseArray<IMetaInfo>> mMetaMap;

    private Map<String, SparseArray<IMetaInfo>> getMetaMap() {
        if (this.mMetaMap == null) {
            this.mMetaMap = new HashMap<String, SparseArray<IMetaInfo>>();
        }
        return this.mMetaMap;
    }

    public int setCustomMetaInfo(IMetaInfo[] metas) {
        if (metas == null || metas.length == 0) {
            return -1;
        }
        String tag = metas[0].getTag();
        SparseArray<IMetaInfo> metaArray = this.getCustomMetaInfo(tag);
        for (IMetaInfo meta : metas) {
            metaArray.put(meta.getId(), (Object)meta);
        }
        return 0;
    }

    @CalledByNative
    public SparseArray<IMetaInfo> getCustomMetaInfo(String tag) {
        if (!this.getMetaMap().containsKey(tag)) {
            this.mMetaMap.put(tag, (SparseArray<IMetaInfo>)new SparseArray());
        }
        return this.mMetaMap.get(tag);
    }

    @CalledByNative
    public int getCustomMetaInfoSize(String tag) {
        return this.getCustomMetaInfo(tag).size();
    }

    @CalledByNative
    public IMetaInfo getCustomMetaInfoAt(String tag, int index) {
        if (!this.getMetaMap().containsKey(tag) || this.getMetaMap().get(tag).size() < index + 1) {
            return null;
        }
        return (IMetaInfo)this.getMetaMap().get(tag).get(index);
    }

    public String toString() {
        if (this.getMetaMap().isEmpty()) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("VideoFrameMetaInfo{\n");
        for (String tag : this.getMetaMap().keySet()) {
            stringBuilder.append(tag).append(": [\n");
            for (int i = 0; i < this.getCustomMetaInfoSize(tag); ++i) {
                stringBuilder.append(tag).append(this.getCustomMetaInfoAt(tag, i)).append(", \n");
            }
            stringBuilder.append(tag).append(": ]\n");
        }
        return stringBuilder.toString();
    }
}

