/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Handler;
import io.agora.base.internal.CalledByNative;
import io.agora.utils2.internal.CommonUtility;
import io.agora.utils2.internal.Logging;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class NetworkTracker {
    public static final int Internet_WIFI = 0;
    public static final int Internet_CELLULAR = 1;
    public static final int Internet_ETHERNET = 2;
    public static final int Internet_BLUETOOTH = 3;
    public static final int Internet_USB = 4;
    public static final int Internet_SATELLITE = 5;
    public static final int Internet_UNKNOWN = 6;
    public static final int Multipath_Uninitialized = 0;
    public static final int Multipath_Enabled = 1;
    public static final int Multipath_No_Permission = 2;
    public static final int Multipath_Version_Under24 = 3;
    private static final String TAG = "NWTracker";
    private final WeakReference<CommonUtility> mCommonUtilityRef;
    private final WeakReference<Context> mContextRef;
    private final WeakReference<Handler> mHandlerRef;
    private int mMultipathDisabledReason = 0;
    private ConnectivityManager.NetworkCallback mDefaultCallback = null;
    private ConnectivityManager.NetworkCallback mCellularCallback = null;
    private final Map<Network, ActiveNetworkInfo> mActiveNetworks = new HashMap<Network, ActiveNetworkInfo>();
    private Network mDefaultNetwork = null;
    private int mNetworkId = 1;

    NetworkTracker(CommonUtility utility, Context context, Handler handler) {
        this.mCommonUtilityRef = new WeakReference<CommonUtility>(utility);
        this.mContextRef = new WeakReference<Context>(context);
        this.mHandlerRef = new WeakReference<Handler>(handler);
    }

    public int GetMultipathDisabledReason() {
        return this.mMultipathDisabledReason;
    }

    public void StartTrack() {
        if (Build.VERSION.SDK_INT < 24) {
            this.mMultipathDisabledReason = 3;
            Logging.w(TAG, "android version not support multipath");
            return;
        }
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Logging.w(TAG, "context is null");
            return;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            this.mDefaultCallback = this.CreateNetworkCallback(true);
            connectivityManager.registerDefaultNetworkCallback(this.mDefaultCallback);
        }
        catch (Exception e) {
            this.mMultipathDisabledReason = 2;
            Logging.w(TAG, "not support multipath, registerDefaultNetworkCallback failed: " + e.toString());
            return;
        }
        if (!this.RequestForCellular()) {
            return;
        }
        this.mMultipathDisabledReason = 1;
        Logging.i(TAG, "support multipath");
    }

    public void StopTrack() {
        Logging.i(TAG, "StopTrack, multipath is " + (this.mMultipathDisabledReason == 1 ? "supported" : "not supported"));
        this.mMultipathDisabledReason = 0;
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (this.mDefaultCallback != null) {
            connectivityManager.unregisterNetworkCallback(this.mDefaultCallback);
            this.mDefaultCallback = null;
        }
        if (this.mCellularCallback != null) {
            connectivityManager.unregisterNetworkCallback(this.mCellularCallback);
            this.mCellularCallback = null;
        }
    }

    public void BindSocket2NetworkId(final int socketFd, final int networkId, final int opId) {
        Handler handler = (Handler)this.mHandlerRef.get();
        if (handler == null) {
            Logging.w(TAG, "BindSocket2NetworkId " + networkId + " failed: thread not running");
            this.NotifyBindSocket2NetworkIdResult(opId, false);
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    Network targetNetwork = null;
                    for (Map.Entry entry : NetworkTracker.this.mActiveNetworks.entrySet()) {
                        if (((ActiveNetworkInfo)entry.getValue()).networkId != networkId) continue;
                        targetNetwork = (Network)entry.getKey();
                        break;
                    }
                    if (targetNetwork == null) {
                        Logging.w(NetworkTracker.TAG, "BindSocket2NetworkId " + networkId + " failed: id not found");
                        NetworkTracker.this.NotifyBindSocket2NetworkIdResult(opId, false);
                        return;
                    }
                    FileDescriptor fileDescriptor = new FileDescriptor();
                    try {
                        Field field = FileDescriptor.class.getDeclaredField("descriptor");
                        field.setAccessible(true);
                        field.setInt(fileDescriptor, socketFd);
                        targetNetwork.bindSocket(fileDescriptor);
                        Logging.i(NetworkTracker.TAG, "BindSocket2NetworkId " + networkId + " success");
                        NetworkTracker.this.NotifyBindSocket2NetworkIdResult(opId, true);
                    }
                    catch (Exception e) {
                        Logging.w(NetworkTracker.TAG, "BindSocket2NetworkId " + networkId + " failed: " + e.toString());
                        NetworkTracker.this.NotifyBindSocket2NetworkIdResult(opId, false);
                        NetworkTracker.this.mActiveNetworks.remove(targetNetwork);
                        CommonUtility utility = (CommonUtility)NetworkTracker.this.mCommonUtilityRef.get();
                        if (utility == null) break block4;
                        utility.notifyActiveNetworkChange(NetworkTracker.this.GetActiveNetworks());
                    }
                }
            }
        });
    }

    private boolean RequestForCellular() {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkRequest requestForCellular = new NetworkRequest.Builder().addCapability(12).addTransportType(0).build();
        if (this.mCellularCallback != null) {
            connectivityManager.unregisterNetworkCallback(this.mCellularCallback);
        } else {
            this.mCellularCallback = this.CreateNetworkCallback(false);
        }
        try {
            connectivityManager.requestNetwork(requestForCellular, this.mCellularCallback);
        }
        catch (Exception e) {
            this.mMultipathDisabledReason = 2;
            if (this.mDefaultCallback != null) {
                connectivityManager.unregisterNetworkCallback(this.mDefaultCallback);
            }
            Logging.w(TAG, "not support multipath, requestNetwork for internet failed: " + e.toString());
            return false;
        }
        return true;
    }

    private ConnectivityManager.NetworkCallback CreateNetworkCallback(final boolean isDefault) {
        return new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                Logging.i(NetworkTracker.TAG, (isDefault ? "default " : "") + "callback onAvailable network: " + network.toString());
            }

            public void onBlockedStatusChanged(Network network, boolean blocked) {
                Logging.i(NetworkTracker.TAG, (isDefault ? "default " : "") + "callback onBlockedStatusChanged " + (blocked ? "blocked" : "unblocked") + ", network: " + network.toString());
            }

            public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
                NetworkTracker.this.OnActiveNetworkUpdated(isDefault, network, networkCapabilities);
            }

            public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            }

            public void onLosing(Network network, int maxMsToLive) {
                Logging.i(NetworkTracker.TAG, (isDefault ? "default " : "") + "callback onLosing network: " + network.toString() + ", mtl: " + maxMsToLive);
            }

            public void onLost(Network network) {
                Logging.i(NetworkTracker.TAG, (isDefault ? "default " : "") + "callback onLost network: " + network.toString());
                NetworkTracker.this.OnActiveNetworkLost(network);
            }

            public void onUnavailable() {
                Logging.i(NetworkTracker.TAG, (isDefault ? "default " : "") + "callback onUnavailable");
            }
        };
    }

    private void OnActiveNetworkUpdated(final boolean isDefault, final Network network, final NetworkCapabilities capabilities) {
        Handler handler = (Handler)this.mHandlerRef.get();
        if (handler == null) {
            return;
        }
        final int type = this.GetInternetType(capabilities);
        handler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility utility;
                if (isDefault && network.equals((Object)NetworkTracker.this.mDefaultNetwork)) {
                    return;
                }
                if (isDefault && NetworkTracker.this.mDefaultNetwork != null && NetworkTracker.this.mActiveNetworks.containsKey(NetworkTracker.this.mDefaultNetwork)) {
                    ((ActiveNetworkInfo)((NetworkTracker)NetworkTracker.this).mActiveNetworks.get((Object)((NetworkTracker)NetworkTracker.this).mDefaultNetwork)).isDefault = false;
                }
                boolean isUpdated = false;
                if (isDefault) {
                    NetworkTracker.this.mDefaultNetwork = network;
                    isUpdated = true;
                }
                if (NetworkTracker.this.mActiveNetworks.containsKey(network)) {
                    if (isDefault) {
                        ((ActiveNetworkInfo)((NetworkTracker)NetworkTracker.this).mActiveNetworks.get((Object)network)).isDefault = true;
                    }
                } else {
                    ActiveNetworkInfo info = new ActiveNetworkInfo();
                    info.networkId = NetworkTracker.this.CreateNetworkId();
                    info.internetType = type;
                    info.isDefault = isDefault;
                    NetworkTracker.this.mActiveNetworks.put(network, info);
                    isUpdated = true;
                }
                if (isUpdated && (utility = (CommonUtility)NetworkTracker.this.mCommonUtilityRef.get()) != null) {
                    Logging.i(NetworkTracker.TAG, "OnActiveNetworkUpdated, network: " + network.toString() + ", isDefault: " + isDefault + ", type: " + type + ", id: " + ((ActiveNetworkInfo)((NetworkTracker)NetworkTracker.this).mActiveNetworks.get((Object)network)).networkId + ", capabilities: " + capabilities.toString());
                    utility.notifyActiveNetworkChange(NetworkTracker.this.GetActiveNetworks());
                }
            }
        });
    }

    private void OnActiveNetworkLost(final Network network) {
        Handler handler = (Handler)this.mHandlerRef.get();
        if (handler == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (network.equals((Object)NetworkTracker.this.mDefaultNetwork)) {
                    NetworkTracker.this.mDefaultNetwork = null;
                }
                if (NetworkTracker.this.mActiveNetworks.containsKey(network)) {
                    Logging.i(NetworkTracker.TAG, "OnActiveNetworkLost, network: " + network.toString());
                    if (((ActiveNetworkInfo)((NetworkTracker)NetworkTracker.this).mActiveNetworks.get((Object)network)).internetType == 1) {
                        NetworkTracker.this.RequestForCellular();
                        Logging.i(NetworkTracker.TAG, "Request for cellular again for cellular lost");
                    }
                    NetworkTracker.this.mActiveNetworks.remove(network);
                    CommonUtility utility = (CommonUtility)NetworkTracker.this.mCommonUtilityRef.get();
                    if (utility != null) {
                        utility.notifyActiveNetworkChange(NetworkTracker.this.GetActiveNetworks());
                    }
                }
            }
        });
    }

    private int GetInternetType(NetworkCapabilities capabilities) {
        if (capabilities.hasTransport(1)) {
            return 0;
        }
        if (capabilities.hasTransport(0)) {
            return 1;
        }
        if (capabilities.hasTransport(3)) {
            return 2;
        }
        if (capabilities.hasTransport(2)) {
            return 3;
        }
        return 6;
    }

    private int CreateNetworkId() {
        return this.mNetworkId++;
    }

    private ActiveNetworkInfo[] GetActiveNetworks() {
        ActiveNetworkInfo[] activeNetworks = new ActiveNetworkInfo[this.mActiveNetworks.size()];
        int index = 0;
        for (Map.Entry<Network, ActiveNetworkInfo> entry : this.mActiveNetworks.entrySet()) {
            activeNetworks[index++] = entry.getValue();
        }
        return activeNetworks;
    }

    private void NotifyBindSocket2NetworkIdResult(int opId, boolean success) {
        CommonUtility utility = (CommonUtility)this.mCommonUtilityRef.get();
        if (utility != null) {
            utility.notifyBindSocket2NetworkIdResult(opId, success);
        }
    }

    public static class ActiveNetworkInfo {
        int networkId = 0;
        int internetType = 6;
        boolean isDefault = false;

        @CalledByNative(value="ActiveNetworkInfo")
        public int getNetworkId() {
            return this.networkId;
        }

        @CalledByNative(value="ActiveNetworkInfo")
        public int getInternetType() {
            return this.internetType;
        }

        @CalledByNative(value="ActiveNetworkInfo")
        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

