/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.JniCommon;
import java.nio.ByteBuffer;

class WrappedNativeRgbaBuffer
implements VideoFrame.RgbaBuffer {
    private long nativeBuffer = 0L;
    private final int width;
    private final int height;
    private final ByteBuffer data;

    @CalledByNative
    WrappedNativeRgbaBuffer(int width, int height, @NonNull ByteBuffer data, long nativeBuffer) {
        this.nativeBuffer = nativeBuffer;
        this.width = width;
        this.height = height;
        this.data = data;
        this.retain();
    }

    @Override
    public ByteBuffer getData() {
        return this.data.slice();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    public VideoFrame.I420Buffer toI420() {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.I010Buffer toI010() {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer mirror(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer rotate(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer transform(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int rotation) {
        return null;
    }

    @Override
    public void retain() {
        JniCommon.nativeAddRef(this.nativeBuffer);
    }

    @Override
    public void release() {
        JniCommon.nativeReleaseRef(this.nativeBuffer);
    }
}

