/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ATrace;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.EglRenderer;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.base.internal.video.VideoSourceLayout;
import io.agora.base.internal.video.YuvConverter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class VideoFrameBlender {
    private static final boolean DEBUG = false;
    private final YuvConverter yuvConverter = new YuvConverter();
    private static final String TAG = "AndroidVideoFrameBlender";
    private static final int MAX_INVOKE_TIME_MS = 2000;
    private Handler mBlenderHandler = null;
    private EglBase mEglBase = null;
    private ArrayList<VideoSourceLayout> mVideoSourceLayouts = new ArrayList();
    private HashMap<String, VideoFrame> mVideoSources = new HashMap();
    private final Object mSourceLock = new Object();
    private final VideoFrameDrawer mFrameDrawer = new VideoFrameDrawer();
    private RendererCommon.GlDrawer mDrawer = new GlRectDrawer();
    private final Matrix drawMatrix = new Matrix();
    private String mCanvasId = "_agora_canvas_";
    private int mVideoBufferId = 0;
    private int mFramebuffer = 0;
    private int mCanvasWidth = 0;
    private int mCanvasHeight = 0;
    private volatile boolean shouldResetCanvas = false;
    private volatile boolean isBlenderReleased = false;
    private AtomicInteger videoBufferIdRefCount = new AtomicInteger(0);

    @CalledByNative
    public VideoFrameBlender() {
    }

    @CalledByNative
    public boolean initBlender(String name, final EglBase.Context sharedContext) {
        HandlerThread thread = new HandlerThread(name + "VideoFameBlender");
        thread.start();
        this.mBlenderHandler = new Handler(thread.getLooper());
        boolean result = false;
        try {
            result = ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (sharedContext == null) {
                        Logging.e(VideoFrameBlender.TAG, "initBlender failed for sharedContext is null");
                        return false;
                    }
                    VideoFrameBlender.this.mEglBase = EglBaseFactory.create(sharedContext, EglBase.CONFIG_RGBA);
                    if (VideoFrameBlender.this.mEglBase == null) {
                        Logging.e(VideoFrameBlender.TAG, "initBlender failed for mEglBase is null");
                        return false;
                    }
                    try {
                        VideoFrameBlender.this.mEglBase.createDummyPbufferSurface();
                        VideoFrameBlender.this.mEglBase.makeCurrent();
                        GLES20.glPixelStorei((int)3317, (int)1);
                    }
                    catch (RuntimeException e) {
                        VideoFrameBlender.this.mEglBase.release();
                        return false;
                    }
                    VideoFrameBlender.this.isBlenderReleased = false;
                    return true;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "initBlender faild for EglBaseFactory failed");
            result = false;
        }
        return result;
    }

    private boolean createAndBindTextureBuffer(final int width, final int height) {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Logging.i(VideoFrameBlender.TAG, "into createAndBindTextureBuffer width:" + width + " ,height:" + height);
                try {
                    VideoFrameBlender.this.mEglBase.makeCurrent();
                }
                catch (RuntimeException e) {
                    return false;
                }
                VideoFrameBlender.this.releaseTextureBuffer();
                VideoFrameBlender.this.mVideoBufferId = GlUtil.generateTexture(3553);
                if (VideoFrameBlender.this.mVideoBufferId <= 0) {
                    Logging.e(VideoFrameBlender.TAG, "generateTexture failed");
                    return false;
                }
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)3553, (int)VideoFrameBlender.this.mVideoBufferId);
                ATrace.beginSection("glTexImage2D");
                GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
                GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
                GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
                GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
                GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
                ATrace.endSection();
                GlUtil.checkNoGLES2Error("TextureBufferPool.glTexImage2D");
                GLES20.glBindTexture((int)3553, (int)0);
                int[] frameBuffers = new int[1];
                GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
                GlUtil.checkNoGLES2Error("glGenFramebuffers");
                VideoFrameBlender.this.mFramebuffer = frameBuffers[0];
                GLES20.glBindFramebuffer((int)36160, (int)VideoFrameBlender.this.mFramebuffer);
                GlUtil.checkNoGLES2Error("glBindFramebuffer " + VideoFrameBlender.this.mFramebuffer);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)VideoFrameBlender.this.mVideoBufferId, (int)0);
                GlUtil.checkNoGLES2Error("glFramebufferTexture2D");
                int status = GLES20.glCheckFramebufferStatus((int)36160);
                if (status != 36053) {
                    Logging.w(VideoFrameBlender.TAG, "Framebuffer not complete, status: " + status);
                    return false;
                }
                GLES20.glBindFramebuffer((int)36160, (int)0);
                Logging.i(VideoFrameBlender.TAG, "createAndBindTextureBuffer success width:" + width + " ,height:" + height);
                return true;
            }
        });
    }

    private boolean checkIfNeedAlphaRender() {
        for (VideoSourceLayout layout : this.mVideoSourceLayouts) {
            VideoFrame videoFrame = this.mVideoSources.get(layout.getSourceId());
            if (videoFrame == null || videoFrame.getAlphaBuffer() == null) continue;
            return true;
        }
        return false;
    }

    @CalledByNative
    public VideoFrame.Buffer blenderSourceList() {
        if (this.isBlenderReleased) {
            Logging.w(TAG, "blenderSourceList failed for BlenderRelased");
            return null;
        }
        if (this.mCanvasWidth == 0 || this.mCanvasHeight == 0) {
            Logging.w(TAG, "blenderSourceList failed for mCanvasWidth:" + this.mCanvasWidth + ", mCanvasHeight:" + this.mCanvasHeight);
            return null;
        }
        VideoFrame.Buffer newBuffer = null;
        try {
            newBuffer = ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<VideoFrame.Buffer>(){

                @Override
                public VideoFrame.Buffer call() throws Exception {
                    return VideoFrameBlender.this.blenderSourcesWithinGlThread();
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "blenderSourceList failed.", e);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TextureBuffer blenderSourcesWithinGlThread() {
        TextureBuffer newTexture = null;
        Object object = this.mSourceLock;
        synchronized (object) {
            if (this.mVideoBufferId <= 0) {
                Logging.w(TAG, "blenderSourceList failed for  mVideoBufferId is:" + this.mVideoBufferId);
                return null;
            }
            this.mEglBase.makeCurrent();
            GLES20.glBindFramebuffer((int)36160, (int)this.mFramebuffer);
            GlUtil.checkNoGLES2Error("glBindFramebuffer mFramebuffer");
            boolean isNeedAlpha = this.checkIfNeedAlphaRender();
            if (isNeedAlpha) {
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GLES20.glEnable((int)3042);
                GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            } else {
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlUtil.checkNoGLES2Error("glClearColor");
            GLES20.glClear((int)16384);
            GlUtil.checkNoGLES2Error("glClear");
            for (VideoSourceLayout layout : this.mVideoSourceLayouts) {
                if (this.mVideoSources.get(layout.getSourceId()) == null) continue;
                this.doBlenderSource(layout, this.mVideoSources.get(layout.getSourceId()), isNeedAlpha);
            }
            if (isNeedAlpha) {
                GLES20.glDisable((int)3042);
            }
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtil.checkNoGLES2Error("glBindFramebuffer 0");
            GLES20.glUseProgram((int)0);
            GlUtil.checkNoGLES2Error("glUseProgram");
            GLES20.glFlush();
            GlUtil.checkNoGLES2Error("glFlush");
            this.videoBufferIdRefCount.getAndIncrement();
            newTexture = new TextureBuffer(this.mEglBase.getEglBaseContext(), this.mCanvasWidth, this.mCanvasHeight, VideoFrame.TextureBuffer.Type.RGB, this.mVideoBufferId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(GlUtil.IDENTITY_MATRIX), this.mBlenderHandler, this.yuvConverter, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = VideoFrameBlender.this.mSourceLock;
                    synchronized (object) {
                        VideoFrameBlender.this.videoBufferIdRefCount.getAndDecrement();
                        if (VideoFrameBlender.this.isBlenderReleased) {
                            VideoFrameBlender.this.releaseEgl();
                        }
                    }
                }
            });
        }
        return newTexture;
    }

    private void doBlenderSource(VideoSourceLayout layout, VideoFrame videoFrame, boolean isNeedAlpha) {
        Rect rect = new Rect(layout.getCroppedX(), layout.getCroppedY(), layout.getCroppedX() + layout.getCroppedWidth(), layout.getCroppedY() + layout.getCroppedHeight());
        float[] gltexturecoord = EglRenderer.DoConvertRectFromAndroidGraphicsRect(rect, videoFrame, layout.isMirrorY());
        this.mDrawer.setTextureCropCoord(GlUtil.createFloatBuffer(gltexturecoord));
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (layout.isMirrorY()) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        if (layout.getVideoSourceType() != VideoSourceLayout.VideoSourceType.STREAM) {
            this.drawMatrix.preScale(1.0f, -1.0f);
        }
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        int destPositionX = layout.getPositionX();
        int destPositionY = layout.getPositionY();
        if (!layout.getSourceId().equals(this.mCanvasId)) {
            destPositionX = layout.getPositionX();
            destPositionY = this.mCanvasHeight - layout.getPositionY() - layout.getDestHeight();
        }
        this.mFrameDrawer.disableNegativeAlphaData();
        this.mFrameDrawer.drawFrame(videoFrame, this.mDrawer, this.drawMatrix, destPositionX, destPositionY, layout.getDestWidth(), layout.getDestHeight(), isNeedAlpha && videoFrame.getAlphaBuffer() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void updateSourceContent(String sourceId, VideoFrame frame) {
        if (this.isBlenderReleased) {
            Logging.w(TAG, "updateSourceContent failed for BlenderRelased");
            return;
        }
        Object object = this.mSourceLock;
        synchronized (object) {
            if (this.mVideoSources.get(sourceId) != null) {
                this.mVideoSources.get(sourceId).release();
                this.mVideoSources.remove(sourceId);
            }
            if (frame.getBuffer() instanceof VideoFrame.RgbaBuffer) {
                VideoFrame.TextureBuffer newBuffer = null;
                newBuffer = this.uploadImageSourceToTexture(frame);
                if (newBuffer == null) {
                    return;
                }
                VideoFrame newframe = new VideoFrame(newBuffer, frame.getRotation(), frame.getTimestampNs());
                if (frame.getAlphaBuffer() != null) {
                    newframe.fillAlphaData(frame.getAlphaBuffer());
                }
                this.mVideoSources.put(sourceId, newframe);
            } else {
                frame.retain();
                this.mVideoSources.put(sourceId, frame);
            }
        }
    }

    private void removeSourceLayoutIfNeed(String sourceId) {
        for (int i = this.mVideoSourceLayouts.size() - 1; i >= 0; --i) {
            if (!this.mVideoSourceLayouts.get(i).getSourceId().equals(sourceId)) continue;
            this.mVideoSourceLayouts.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void updateVideoSourceLayout(VideoSourceLayout videoSourceLayout) {
        if (this.isBlenderReleased) {
            Logging.w(TAG, "updateSourceLayout failed for BlenderRelased");
            return;
        }
        Object object = this.mSourceLock;
        synchronized (object) {
            this.removeSourceLayoutIfNeed(videoSourceLayout.getSourceId());
            if (videoSourceLayout.getSourceId().equals(this.mCanvasId)) {
                this.mCanvasWidth = videoSourceLayout.getDestWidth();
                this.mCanvasHeight = videoSourceLayout.getDestHeight();
                this.shouldResetCanvas = true;
            }
            if (this.shouldResetCanvas) {
                if (this.isVideoBufferIdUsing()) {
                    Logging.w(TAG, "updateSourceLayout reset canvas failed for isVideoBufferIdUsing");
                } else {
                    this.createAndBindTextureBuffer(this.mCanvasWidth, this.mCanvasHeight);
                    this.shouldResetCanvas = false;
                }
            }
            this.mVideoSourceLayouts.add(videoSourceLayout);
            Collections.sort(this.mVideoSourceLayouts, new Comparator<VideoSourceLayout>(){

                @Override
                public int compare(VideoSourceLayout layout1, VideoSourceLayout layout2) {
                    return layout1.getZorder() - layout2.getZorder();
                }
            });
        }
    }

    private boolean isVideoBufferIdUsing() {
        return this.videoBufferIdRefCount.get() > 0;
    }

    @VisibleForTesting
    public boolean hasSourceContent(String sourceId) {
        return this.mVideoSources.get(sourceId) != null;
    }

    @VisibleForTesting
    public boolean hasSourceLayout(String sourceId) {
        for (VideoSourceLayout layout : this.mVideoSourceLayouts) {
            if (!layout.getSourceId().equals(sourceId)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public boolean isShouldResetCanvas() {
        return this.shouldResetCanvas;
    }

    private VideoFrame.TextureBuffer uploadImageSourceToTexture(final VideoFrame inputFrame) {
        VideoFrame.TextureBuffer buffer = null;
        try {
            buffer = ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<VideoFrame.TextureBuffer>(){

                @Override
                public VideoFrame.TextureBuffer call() throws Exception {
                    if (!(inputFrame.getBuffer() instanceof VideoFrame.RgbaBuffer)) {
                        return null;
                    }
                    VideoFrameBlender.this.mEglBase.makeCurrent();
                    ByteBuffer originBuffer = ((VideoFrame.RgbaBuffer)inputFrame.getBuffer()).getData();
                    final int new_texture_id = VideoFrameBlender.createImageTexture(originBuffer, inputFrame.getBuffer().getWidth(), inputFrame.getBuffer().getHeight(), 6408);
                    GLES20.glFlush();
                    TextureBuffer buffer = new TextureBuffer(VideoFrameBlender.this.mEglBase.getEglBaseContext(), inputFrame.getBuffer().getWidth(), inputFrame.getBuffer().getHeight(), VideoFrame.TextureBuffer.Type.RGB, new_texture_id, RendererCommon.convertMatrixToAndroidGraphicsMatrix(GlUtil.IDENTITY_MATRIX), VideoFrameBlender.this.mBlenderHandler, VideoFrameBlender.this.yuvConverter, new Runnable(){

                        @Override
                        public void run() {
                            VideoFrameBlender.this.mBlenderHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    GLES20.glDeleteTextures((int)1, (int[])new int[]{new_texture_id}, (int)0);
                                }
                            });
                        }
                    });
                    return buffer;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "uploadImageSourceToTexture faild for " + e.toString());
            return buffer;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void releaseBlenderResource() {
        Object object = this.mSourceLock;
        synchronized (object) {
            this.mVideoSourceLayouts.clear();
            for (Map.Entry<String, VideoFrame> entry : this.mVideoSources.entrySet()) {
                entry.getValue().release();
            }
            this.mVideoSources.clear();
        }
    }

    private void releaseTextureBuffer() {
        int[] values = new int[1];
        if (this.mVideoBufferId > 0) {
            values[0] = this.mVideoBufferId;
            GLES20.glDeleteTextures((int)1, (int[])values, (int)0);
            this.mVideoBufferId = -1;
        }
        if (this.mFramebuffer > 0) {
            values[0] = this.mFramebuffer;
            GLES20.glDeleteFramebuffers((int)1, (int[])values, (int)0);
            this.mFramebuffer = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public void releaseBlender() {
        if (this.mBlenderHandler == null) {
            return;
        }
        this.isBlenderReleased = true;
        this.releaseBlenderResource();
        Object object = this.mSourceLock;
        synchronized (object) {
            this.releaseEgl();
        }
    }

    private void releaseEgl() {
        if (this.isVideoBufferIdUsing()) {
            Logging.w(TAG, "releaseEgl failed for isVideoBufferIdUsing");
            return;
        }
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mBlenderHandler, 2000L, new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Logging.i(VideoFrameBlender.TAG, "release egl resources on render thread");
                    if (VideoFrameBlender.this.mEglBase != null) {
                        try {
                            VideoFrameBlender.this.mEglBase.makeCurrent();
                        }
                        catch (RuntimeException e) {
                            Logging.e(VideoFrameBlender.TAG, "releaseBlender failed to make current");
                        }
                    }
                    VideoFrameBlender.this.yuvConverter.release();
                    Logging.i(VideoFrameBlender.TAG, "release texture resources on render thread");
                    VideoFrameBlender.this.releaseTextureBuffer();
                    VideoFrameBlender.this.mDrawer.release();
                    VideoFrameBlender.this.mFrameDrawer.release();
                    Object object = EglBase.lock;
                    synchronized (object) {
                        GLES20.glUseProgram((int)0);
                    }
                    if (VideoFrameBlender.this.mEglBase != null) {
                        Logging.i(VideoFrameBlender.TAG, "releaseBlender detachCurrent");
                        VideoFrameBlender.this.mEglBase.detachCurrent();
                        VideoFrameBlender.this.mEglBase.release();
                        VideoFrameBlender.this.mEglBase = null;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "releaseBlender faild for " + e.toString());
        }
        this.mBlenderHandler.getLooper().quitSafely();
    }

    private static int createImageTexture(ByteBuffer data, int width, int height, int format) {
        int[] textureHandles = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandles, (int)0);
        int textureHandle = textureHandles[0];
        GlUtil.checkNoGLES2Error("glGenTextures");
        GLES20.glBindTexture((int)3553, (int)textureHandle);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlUtil.checkNoGLES2Error("loadImageTexture");
        GLES20.glTexImage2D((int)3553, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)5121, (Buffer)data);
        GlUtil.checkNoGLES2Error("loadImageTexture");
        return textureHandle;
    }
}

