/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.Nullable;
import io.agora.base.AlphaStitchMode;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.JniCommon;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.GlTextureFrameBuffer;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.YuvConverter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;

public class TextureBufferHelper {
    private static final String TAG = "TextureBufferHelper";
    private GlRectDrawer textureDrawer;
    private GlTextureFrameBuffer textureFrameBuffer;
    @Nullable
    private ByteBuffer alphaBuffer;
    private final Handler handler;
    private final EglBase eglBase;
    private final YuvConverter yuvConverter = new YuvConverter();
    private int numOfTextureInUse = 0;
    private boolean isQuitting = false;

    @Nullable
    public static TextureBufferHelper create(final String threadName, final EglBase.Context sharedContext) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<TextureBufferHelper>(){

                @Override
                public TextureBufferHelper call() {
                    try {
                        return new TextureBufferHelper(sharedContext, handler);
                    }
                    catch (RuntimeException e) {
                        Logging.e(TextureBufferHelper.TAG, threadName + " create failure", e);
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, threadName + " create failure", e);
            return null;
        }
    }

    private TextureBufferHelper(EglBase.Context sharedContext, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("TextureBufferHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase14.isEGL14Supported() && (sharedContext == null || sharedContext instanceof EglBase14.Context) ? new EglBase14((EglBase14.Context)sharedContext, EglBase.CONFIG_PIXEL_BUFFER) : new EglBase10((EglBase10.Context)sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public EglBase getEglBase() {
        return this.eglBase;
    }

    public <V> V invoke(Callable<V> callable) {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, callable);
    }

    public VideoFrame.TextureBuffer wrapTextureBuffer(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix) {
        return this.wrapTextureBuffer(width, height, type, id, transformMatrix, false);
    }

    public VideoFrame.TextureBuffer wrapTextureBuffer(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, boolean is10bitTexture) {
        ++this.numOfTextureInUse;
        return new TextureBuffer(this.eglBase.getEglBaseContext(), width, height, type, id, transformMatrix, this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBufferHelper.this.returnTextureFrame();
            }
        }, is10bitTexture);
    }

    public VideoFrame.TextureBuffer wrapTextureBuffer(int width, int height, VideoFrame.TextureBuffer.Type type, int id, long fenceObject, Matrix transformMatrix) {
        ++this.numOfTextureInUse;
        return new TextureBuffer(this.eglBase.getEglBaseContext(), width, height, type, id, fenceObject, transformMatrix, this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBufferHelper.this.returnTextureFrame();
            }
        });
    }

    public int convertToRGBA(TextureBuffer buffer, int rotation) {
        if (buffer == null) {
            return 0;
        }
        if (this.textureDrawer == null) {
            this.textureDrawer = new GlRectDrawer();
        }
        if (this.textureFrameBuffer == null) {
            this.textureFrameBuffer = new GlTextureFrameBuffer(6408);
        }
        int frameWidth = rotation % 180 == 0 ? buffer.getWidth() : buffer.getHeight();
        int frameHeight = rotation % 180 == 0 ? buffer.getHeight() : buffer.getWidth();
        this.textureFrameBuffer.setSize(frameWidth, frameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
        GLES20.glClear((int)16384);
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preRotate((float)rotation);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        renderMatrix.postConcat(buffer.getTransformMatrix());
        float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(renderMatrix);
        if (buffer.getType() == VideoFrame.TextureBuffer.Type.RGB) {
            this.textureDrawer.drawRgb(buffer.getTextureId(), 0, finalGlMatrix, frameWidth, frameHeight, 0, 0, frameWidth, frameHeight, 0, AlphaStitchMode.ALPHA_NO_STITCH.value());
        } else {
            this.textureDrawer.drawOes(buffer.getTextureId(), 0, finalGlMatrix, frameWidth, frameHeight, 0, 0, frameWidth, frameHeight, 0, AlphaStitchMode.ALPHA_NO_STITCH.value());
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return this.textureFrameBuffer.getTextureId();
    }

    public ByteBuffer parseAlphaData(TextureBuffer buffer, int rotation, boolean mirror) {
        if (buffer.getType() == VideoFrame.TextureBuffer.Type.RGB) {
            int frameWidth = rotation % 180 == 0 ? buffer.getWidth() : buffer.getHeight();
            int frameHeight = rotation % 180 == 0 ? buffer.getHeight() : buffer.getWidth();
            int pboWidth = frameWidth;
            int pboFormat = 6406;
            if (frameWidth % 4 == 0) {
                pboWidth = frameWidth / 4;
                pboFormat = 6408;
            }
            if (this.textureDrawer == null) {
                this.textureDrawer = new GlRectDrawer();
            }
            if (this.textureFrameBuffer == null) {
                this.textureFrameBuffer = new GlTextureFrameBuffer(6408);
            }
            this.textureFrameBuffer.setSize(pboWidth, frameHeight);
            GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            Matrix renderMatrix = new Matrix();
            renderMatrix.preTranslate(0.5f, 0.5f);
            renderMatrix.preRotate((float)rotation);
            if (mirror) {
                renderMatrix.preScale(-1.0f, 1.0f);
            }
            renderMatrix.preTranslate(-0.5f, -0.5f);
            renderMatrix.postConcat(buffer.getTransformMatrix());
            float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(renderMatrix);
            if (frameWidth % 4 == 0) {
                this.textureDrawer.drawAlpha(buffer.getTextureId(), finalGlMatrix, frameWidth, frameHeight, 0, 0, pboWidth, frameHeight);
            } else {
                this.textureDrawer.drawRgb(buffer.getTextureId(), 0, finalGlMatrix, frameWidth, frameHeight, 0, 0, frameWidth, frameHeight, 0, AlphaStitchMode.ALPHA_NO_STITCH.value());
            }
            if (this.alphaBuffer == null) {
                this.alphaBuffer = JniCommon.nativeAllocateByteBuffer(frameWidth * frameHeight);
            } else if (this.alphaBuffer.capacity() != frameWidth * frameHeight) {
                Logging.w(TAG, "fillAlphaData size is changed, alphaBuffer.capacity: " + this.alphaBuffer.capacity() + "  buffer.width: " + frameWidth + "  buffer.height: " + frameHeight);
                JniCommon.nativeFreeByteBuffer(this.alphaBuffer);
                this.alphaBuffer = JniCommon.nativeAllocateByteBuffer(frameWidth * frameHeight);
            } else {
                this.alphaBuffer.clear();
            }
            GLES20.glReadPixels((int)0, (int)0, (int)pboWidth, (int)frameHeight, (int)pboFormat, (int)5121, (Buffer)this.alphaBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            return this.alphaBuffer;
        }
        return null;
    }

    private void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TextureBufferHelper.this.numOfTextureInUse--;
                if (TextureBufferHelper.this.isQuitting && !TextureBufferHelper.this.isTextureInUse()) {
                    TextureBufferHelper.this.release();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.numOfTextureInUse > 0;
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    TextureBufferHelper.this.isQuitting = true;
                    if (!TextureBufferHelper.this.isTextureInUse()) {
                        TextureBufferHelper.this.release();
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.d(TAG, "dispose fail: " + e.getMessage());
        }
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse() || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        Logging.d(TAG, "release()");
        if (this.textureDrawer != null) {
            this.textureDrawer.release();
            this.textureDrawer = null;
        }
        if (this.textureFrameBuffer != null) {
            this.textureFrameBuffer.release();
            this.textureFrameBuffer = null;
        }
        if (this.alphaBuffer != null) {
            JniCommon.nativeFreeByteBuffer(this.alphaBuffer);
            this.alphaBuffer = null;
        }
        this.yuvConverter.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }
}

