/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.voiceengine.WebRtcAudioUtils;
import io.agora.utils2.internal.Logging;
import java.util.Random;

public class AudioFocusManager {
    private static final String TAG = AudioFocusManager.class.getSimpleName();
    private AudioManager mAudioManager;
    private AudioFocusChangeListenerImpl mAudioFocusChangeListenerImpl;
    private AudioFocusRequest mFocusRequest;
    private Handler mHandler;

    @CalledByNative
    public AudioFocusManager(Context context) {
        Logging.d(TAG, " ctor()");
        this.mAudioFocusChangeListenerImpl = new AudioFocusChangeListenerImpl();
        String threadName = "AudioFocusManager-" + new Random().nextInt();
        HandlerThread handlerThread = new HandlerThread(threadName);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        if (context != null) {
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
        }
    }

    @VisibleForTesting
    AudioFocusChangeListenerImpl getAudioFocusChangeListenerImpl() {
        return this.mAudioFocusChangeListenerImpl;
    }

    @CalledByNative
    public void dispose() {
        Logging.d(TAG, "dispose()");
        this.abandonAudioFocus();
        if (this.mHandler != null) {
            this.mHandler.getLooper().quit();
            this.mHandler = null;
        }
        this.mAudioManager = null;
        this.mAudioFocusChangeListenerImpl = null;
    }

    @CalledByNative
    public synchronized boolean requestAudioFocus() {
        Logging.d(TAG, "requestAudioFocus()");
        if (this.mAudioManager == null) {
            Logging.w(TAG, "requestAudioFocus failed as audioManager is null");
            return false;
        }
        boolean ret = WebRtcAudioUtils.runningOnOreoOrHigher() ? this.requestAudioFocusOnOreoOrHigher() : this.requestAudioFocusOnLowerThanOreo();
        Logging.d(TAG, "requestAudioFocus successful: " + ret);
        return ret;
    }

    @CalledByNative
    public synchronized boolean abandonAudioFocus() {
        Logging.d(TAG, "abandonAudioFocus()");
        if (this.mAudioManager == null) {
            Logging.w(TAG, "abandonAudioFocus failed as audioManager is null");
            return false;
        }
        boolean ret = WebRtcAudioUtils.runningOnOreoOrHigher() ? this.abandonAudioFocusOnOreoOrHigher() : this.abandonAudioFocusOnLowerThanOreo();
        Logging.d(TAG, "abandonAudioFocus successful: " + ret);
        return ret;
    }

    @TargetApi(value=26)
    private boolean requestAudioFocusOnOreoOrHigher() {
        int result;
        AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).setContentType(2).build();
        if (this.mFocusRequest == null) {
            this.mFocusRequest = new AudioFocusRequest.Builder(3).setAudioAttributes(attributes).setAcceptsDelayedFocusGain(true).setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this.mAudioFocusChangeListenerImpl, this.mHandler).build();
        }
        return (result = this.mAudioManager.requestAudioFocus(this.mFocusRequest)) == 1;
    }

    @VisibleForTesting
    boolean requestAudioFocusOnLowerThanOreo() {
        int result = this.mAudioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this.mAudioFocusChangeListenerImpl, 3, 3);
        return result == 1;
    }

    @TargetApi(value=26)
    private boolean abandonAudioFocusOnOreoOrHigher() {
        int result = 1;
        if (this.mFocusRequest != null) {
            result = this.mAudioManager.abandonAudioFocusRequest(this.mFocusRequest);
        }
        return result == 1;
    }

    @VisibleForTesting
    boolean abandonAudioFocusOnLowerThanOreo() {
        int result = this.mAudioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this.mAudioFocusChangeListenerImpl);
        return result == 1;
    }

    @VisibleForTesting
    class AudioFocusChangeListenerImpl
    implements AudioManager.OnAudioFocusChangeListener {
        AudioFocusChangeListenerImpl() {
        }

        public void onAudioFocusChange(int focusChange) {
            Logging.d(TAG, "onAudioFocusChange and focusChange: " + focusChange);
            switch (focusChange) {
                case 1: {
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    AudioFocusManager.this.requestAudioFocus();
                    break;
                }
            }
        }
    }
}

