/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2;

import androidx.annotation.NonNull;
import io.agora.rtc2.IMediaRecorderCallback;
import io.agora.rtc2.RecorderStreamInfo;
import io.agora.rtc2.internal.RtcEngineImpl;
import java.lang.ref.WeakReference;

public class AgoraMediaRecorder {
    public static final int RECORDER_STATE_ERROR = -1;
    public static final int RECORDER_STATE_START = 2;
    public static final int RECORDER_STATE_STOP = 3;
    public static final int RECORDER_REASON_NONE = 0;
    public static final int RECORDER_REASON_WRITE_FAILED = 1;
    public static final int RECORDER_REASON_NO_STREAM = 2;
    public static final int RECORDER_REASON_OVER_MAX_DURATION = 3;
    public static final int RECORDER_REASON_CONFIG_CHANGED = 4;
    public static final int STREAM_TYPE_AUDIO = 1;
    public static final int STREAM_TYPE_VIDEO = 2;
    public static final int STREAM_TYPE_BOTH = 3;
    public static final int CONTAINER_MP4 = 1;
    WeakReference<RtcEngineImpl> mEngineReference;
    String mChannelId;
    @NonNull
    RecorderStreamInfo mStreamInfo;

    public AgoraMediaRecorder(RtcEngineImpl engine, @NonNull RecorderStreamInfo info) {
        this.mEngineReference = new WeakReference<RtcEngineImpl>(engine);
        this.mStreamInfo = info;
        if (info.channelId == null) {
            this.mStreamInfo.channelId = "";
        }
    }

    static String getChannelId(RecorderStreamInfo info) {
        return info != null ? info.channelId : null;
    }

    static int getUserId(RecorderStreamInfo info) {
        return info != null ? info.uid : 0;
    }

    static int getStreamType(RecorderStreamInfo info) {
        return info != null ? info.recorderStreamType : 0;
    }

    public int setMediaRecorderObserver(IMediaRecorderCallback callback) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return engine.setMediaRecorderObserver(callback, AgoraMediaRecorder.getUserId(this.mStreamInfo), AgoraMediaRecorder.getChannelId(this.mStreamInfo), true, AgoraMediaRecorder.getStreamType(this.mStreamInfo));
    }

    public int startRecording(MediaRecorderConfiguration config) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return engine.startRecording(config.storagePath, config.containerFormat, config.streamType, config.maxDurationMs, config.recorderInfoUpdateInterval, AgoraMediaRecorder.getUserId(this.mStreamInfo), AgoraMediaRecorder.getChannelId(this.mStreamInfo), true, AgoraMediaRecorder.getStreamType(this.mStreamInfo), config.width, config.height, config.fps, config.sample_rate, config.channel_num, config.videoSourceType);
    }

    public int stopRecording() {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return engine.stopRecording(AgoraMediaRecorder.getChannelId(this.mStreamInfo), AgoraMediaRecorder.getUserId(this.mStreamInfo), true, AgoraMediaRecorder.getStreamType(this.mStreamInfo));
    }

    public void release() {
        RtcEngineImpl engine = null;
        if (this.mEngineReference != null && (engine = (RtcEngineImpl)this.mEngineReference.get()) != null && this.mStreamInfo != null) {
            engine.releaseRecorder(AgoraMediaRecorder.getChannelId(this.mStreamInfo), AgoraMediaRecorder.getUserId(this.mStreamInfo), this.mStreamInfo.recorderStreamType);
        }
        this.mEngineReference = null;
    }

    public static class MediaRecorderConfiguration {
        public String storagePath;
        public int containerFormat = 1;
        public int streamType = 3;
        public int maxDurationMs = 120000;
        public int recorderInfoUpdateInterval = 0;
        public int width;
        public int height;
        public int fps;
        public int sample_rate;
        public int channel_num;
        public int videoSourceType;

        public MediaRecorderConfiguration(String storagePath, int containerFormat, int streamType, int maxDurationMs, int recorderInfoUpdateInterval) {
            this.storagePath = storagePath;
            this.containerFormat = containerFormat;
            this.streamType = streamType;
            this.maxDurationMs = maxDurationMs;
            this.recorderInfoUpdateInterval = recorderInfoUpdateInterval;
            this.width = 1280;
            this.height = 720;
            this.fps = 30;
            this.sample_rate = 48000;
            this.channel_num = 1;
            this.videoSourceType = 0;
        }

        public MediaRecorderConfiguration(String storagePath, int containerFormat, int streamType, int maxDurationMs, int recorderInfoUpdateInterval, int width, int height, int fps, int sample_rate, int channel_num, int videoSourceType) {
            this.storagePath = storagePath;
            this.containerFormat = containerFormat;
            this.streamType = streamType;
            this.maxDurationMs = maxDurationMs;
            this.recorderInfoUpdateInterval = recorderInfoUpdateInterval;
            this.width = width;
            this.height = height;
            this.fps = fps;
            this.sample_rate = sample_rate;
            this.channel_num = channel_num;
            this.videoSourceType = videoSourceType;
        }
    }
}

