/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.video.CodecSpecificInfo;
import io.agora.base.internal.video.EncodedImage;
import io.agora.base.internal.video.VideoEncoder;
import java.nio.ByteBuffer;

class VideoEncoderWrapper {
    VideoEncoderWrapper() {
    }

    @CalledByNative
    static boolean getScalingSettingsOn(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.on;
    }

    @Nullable
    @CalledByNative
    static Integer getScalingSettingsLow(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.low;
    }

    @Nullable
    @CalledByNative
    static Integer getScalingSettingsHigh(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.high;
    }

    @CalledByNative
    static VideoEncoder.Callback createEncoderCallback(final long nativeEncoder) {
        return new VideoEncoder.Callback(){

            @Override
            public void onEncodedFrame(EncodedImage frame, int codecDelayTimeMs, int codecDelayFrames, int supportCodecs, int bitrateMode, int bitrateAdjustment, CodecSpecificInfo info) {
                VideoEncoderWrapper.nativeOnEncodedFrame(nativeEncoder, frame.buffer, frame.encodedWidth, frame.encodedHeight, frame.captureTimeNs, frame.frameType.getNative(), frame.rotation, frame.completeFrame, frame.qp, codecDelayTimeMs, codecDelayFrames, supportCodecs, bitrateMode, bitrateAdjustment, info);
            }

            @Override
            public void onEncodeReset() {
                VideoEncoderWrapper.nativeOnEncodeReset(nativeEncoder);
            }

            @Override
            public void onEncodeBufferPrepared(long opaque) {
                VideoEncoderWrapper.nativeOnEncodeBufferPrepared(nativeEncoder, opaque);
            }
        };
    }

    static int rewriteSpsInConfigBuffer(ByteBuffer srcBuffer, ByteBuffer dstBuffer, int width, int height) {
        return VideoEncoderWrapper.nativeRewriteSpsInConfigBuffer(srcBuffer, dstBuffer, width, height);
    }

    static boolean shouldUseBaseline() {
        return VideoEncoderWrapper.nativeShouldUseBaseline();
    }

    private static native void nativeOnEncodedFrame(long var0, ByteBuffer var2, int var3, int var4, long var5, int var7, int var8, boolean var9, Integer var10, int var11, int var12, int var13, int var14, int var15, CodecSpecificInfo var16);

    private static native void nativeOnEncodeReset(long var0);

    private static native void nativeOnEncodeBufferPrepared(long var0, long var2);

    private static native int nativeRewriteSpsInConfigBuffer(ByteBuffer var0, ByteBuffer var1, int var2, int var3);

    private static native boolean nativeShouldUseBaseline();
}

