/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.video.CodecSpecificInfo;
import io.agora.base.internal.video.EncodedImage;
import io.agora.base.internal.video.FrameExtraInfo;
import io.agora.base.internal.video.VideoCodecStatus;

public interface VideoDecoder {
    @Nullable
    @CalledByNative
    public VideoHWCodecSpec getVideoHWCodecSpec();

    @CalledByNative
    public long createNativeVideoDecoder();

    @CalledByNative
    public boolean isHardwareDecoder();

    @CalledByNative
    public VideoCodecStatus attachProxyThread();

    @CalledByNative
    public VideoCodecStatus initDecode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus detachProxyThread();

    @CalledByNative
    public VideoCodecStatus decode(EncodedImage var1, DecodeInfo var2, CodecSpecificInfo var3, FrameExtraInfo var4);

    @CalledByNative
    public String getImplementationName();

    public static class VideoHWCodecSpec {
        public final String codecName;
        public final String maxResolution;
        public final int platformid;
        public final int inputType;
        public final int bitrateMode;
        public final int profile;
        public final int minSupportedBitrate;
        public final String supportCodecNames;

        public VideoHWCodecSpec(String codecName, String maxResolution, int bitrateMode, int inputType, int profile, int minSupportedBitrate, String supportCodecNames) {
            this.codecName = codecName;
            this.maxResolution = maxResolution;
            this.bitrateMode = bitrateMode;
            this.inputType = inputType;
            this.profile = profile;
            this.minSupportedBitrate = minSupportedBitrate;
            this.platformid = 4;
            this.supportCodecNames = supportCodecNames;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public String getCodecName() {
            return this.codecName;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public String getMaxResolution() {
            return this.maxResolution;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getPlatformid() {
            return this.platformid;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getInputType() {
            return this.inputType;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getBitrateMode() {
            return this.bitrateMode;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getProfile() {
            return this.profile;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public int getMinSupportedBitrate() {
            return this.minSupportedBitrate;
        }

        @CalledByNative(value="VideoHWCodecSpec")
        public String getSupportCodecNames() {
            return this.supportCodecNames;
        }
    }

    public static interface Callback {
        public void onDecodedFrame(VideoFrame var1, Integer var2, Integer var3, int var4, int var5, int var6, CodecSpecificInfo var7, FrameExtraInfo var8);

        public void onDecodeReset();

        public void onDecodeBufferPrepared(long var1);
    }

    public static class DecodeInfo {
        public final boolean isMissingFrames;
        public final long renderTimeMs;

        public DecodeInfo(boolean isMissingFrames, long renderTimeMs) {
            this.isMissingFrames = isMissingFrames;
            this.renderTimeMs = renderTimeMs;
        }
    }

    public static class Settings {
        public int numberOfCores;
        public int width;
        public int height;
        public int lumaBitDepth;
        public int codecProfile;

        @CalledByNative(value="Settings")
        public Settings(int numberOfCores, int width, int height, int lumaBitDepth, int codecProfile) {
            this.numberOfCores = numberOfCores;
            this.width = width;
            this.height = height;
            this.lumaBitDepth = lumaBitDepth;
            this.codecProfile = codecProfile;
        }
    }
}

