/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.ISurfaceTextureHelper;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.TextureBufferPool;
import io.agora.base.internal.video.VideoDecimator;
import io.agora.base.internal.video.VideoSink;
import io.agora.base.internal.video.YuvConverter;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimerSurfaceTextureHelper
implements ISurfaceTextureHelper {
    private static final String TAG = "TSurfaceTextureHelper";
    private final Handler proxyHandler;
    private final VideoDecimator videoDecimator;
    private final VideoDecimator auxiliaryDecimator;
    private final boolean smoothCapture;
    private int notifyIntervalInMS = 67;
    private volatile long prevTimeMillis = 0L;
    private static final int DEFAULT_MAX_BUFFER_COUNT = 4;
    private int frameRate;
    private boolean hasFrameRate;
    @Nullable
    private ScheduledExecutorService scheduledService;
    private final Handler handler;
    private EglBase eglBase;
    @NonNull
    private final EglBase.Context sharedContext;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter = new YuvConverter();
    private final TextureBufferPool textureBufferPool;
    @Nullable
    private VideoSink listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isOesTextureInUse = false;
    private boolean isQuitting = false;
    private int frameRotation;
    private int textureWidth;
    private int textureHeight;
    @Nullable
    private VideoSink pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            Logging.i(TimerSurfaceTextureHelper.TAG, "Setting listener to " + TimerSurfaceTextureHelper.this.pendingListener);
            TimerSurfaceTextureHelper.this.listener = TimerSurfaceTextureHelper.this.pendingListener;
            TimerSurfaceTextureHelper.this.pendingListener = null;
            if (TimerSurfaceTextureHelper.this.hasPendingTexture) {
                TimerSurfaceTextureHelper.this.updateTexImage();
                TimerSurfaceTextureHelper.this.hasPendingTexture = false;
            }
        }
    };
    final Runnable timerNotifyRunnable = new Runnable(){

        @Override
        public void run() {
            TimerSurfaceTextureHelper.this.tryDeliverTextureFrame();
        }
    };
    final Runnable systemGenerateRunnable = new Runnable(){

        @Override
        public void run() {
            if (!TimerSurfaceTextureHelper.this.isOesTextureInUse && !TimerSurfaceTextureHelper.this.isQuitting && TimerSurfaceTextureHelper.this.listener != null) {
                boolean outBound;
                TimerSurfaceTextureHelper.this.videoDecimator.updateIncomingFramerate();
                if (TimerSurfaceTextureHelper.this.videoDecimator.dropFrame()) {
                    Logging.i(TimerSurfaceTextureHelper.TAG, "systemGenerate dropFrame.");
                } else {
                    TimerSurfaceTextureHelper.this.handler.post(TimerSurfaceTextureHelper.this.timerNotifyRunnable);
                    TimerSurfaceTextureHelper.this.prevTimeMillis = System.currentTimeMillis();
                }
                TimerSurfaceTextureHelper.this.proxyHandler.removeCallbacks(TimerSurfaceTextureHelper.this.supplementRunnable);
                float diff = TimerSurfaceTextureHelper.this.videoDecimator.inputFramerate() - TimerSurfaceTextureHelper.this.auxiliaryDecimator.getTargetFrameRate();
                boolean bl = outBound = diff < 0.0f && Math.abs(diff) > 3.0f && (double)Math.abs(diff) > 0.1 * (double)TimerSurfaceTextureHelper.this.auxiliaryDecimator.getTargetFrameRate() || System.currentTimeMillis() - TimerSurfaceTextureHelper.this.prevTimeMillis > (long)(2 * TimerSurfaceTextureHelper.this.notifyIntervalInMS);
                if (outBound) {
                    TimerSurfaceTextureHelper.this.proxyHandler.postDelayed(TimerSurfaceTextureHelper.this.supplementRunnable, (long)TimerSurfaceTextureHelper.this.notifyIntervalInMS);
                }
            }
        }
    };
    final Runnable supplementRunnable = new Runnable(){

        @Override
        public void run() {
            if (!TimerSurfaceTextureHelper.this.isOesTextureInUse && !TimerSurfaceTextureHelper.this.isQuitting && TimerSurfaceTextureHelper.this.listener != null) {
                boolean outBound;
                TimerSurfaceTextureHelper.this.videoDecimator.updateIncomingFramerate();
                if (TimerSurfaceTextureHelper.this.videoDecimator.dropFrame()) {
                    Logging.i(TimerSurfaceTextureHelper.TAG, "supplement dropFrame.");
                } else {
                    TimerSurfaceTextureHelper.this.prevTimeMillis = System.currentTimeMillis();
                    TimerSurfaceTextureHelper.this.handler.post(TimerSurfaceTextureHelper.this.timerNotifyRunnable);
                }
                TimerSurfaceTextureHelper.this.proxyHandler.removeCallbacks(TimerSurfaceTextureHelper.this.supplementRunnable);
                float diff = TimerSurfaceTextureHelper.this.videoDecimator.inputFramerate() - TimerSurfaceTextureHelper.this.auxiliaryDecimator.getTargetFrameRate();
                boolean bl = outBound = diff < 0.0f && Math.abs(diff) > 3.0f && (double)Math.abs(diff) > 0.1 * (double)TimerSurfaceTextureHelper.this.auxiliaryDecimator.getTargetFrameRate() || System.currentTimeMillis() - TimerSurfaceTextureHelper.this.prevTimeMillis > (long)(2 * TimerSurfaceTextureHelper.this.notifyIntervalInMS);
                if (outBound) {
                    TimerSurfaceTextureHelper.this.proxyHandler.postDelayed(TimerSurfaceTextureHelper.this.supplementRunnable, (long)TimerSurfaceTextureHelper.this.notifyIntervalInMS);
                }
            }
        }
    };
    final Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            boolean outBound;
            float diff = TimerSurfaceTextureHelper.this.videoDecimator.inputFramerate() - TimerSurfaceTextureHelper.this.auxiliaryDecimator.getTargetFrameRate();
            boolean bl = outBound = diff < 0.0f && Math.abs(diff) > 3.0f && (double)Math.abs(diff) > 0.1 * (double)TimerSurfaceTextureHelper.this.auxiliaryDecimator.getTargetFrameRate() || System.currentTimeMillis() - TimerSurfaceTextureHelper.this.prevTimeMillis > (long)(2 * TimerSurfaceTextureHelper.this.notifyIntervalInMS);
            if (outBound) {
                TimerSurfaceTextureHelper.this.proxyHandler.postDelayed(TimerSurfaceTextureHelper.this.supplementRunnable, (long)TimerSurfaceTextureHelper.this.notifyIntervalInMS);
            }
            TimerSurfaceTextureHelper.this.proxyHandler.postDelayed(TimerSurfaceTextureHelper.this.timerRunnable, (long)TimerSurfaceTextureHelper.this.notifyIntervalInMS);
        }
    };
    final Runnable scheduledExecutorRunnable = new Runnable(){

        @Override
        public void run() {
            if (!TimerSurfaceTextureHelper.this.isOesTextureInUse && !TimerSurfaceTextureHelper.this.isQuitting && TimerSurfaceTextureHelper.this.listener != null) {
                TimerSurfaceTextureHelper.this.videoDecimator.updateIncomingFramerate();
                if (TimerSurfaceTextureHelper.this.videoDecimator.dropFrame()) {
                    Logging.i(TimerSurfaceTextureHelper.TAG, "smoothDecimator dropFrame.");
                } else {
                    TimerSurfaceTextureHelper.this.handler.post(TimerSurfaceTextureHelper.this.timerNotifyRunnable);
                }
            }
        }
    };
    private static final int ANDROID_API_TEXTURE_IN_USE = 10;

    public static TimerSurfaceTextureHelper create(String threadName, EglBase.Context sharedContext) {
        return TimerSurfaceTextureHelper.create(threadName, false, sharedContext, 4);
    }

    public static TimerSurfaceTextureHelper create(String threadName, boolean smoothCapture, EglBase.Context sharedContext) {
        return TimerSurfaceTextureHelper.create(threadName, smoothCapture, sharedContext, 4);
    }

    public static TimerSurfaceTextureHelper create(final String threadName, final boolean smoothCapture, final EglBase.Context sharedContext, final int maxBufCount) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<TimerSurfaceTextureHelper>(){

            @Override
            @Nullable
            public TimerSurfaceTextureHelper call() {
                try {
                    return new TimerSurfaceTextureHelper(threadName, smoothCapture, sharedContext, handler, maxBufCount);
                }
                catch (RuntimeException e) {
                    Logging.e(TimerSurfaceTextureHelper.TAG, threadName + " create failure", e);
                    return null;
                }
            }
        });
    }

    public void executeSmoothCapture(int notifyIntervalInMS) {
        this.stopScheduledService();
        this.scheduledService = Executors.newScheduledThreadPool(4);
        this.scheduledService.scheduleAtFixedRate(this.scheduledExecutorRunnable, 0L, notifyIntervalInMS, TimeUnit.MILLISECONDS);
    }

    public void stopScheduledService() {
        if (this.scheduledService == null) {
            return;
        }
        try {
            this.scheduledService.shutdownNow();
            this.scheduledService = null;
        }
        catch (Throwable t) {
            this.scheduledService = null;
            Logging.i(TAG, "shutdownNow error.");
        }
    }

    private TimerSurfaceTextureHelper(String name, boolean smoothCapture, EglBase.Context sharedContext, Handler handler, int maxBufCount) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.smoothCapture = smoothCapture;
        Logging.d(TAG, "TimerSurfaceTextureHelper construct. name=" + name + ", smoothCapture=" + smoothCapture + ", sharedContext=" + sharedContext + ", handler=" + handler + ", maxBufCount=" + maxBufCount);
        HandlerThread delayThread = new HandlerThread("delayThread");
        delayThread.start();
        this.proxyHandler = new Handler(delayThread.getLooper());
        try {
            this.eglBase = EglBaseFactory.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "EglBase create error.", e);
            if (this.eglBase != null) {
                try {
                    this.eglBase.release();
                }
                catch (Exception ex) {
                    Logging.e(TAG, "EglBase release error.", ex);
                }
            }
            handler.getLooper().quit();
            this.proxyHandler.getLooper().quit();
            throw e;
        }
        this.videoDecimator = new VideoDecimator();
        this.auxiliaryDecimator = new VideoDecimator();
        this.sharedContext = sharedContext != null ? sharedContext : this.eglBase.getEglBaseContext();
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        this.textureBufferPool = TextureBufferPool.createWithinGlThread(name, maxBufCount, 6407, handler, this.eglBase, sharedContext, this.yuvConverter);
        this.textureBufferPool.setPoolBufferReleaseCallback(new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (TimerSurfaceTextureHelper.this.isQuitting && !TimerSurfaceTextureHelper.this.isOesTextureInUse && !TimerSurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                            TimerSurfaceTextureHelper.this.release();
                        }
                    }
                });
            }
        });
        TimerSurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture st) {
                TimerSurfaceTextureHelper.this.hasPendingTexture = true;
                if (TimerSurfaceTextureHelper.this.hasFrameRate && !TimerSurfaceTextureHelper.this.isSmoothCapture()) {
                    TimerSurfaceTextureHelper.this.proxyHandler.post(TimerSurfaceTextureHelper.this.systemGenerateRunnable);
                }
            }
        }, handler);
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener listener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(listener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(listener);
        }
    }

    private boolean isSmoothCapture() {
        return this.smoothCapture || this.frameRate <= 15;
    }

    public void setFrameRate(int frameRate) {
        if (frameRate <= 0) {
            throw new IllegalArgumentException("invalid frame rate");
        }
        this.frameRate = frameRate;
        this.hasFrameRate = true;
        Logging.i(TAG, "setFrameRate frameRate:" + frameRate + " smoothCapture: " + this.smoothCapture);
        if (this.isSmoothCapture()) {
            this.notifyIntervalInMS = (int)(1000.0f / (float)Math.min((double)(frameRate + 3), (double)frameRate * 1.067));
            if (null != this.videoDecimator) {
                this.videoDecimator.setTargetFramerate(frameRate);
            }
            if (null != this.auxiliaryDecimator) {
                this.auxiliaryDecimator.setTargetFramerate(frameRate);
            }
            Logging.i(TAG, "scheduledRunnable notifyIntervalInMS:" + this.notifyIntervalInMS);
            this.executeSmoothCapture(this.notifyIntervalInMS);
        } else {
            int minRate = frameRate += 3;
            if (frameRate >= 5) {
                minRate = 5;
            }
            if (frameRate >= 15) {
                minRate = 15;
            }
            if (frameRate >= 30) {
                minRate = 30;
            }
            this.notifyIntervalInMS = (int)(1000.0f / (float)minRate);
            if (null != this.videoDecimator) {
                this.videoDecimator.setTargetFramerate(frameRate);
            }
            if (null != this.auxiliaryDecimator) {
                this.auxiliaryDecimator.setTargetFramerate(minRate);
            }
            this.proxyHandler.postDelayed(this.timerRunnable, (long)this.notifyIntervalInMS);
        }
    }

    @Override
    public void startListening(VideoSink listener) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        if (this.notifyIntervalInMS == 0) {
            throw new IllegalStateException("frame rate not set");
        }
        this.pendingListener = listener;
        this.handler.post(this.setListenerRunnable);
    }

    public VideoFrame.TextureBuffer textureCopy(final VideoFrame.TextureBuffer textureBuffer) {
        if (textureBuffer.getTextureId() != this.oesTextureId) {
            throw new IllegalStateException("textureCopy called with unexpected textureId");
        }
        return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

            @Override
            public VideoFrame.TextureBuffer call() {
                return TimerSurfaceTextureHelper.this.textureBufferPool.textureCopy(textureBuffer, null);
            }
        });
    }

    @Override
    public void stopListening() {
        Logging.i(TAG, "stopListening()");
        this.stopScheduledService();
        this.proxyHandler.removeCallbacks(this.systemGenerateRunnable);
        this.proxyHandler.removeCallbacks(this.supplementRunnable);
        this.proxyHandler.removeCallbacks(this.timerRunnable);
        this.handler.removeCallbacks(this.setListenerRunnable);
        this.videoDecimator.reset();
        this.auxiliaryDecimator.reset();
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.listener = null;
                TimerSurfaceTextureHelper.this.pendingListener = null;
            }
        });
    }

    @Override
    public void setTextureSize(final int textureWidth, final int textureHeight) {
        if (textureWidth <= 0) {
            throw new IllegalArgumentException("Texture width must be positive, but was " + textureWidth);
        }
        if (textureHeight <= 0) {
            throw new IllegalArgumentException("Texture height must be positive, but was " + textureHeight);
        }
        Logging.i(TAG, "setTextureSize textureWidth: " + textureWidth + " textureHeight: " + textureHeight);
        this.surfaceTexture.setDefaultBufferSize(textureWidth, textureHeight);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.textureWidth = textureWidth;
                TimerSurfaceTextureHelper.this.textureHeight = textureHeight;
            }
        });
    }

    @Override
    public void setFrameRotation(final int rotation) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.frameRotation = rotation;
            }
        });
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    private void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.isOesTextureInUse = false;
                if (TimerSurfaceTextureHelper.this.isQuitting && !TimerSurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                    TimerSurfaceTextureHelper.this.release();
                }
            }
        });
    }

    @Override
    public boolean isOesTextureInUse() {
        return this.isOesTextureInUse;
    }

    @Override
    public void dispose() {
        Logging.i(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.isQuitting = true;
                if (!TimerSurfaceTextureHelper.this.isOesTextureInUse && !TimerSurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                    TimerSurfaceTextureHelper.this.release();
                } else {
                    Logging.i(TimerSurfaceTextureHelper.TAG, " not release yet, this: " + this + " isOesTextureInUse: " + TimerSurfaceTextureHelper.this.isOesTextureInUse);
                }
            }
        });
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        try {
            Object object = EglBase.lock;
            synchronized (object) {
                this.surfaceTexture.updateTexImage();
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "failed to updateTexImage. " + e.getMessage());
        }
    }

    private boolean tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || this.listener == null) {
            return false;
        }
        if (this.isOesTextureInUse) {
            if (this.listener instanceof IVideoCapture) {
                ((IVideoCapture)this.listener).onFrameDropped(10);
            }
            Logging.i(TAG, "frame Dropped texture in use. ");
            return true;
        }
        this.isOesTextureInUse = true;
        this.hasPendingTexture = false;
        this.updateTexImage();
        float[] transformMatrix = new float[16];
        this.surfaceTexture.getTransformMatrix(transformMatrix);
        long timestampNs = System.nanoTime();
        if (this.textureWidth == 0 || this.textureHeight == 0) {
            throw new RuntimeException("Texture size has not been set.");
        }
        TextureBuffer buffer = new TextureBuffer(this.sharedContext, this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix), this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.returnTextureFrame();
            }
        }, false);
        VideoFrame frame = new VideoFrame(buffer, this.frameRotation, timestampNs);
        this.listener.onFrame(frame);
        frame.release();
        return true;
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isOesTextureInUse || this.textureBufferPool.anyTextureInUse() || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        this.yuvConverter.release();
        this.textureBufferPool.dispose();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.proxyHandler.getLooper().quit();
        this.handler.getLooper().quit();
        this.hasFrameRate = false;
    }

    public static interface IVideoCapture
    extends VideoSink {
        public void onFrameDropped(int var1);
    }
}

