/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.os.Build;
import android.text.TextUtils;
import android.view.Surface;
import androidx.annotation.Nullable;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.HardwareVideoDecoder;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapperFactoryImpl;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoDecoder;
import io.agora.base.internal.video.VideoDecoderFactory;
import io.agora.base.internal.video.VideoDecoderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class HardwareVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "HardwareVideoDecoderFactory";
    @Nullable
    private final EglBase.Context sharedContext;
    @Nullable
    private final Surface surface;

    @Deprecated
    public HardwareVideoDecoderFactory() {
        this.sharedContext = null;
        this.surface = null;
    }

    public HardwareVideoDecoderFactory(EglBase.Context sharedContext) {
        this.sharedContext = sharedContext;
        this.surface = null;
    }

    public HardwareVideoDecoderFactory(Surface surface) {
        this.surface = surface;
        this.sharedContext = null;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        Integer colorFormat;
        if (!VideoCodecType.contains(codecType.getName())) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf(codecType.getName());
        MediaCodecInfo info = VideoDecoderUtils.findCodecForType(type, this.parseGoogleDec(codecType.params), this.parseGoogleDav1dDec(codecType.params), this.parseSkipCodecByName(codecType.params));
        if (info == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities capabilities = null;
        try {
            capabilities = info.getCapabilitiesForType(type.mimeType());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (capabilities != null && capabilities.colorFormats != null) {
            Logging.i(TAG, "supportedColorFormat : " + Arrays.toString(capabilities.colorFormats));
        }
        EglBase.Context eglContext = this.sharedContext;
        Surface renderSurface = this.surface;
        if (codecType.params != null && codecType.params.containsKey("av_dec_output_byte_frame")) {
            Logging.w(TAG, "force decode to byte frame");
            eglContext = null;
        }
        if (renderSurface != null) {
            Logging.w(TAG, "force direct surface");
            eglContext = null;
        }
        if ((colorFormat = MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, capabilities)) == null) {
            Logging.w(TAG, "Unsupported color format!");
            return null;
        }
        Logging.i(TAG, "select color format: " + colorFormat);
        return new HardwareVideoDecoder(new MediaCodecWrapperFactoryImpl(), info.getName(), type, codecType.params, colorFormat, eglContext, renderSurface);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.H264, VideoCodecType.H265, VideoCodecType.AV1}) {
            MediaCodecInfo codec = VideoDecoderUtils.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    private boolean parseGoogleDec(Map<String, String> params) {
        try {
            String googleDecEnable = params.get("av_dec_google_enable");
            if (googleDecEnable == null || TextUtils.isEmpty((CharSequence)googleDecEnable)) {
                return false;
            }
            boolean value = Boolean.parseBoolean(googleDecEnable);
            Logging.d(TAG, "get google dec enable: " + value);
            return value;
        }
        catch (Exception e) {
            Logging.d(TAG, "fail to convert google dec enable");
            return false;
        }
    }

    private boolean parseGoogleDav1dDec(Map<String, String> params) {
        try {
            String googleDav1dDecEnable = params.get("av_dec_google_dav1d_enable");
            if (googleDav1dDecEnable == null || TextUtils.isEmpty((CharSequence)googleDav1dDecEnable)) {
                return true;
            }
            boolean value = Boolean.parseBoolean(googleDav1dDecEnable);
            Logging.d(TAG, "get google dav1d dec enable: " + value);
            return value;
        }
        catch (Exception e) {
            Logging.d(TAG, "fail to convert google dav1d dec enable");
            return true;
        }
    }

    @Nullable
    private String parseSkipCodecByName(Map<String, String> params) {
        try {
            String codecName = params.get("av_hw_dec_skip_by_name");
            if (codecName == null || TextUtils.isEmpty((CharSequence)codecName)) {
                return null;
            }
            Logging.d(TAG, "get skip name: " + codecName);
            return codecName;
        }
        catch (Exception e) {
            Logging.d(TAG, "fail to convert skip codec name");
            return null;
        }
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        String name = info.getName();
        if (Build.VERSION.SDK_INT >= 21 && name.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && name.startsWith("OMX.Exynos.");
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(String codecType) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo info, boolean preferHWDecoder) {
        return this.createDecoder(info);
    }
}

