/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Range;
import android.view.Surface;
import androidx.annotation.Nullable;
import io.agora.base.ColorSpace;
import io.agora.base.JavaI010Buffer;
import io.agora.base.JavaI420Buffer;
import io.agora.base.NV12Buffer;
import io.agora.base.NV21Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.CodecSpecificInfo;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EncodedImage;
import io.agora.base.internal.video.FrameExtraInfo;
import io.agora.base.internal.video.HdrUtil;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapper;
import io.agora.base.internal.video.MediaCodecWrapperFactory;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.base.internal.video.VideoCodecProfile;
import io.agora.base.internal.video.VideoCodecStatus;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoDecoder;
import io.agora.base.internal.video.VideoDecoderUtils;
import io.agora.base.internal.video.VideoSink;
import io.agora.base.internal.video.YuvHelper;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

@TargetApi(value=16)
class HardwareVideoDecoder
implements VideoDecoder,
VideoSink {
    private static final String TAG = "HardwareVideoDecoder";
    private static final boolean DEBUG = false;
    private static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    private static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final String FEATURE_LowLatency = "low-latency";
    private static final int MAX_DECODER_Q_SIZE = 5;
    private static final int MAX_DECODER_Q_WAIT_TIMEOUT_MS = 2000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int DEQUEUE_OUTPUT_BUFFER_HIGH_LATENCY_TIMEOUT_US = 500000;
    private int dequeueOutputTimeUs = 100000;
    private static final int MAX_DECODE_TIME_MS = 2000;
    private static final int MAX_DECODE_HIGH_LATENCY_TIME_MS = 300;
    private int maxDecodeTimeMs = 2000;
    private static final int MAX_NO_INPUT_LIMIT = 5;
    private static final int INVALID_PRESENTATIO_LIMIT = 3;
    private static final int MAX_HIGH_LATENCY_DECODE_LIMIT = 8;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecType codecType;
    private boolean shouldResetCodec;
    private boolean fallbackByCodecError;
    private boolean highLatencyTrigger;
    private VideoDecoder.Settings settings;
    private long firstDecoderQueueFullMs = -1L;
    private long firstInvalidPresentationMs = -1L;
    private int invalidPresentationCount = 0;
    private int colorFormat;
    private final Map<String, String> params;
    @Nullable
    private String customConfigJson;
    private long lastPresentationTimestampUs;
    @Nullable
    private volatile VideoDecoderUtils.SupportCodecInfo supportCodecInfo;
    private final Queue<TimeStamps> decodeTimeStamps = new ConcurrentLinkedQueue<TimeStamps>();
    @Nullable
    private Thread outputThread;
    private ThreadUtils.ThreadChecker outputThreadChecker;
    @Nullable
    private Handler proxyThreadHandler;
    private volatile boolean running = false;
    @Nullable
    private volatile Exception shutdownException = null;
    private boolean deliveredVideoFrame;
    private final Object dimensionLock = new Object();
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private int maxSupportedWidth = 0;
    private int minSupportedWidth = 0;
    private int maxSupportedHeight = 0;
    private int minSupportedHeight = 0;
    private boolean isHisiCodec = false;
    private boolean textureCopy = true;
    private int deliveredCount;
    private int inputDropCount;
    private boolean hasDecodedFirstFrame;
    private boolean keyFrameRequired;
    @Nullable
    private EglBase.Context sharedContext;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private Surface surface = null;
    private static final int MAX_TEXTURE_BUFFER_COUNT = 16;
    private Surface directSurface;
    private final Object textureMetadataLock = new Object();
    private static final int MAX_DEQUEUED_OUTPUTBUFFERS = 3;
    private final Queue<DecodedTextureMetadata> dequeuedSurfaceOutputBuffers = new LinkedList<DecodedTextureMetadata>();
    @Nullable
    private DecodedTextureMetadata renderedTextureMetadata;
    @Nullable
    private VideoDecoder.Callback callback;
    @Nullable
    private MediaCodecWrapper codec = null;
    private Map<Long, CodecSpecificInfo> codecSpecificInfoMap = new ConcurrentHashMap<Long, CodecSpecificInfo>();
    private Map<Long, FrameExtraInfo> bframeExtraInfoMap = new ConcurrentHashMap<Long, FrameExtraInfo>();
    private static Map<String, Boolean> codecUnavailableMap = new ConcurrentHashMap<String, Boolean>();

    HardwareVideoDecoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, VideoCodecType codecType, Map<String, String> params, int colorFormat, EglBase.Context sharedContext, Surface directSurface) {
        if (MediaCodecUtils.useHighLatencyStrategy()) {
            this.dequeueOutputTimeUs = 500000;
            this.maxDecodeTimeMs = 300;
        }
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = codecName;
        this.codecType = codecType;
        this.colorFormat = colorFormat;
        this.params = params;
        this.sharedContext = sharedContext;
        this.directSurface = directSurface;
    }

    @Override
    public VideoCodecStatus attachProxyThread() {
        if (null == this.proxyThreadHandler) {
            Logging.i(TAG, "attach decoder proxyThread");
            try {
                HandlerThread proxyThread = new HandlerThread("proxyThread-Decoder");
                proxyThread.start();
                this.proxyThreadHandler = new Handler(proxyThread.getLooper());
            }
            catch (Exception e) {
                Logging.w(TAG, "attach decoder proxyThread fail!, " + e.getMessage());
            }
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        if (this.running) {
            Logging.w(TAG, "already initialized!");
            return VideoCodecStatus.OK;
        }
        this.callback = callback;
        this.settings = settings;
        this.parseTextureCopyFromParam();
        if (settings.lumaBitDepth == HdrUtil.LumaBitDepth.LUMA10BIT.depth() && this.parse10bitYUVFromParam()) {
            Logging.i(TAG, "force use yuv out in 10bit.");
            this.sharedContext = null;
        }
        if (this.directSurface != null) {
            this.surface = this.directSurface;
        } else if (this.sharedContext != null) {
            this.surfaceTextureHelper = this.createSurfaceTextureHelper();
            if (this.surfaceTextureHelper == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            this.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            this.surfaceTextureHelper.startListening(this);
            this.surfaceTextureHelper.setLumaBitDepth(settings.lumaBitDepth);
        }
        return this.initDecodeInternal(settings);
    }

    private void parseTextureCopyFromParam() {
        boolean parseResult = true;
        try {
            String textureCopyStr = this.params.get("av_dec_texture_copy_enable");
            Boolean result = null;
            if (textureCopyStr != null) {
                result = Boolean.parseBoolean(textureCopyStr);
            }
            if (result != null) {
                this.textureCopy = result;
            }
        }
        catch (Exception e) {
            parseResult = false;
            Logging.i(TAG, "fail to convert hwdec textureCopy");
        }
        if (parseResult) {
            Logging.i(TAG, "parse hwdec textureCopy success, value : " + this.textureCopy);
        }
    }

    private boolean parse10bitYUVFromParam() {
        boolean parseResult = true;
        try {
            String yuv10bitStr = this.params.get("av_dec_output_10bit_frame");
            Boolean result = null;
            if (yuv10bitStr != null) {
                result = Boolean.parseBoolean(yuv10bitStr);
            }
            if (result != null) {
                parseResult = result;
            }
        }
        catch (Exception e) {
            parseResult = false;
            Logging.i(TAG, "fail to convert hwdec textureCopy");
        }
        if (parseResult) {
            Logging.i(TAG, "parse hwdec force yuv out success, value : " + this.textureCopy);
        }
        return parseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VideoCodecStatus initDecodeInternal(VideoDecoder.Settings settings) {
        VideoCodecStatus status;
        Logging.i(TAG, "initDecodeInternal");
        if (this.proxyThreadHandler == null) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.outputThread != null) {
            Logging.e(TAG, "initDecodeInternal called while the codec is already running");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        Boolean codecUnavailable = codecUnavailableMap.get(this.codecName);
        if (codecUnavailable != null && codecUnavailable.booleanValue()) {
            Logging.e(TAG, "initDecodeInternal failed, by createByCodecName.");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.width = settings.width;
        this.height = settings.height;
        if (this.surfaceTextureHelper != null) {
            try {
                this.surfaceTextureHelper.setTextureSize(this.width, this.height);
            }
            catch (IllegalArgumentException ex) {
                Logging.e(TAG, "setTextureSize:", ex);
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
        }
        this.stride = this.width;
        this.sliceHeight = this.height;
        this.hasDecodedFirstFrame = false;
        this.deliveredCount = 0;
        this.highLatencyTrigger = false;
        this.keyFrameRequired = true;
        this.deliveredVideoFrame = false;
        this.shouldResetCodec = false;
        this.fallbackByCodecError = false;
        this.firstDecoderQueueFullMs = -1L;
        this.firstInvalidPresentationMs = -1L;
        this.invalidPresentationCount = 0;
        if (null != this.codecName && null != Build.HARDWARE && this.codecName.startsWith("OMX.hisi.") && Build.HARDWARE.startsWith("bigfish")) {
            this.isHisiCodec = true;
            Logging.i(TAG, " bigfish isHisiCodec: " + this.isHisiCodec);
        } else {
            this.isHisiCodec = false;
        }
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                VideoCodecStatus result = VideoCodecStatus.OK;
                try {
                    HardwareVideoDecoder.this.codec = HardwareVideoDecoder.this.mediaCodecWrapperFactory.createByCodecName(HardwareVideoDecoder.this.codecName);
                }
                catch (Exception e) {
                    Logging.e(HardwareVideoDecoder.TAG, "Cannot create media decoder " + HardwareVideoDecoder.this.codecName);
                    result = VideoCodecStatus.FALLBACK_SOFTWARE;
                }
                return result;
            }
        };
        try {
            status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status == null) {
                codecUnavailableMap.put(this.codecName, true);
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (status != VideoCodecStatus.OK) {
                codecUnavailableMap.put(this.codecName, true);
                return status;
            }
        }
        catch (Exception e) {
            codecUnavailableMap.put(this.codecName, true);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = null;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                codecCapabilities = this.codec.getCodecInfo(this.codecType.mimeType());
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "Cannot get CodecInfo " + this.codecName);
        }
        this.readVideoCapabilities(codecCapabilities);
        final MediaFormat format = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)this.width, (int)this.height);
        if (this.sharedContext == null && this.directSurface == null) {
            if (settings.lumaBitDepth == HdrUtil.LumaBitDepth.LUMA10BIT.depth()) {
                Integer colorFormat = MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS_HDR, codecCapabilities);
                if (colorFormat == null) {
                    Logging.w(TAG, "selectColorFormat is null");
                    return VideoCodecStatus.FALLBACK_SOFTWARE;
                }
                this.colorFormat = 54;
            }
            format.setInteger("color-format", this.colorFormat);
        }
        if (Build.VERSION.SDK_INT >= 30 && this.isSupportedLowLatency(codecCapabilities)) {
            format.setInteger(FEATURE_LowLatency, 1);
        }
        if (settings.lumaBitDepth == HdrUtil.LumaBitDepth.LUMA10BIT.depth() && Build.VERSION.SDK_INT >= 24) {
            format.setByteBuffer("hdr-static-info", MediaCodecUtils.getHdrStaticInfo());
        }
        this.customConfigJson = this.params.get("av_dec_video_hwdec_config");
        MediaCodecUtils.applyCustomConfig(format, this.customConfigJson);
        Logging.w(TAG, "Format: " + format);
        callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                try {
                    HardwareVideoDecoder.this.codec.configure(format, HardwareVideoDecoder.this.surface, null, MediaCodecUtils.applyCustomFlags(HardwareVideoDecoder.this.customConfigJson));
                    HardwareVideoDecoder.this.codec.start();
                }
                catch (Throwable t) {
                    Logging.e(HardwareVideoDecoder.TAG, "initDecode failed" + t.getMessage());
                    HardwareVideoDecoder.this.release();
                    return VideoCodecStatus.FALLBACK_SOFTWARE;
                }
                return VideoCodecStatus.OK;
            }
        };
        try {
            status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (status != VideoCodecStatus.OK) {
                return status;
            }
        }
        catch (Exception e) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        Object object = this.textureMetadataLock;
        synchronized (object) {
            this.dequeuedSurfaceOutputBuffers.clear();
        }
        this.supportCodecInfo = VideoDecoderUtils.getSupportedDecoders();
        this.running = true;
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        Logging.i(TAG, "initDecodeInternal " + this.codecType.mimeType() + " done, format: " + format);
        return VideoCodecStatus.OK;
    }

    private void readVideoCapabilities(MediaCodecInfo.CodecCapabilities codecCapabilities) {
        Range heights;
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (codecCapabilities == null) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return;
        }
        Range widths = videoCapabilities.getSupportedWidths();
        int maxSupportedWidth = 0;
        int minSupportedWidth = 0;
        int maxSupportedHeight = 0;
        int minSupportedHeight = 0;
        if (widths != null) {
            maxSupportedWidth = (Integer)widths.getUpper();
            minSupportedWidth = (Integer)widths.getLower();
        }
        if ((heights = videoCapabilities.getSupportedHeights()) != null) {
            maxSupportedHeight = (Integer)heights.getUpper();
            minSupportedHeight = (Integer)heights.getLower();
        }
        Logging.i(TAG, this.codecType.mimeType() + "  max supported size:" + maxSupportedWidth + "x" + maxSupportedHeight + " min supported size:" + minSupportedWidth + "x" + minSupportedHeight);
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.i(TAG, "max supported instance: " + codecCapabilities.getMaxSupportedInstances());
        }
    }

    private boolean isSupportedLowLatency(MediaCodecInfo.CodecCapabilities codecCapabilities) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        if (codecCapabilities == null) {
            return false;
        }
        boolean isSupportedLowLatency = false;
        try {
            isSupportedLowLatency = codecCapabilities.isFeatureSupported(FEATURE_LowLatency);
        }
        catch (Exception e) {
            Logging.e(TAG, "Cannot get LowLatency: " + e.getMessage());
        }
        return isSupportedLowLatency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus decode(final EncodedImage frame, VideoDecoder.DecodeInfo info, final CodecSpecificInfo codecSpecificInfo, final FrameExtraInfo frameExtraInfo) {
        VideoCodecStatus status;
        if (this.codec == null || this.callback == null || this.proxyThreadHandler == null || !this.running) {
            Logging.i(TAG, "decode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (frame.buffer == null) {
            Logging.e(TAG, "decode() - no input data");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        final int size = frame.buffer.remaining();
        if (size == 0) {
            Logging.e(TAG, "decode() - input buffer empty");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            int width = this.width;
            int height = this.height;
        }
        if (codecSpecificInfo.lumaBitDepth != 0 && codecSpecificInfo.lumaBitDepth != this.settings.lumaBitDepth) {
            Logging.e(TAG, "decode() - lumaBitDepth change: " + codecSpecificInfo.lumaBitDepth + " should reset codec.");
            status = this.reinitDecode(codecSpecificInfo.lumaBitDepth);
            if (status != VideoCodecStatus.OK) {
                return status;
            }
            return VideoCodecStatus.CODEC_RESET_DECODER;
        }
        if (this.highLatencyTrigger) {
            Logging.e(TAG, "decode() - codec high delay trigger, should reset codec.");
            this.highLatencyTrigger = false;
            status = this.reinitDecode(frame.encodedWidth, frame.encodedHeight);
            if (status != VideoCodecStatus.OK) {
                return status;
            }
            return VideoCodecStatus.CODEC_RESET_DECODER;
        }
        if (frame.encodedWidth * frame.encodedHeight > 0 && (frame.encodedWidth != this.settings.width || frame.encodedHeight != this.settings.height) || this.shouldResetCodec) {
            Logging.w(TAG, "decode() - reinitDecode.");
            status = this.reinitDecode(frame.encodedWidth, frame.encodedHeight);
            if (status != VideoCodecStatus.OK) {
                return status;
            }
            if (this.shouldResetCodec) {
                return VideoCodecStatus.CODEC_RESET_DECODER;
            }
        }
        if (this.inputDropCount > 5) {
            this.release();
            Logging.w(TAG, "Fallback to software, no input buffers available");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.invalidPresentationCount > 3) {
            Logging.e(TAG, "invalid PresentationTimeUs over limit counts.");
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.decodeTimeStamps.size() > 5) {
            long now = System.currentTimeMillis();
            if (this.firstDecoderQueueFullMs < 0L) {
                this.firstDecoderQueueFullMs = now;
            }
            if (now - this.firstDecoderQueueFullMs > 2000L) {
                Logging.e(TAG, "Fallback to software, decoder queue full");
                this.release();
                return VideoCodecStatus.ERROR_CODEC_OUTPUT_FAILURE;
            }
        }
        if (this.fallbackByCodecError) {
            Logging.e(TAG, "decode() FALLBACK_SOFTWARE");
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.callback != null) {
            long opaque = 0L;
            if (null != codecSpecificInfo) {
                opaque = codecSpecificInfo.opaque;
            } else {
                Logging.e(TAG, "onDecodeBufferPrepared fail, cannot get opaque.");
            }
            this.callback.onDecodeBufferPrepared(opaque);
        }
        if (this.keyFrameRequired) {
            if (frame.frameType != EncodedImage.FrameType.VideoFrameKey) {
                Logging.e(TAG, "decode() - key frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
            if (!frame.completeFrame) {
                Logging.e(TAG, "decode() - complete frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
        }
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                ByteBuffer buffer;
                int index;
                try {
                    index = HardwareVideoDecoder.this.codec.dequeueInputBuffer(500000L);
                }
                catch (IllegalStateException e) {
                    Logging.e(HardwareVideoDecoder.TAG, "dequeueInputBuffer failed", e);
                    if (!HardwareVideoDecoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                if (index == -1) {
                    HardwareVideoDecoder.this.inputDropCount++;
                    Logging.i(HardwareVideoDecoder.TAG, "Dropped frame, no input buffers available");
                    return VideoCodecStatus.NO_OUTPUT;
                }
                HardwareVideoDecoder.this.inputDropCount = 0;
                if (index < 0) {
                    Logging.e(HardwareVideoDecoder.TAG, "decode() - no HW buffers available; decoder falling behind");
                    return VideoCodecStatus.ERROR;
                }
                try {
                    buffer = HardwareVideoDecoder.this.codec.getInputBuffers()[index];
                }
                catch (IllegalStateException e) {
                    Logging.e(HardwareVideoDecoder.TAG, "getInputBuffers failed", e);
                    if (!HardwareVideoDecoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                if (buffer.capacity() < size) {
                    Logging.e(HardwareVideoDecoder.TAG, "decode() - HW buffer too small");
                    return VideoCodecStatus.ERROR;
                }
                buffer.put(frame.buffer);
                long presentationTimeUs = TimeUnit.NANOSECONDS.toMicros(frame.captureTimeNs);
                if (HardwareVideoDecoder.this.lastPresentationTimestampUs == presentationTimeUs) {
                    presentationTimeUs = ++HardwareVideoDecoder.this.lastPresentationTimestampUs;
                } else {
                    HardwareVideoDecoder.this.lastPresentationTimestampUs = presentationTimeUs;
                }
                TimeStamps timeStamps = null;
                try {
                    if (codecSpecificInfo != null) {
                        codecSpecificInfo.elapsedRealtime = SystemClock.elapsedRealtime();
                        HardwareVideoDecoder.this.codecSpecificInfoMap.put(presentationTimeUs, codecSpecificInfo);
                    } else {
                        HardwareVideoDecoder.this.codecSpecificInfoMap.put(presentationTimeUs, new CodecSpecificInfo(null, SystemClock.elapsedRealtime()));
                    }
                    timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), presentationTimeUs, frame.rotation);
                    HardwareVideoDecoder.this.decodeTimeStamps.add(timeStamps);
                    HardwareVideoDecoder.this.bframeExtraInfoMap.put(presentationTimeUs, frameExtraInfo);
                    HardwareVideoDecoder.debug_log("queue input buffer, pts_us: " + presentationTimeUs);
                    HardwareVideoDecoder.this.codec.queueInputBuffer(index, 0, size, presentationTimeUs, 0);
                }
                catch (RuntimeException e) {
                    Logging.e(HardwareVideoDecoder.TAG, "queueInputBuffer failed", e);
                    HardwareVideoDecoder.this.codecSpecificInfoMap.remove(presentationTimeUs);
                    HardwareVideoDecoder.this.bframeExtraInfoMap.remove(presentationTimeUs);
                    HardwareVideoDecoder.this.decodeTimeStamps.remove(timeStamps);
                    if (!HardwareVideoDecoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                if (HardwareVideoDecoder.this.keyFrameRequired) {
                    HardwareVideoDecoder.this.keyFrameRequired = false;
                }
                return VideoCodecStatus.OK;
            }
        };
        try {
            VideoCodecStatus status2 = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status2 == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            return status2;
        }
        catch (Exception e) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
    }

    @Override
    public String getImplementationName() {
        return "HWDecoder";
    }

    @Override
    @Nullable
    public VideoDecoder.VideoHWCodecSpec getVideoHWCodecSpec() {
        String supportCodecNames = "";
        if (this.supportCodecInfo != null) {
            supportCodecNames = this.supportCodecInfo.getCodecNames();
        }
        return new VideoDecoder.VideoHWCodecSpec(this.codecName, this.maxSupportedWidth + "x" + this.maxSupportedHeight, -1, this.sharedContext != null ? 1 : 0, -1, -1, supportCodecNames);
    }

    @Override
    public long createNativeVideoDecoder() {
        return 0L;
    }

    @Override
    public boolean isHardwareDecoder() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus release() {
        Logging.i(TAG, "release");
        VideoCodecStatus status = this.releaseInternal();
        if (this.surface != null && this.directSurface == null) {
            this.releaseSurface();
            this.surface = null;
            if (this.surfaceTextureHelper != null) {
                this.surfaceTextureHelper.stopListening();
                this.surfaceTextureHelper.dispose();
                this.surfaceTextureHelper = null;
            }
        }
        Object object = this.textureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
        }
        this.callback = null;
        this.deliveredVideoFrame = false;
        this.shouldResetCodec = false;
        this.fallbackByCodecError = false;
        this.codecSpecificInfoMap.clear();
        this.decodeTimeStamps.clear();
        this.deliveredCount = 0;
        this.inputDropCount = 0;
        this.highLatencyTrigger = false;
        this.firstDecoderQueueFullMs = -1L;
        this.firstInvalidPresentationMs = -1L;
        this.invalidPresentationCount = 0;
        return status;
    }

    @Override
    public VideoCodecStatus detachProxyThread() {
        if (this.proxyThreadHandler != null) {
            this.proxyThreadHandler.removeCallbacksAndMessages(null);
            this.proxyThreadHandler.getLooper().quitSafely();
            this.proxyThreadHandler = null;
            Logging.i(TAG, "detach decoder proxyThread");
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus releaseInternal() {
        if (!this.running) {
            Logging.i(TAG, "release: Decoder is not running.");
            return VideoCodecStatus.OK;
        }
        try {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media decoder release timeout", new RuntimeException());
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.TIMEOUT;
                return videoCodecStatus;
            }
            if (this.shutdownException != null) {
                Logging.e(TAG, "Media decoder release error", new RuntimeException(this.shutdownException));
                this.shutdownException = null;
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.ERROR;
                return videoCodecStatus;
            }
        }
        finally {
            this.codec = null;
            this.outputThread = null;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus reinitDecode(int newWidth, int newHeight) {
        VideoCodecStatus status = this.releaseInternal();
        if (this.callback != null) {
            this.callback.onDecodeReset();
        }
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        this.settings.width = newWidth;
        this.settings.height = newHeight;
        return this.initDecodeInternal(this.settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VideoCodecStatus reinitDecode(int lumaBitDepth) {
        VideoCodecStatus status = this.releaseInternal();
        if (this.callback != null) {
            this.callback.onDecodeReset();
        }
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        this.settings.lumaBitDepth = lumaBitDepth;
        if (this.surface != null && this.directSurface == null) {
            this.releaseSurface();
            this.surface = null;
        }
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.stopListening();
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        Object object = this.textureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
        }
        this.codecSpecificInfoMap.clear();
        return this.initDecode(this.settings, this.callback);
    }

    private Thread createOutputThread() {
        return new Thread("HardwareVideoDecoder.outputThread"){

            @Override
            public void run() {
                HardwareVideoDecoder.this.outputThreadChecker = new ThreadUtils.ThreadChecker();
                while (HardwareVideoDecoder.this.running) {
                    HardwareVideoDecoder.this.deliverDecodedFrame();
                }
                HardwareVideoDecoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverDecodedFrame() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int result = this.codec.dequeueOutputBuffer(info, this.dequeueOutputTimeUs);
            HardwareVideoDecoder.debug_log("dequeue output buffer, pts_us: " + info.presentationTimeUs + " result: " + result);
            if (result == -2) {
                this.reformat(this.codec.getOutputFormat());
                return;
            }
            if (result == -3) {
                Logging.i(TAG, "Decoder outputbuffers changed");
                if (this.hasDecodedFirstFrame) {
                    Logging.w(TAG, "Unexpected output buffer change event. Reset codec.");
                    this.shouldResetCodec = true;
                    return;
                }
            }
            if (result < 0) {
                return;
            }
            if (info.presentationTimeUs == 0L) {
                if (System.currentTimeMillis() - this.firstInvalidPresentationMs > 2000L) {
                    this.invalidPresentationCount = 0;
                    this.firstInvalidPresentationMs = System.currentTimeMillis();
                }
                ++this.invalidPresentationCount;
                Logging.i(TAG, "dequeueOutputBuffer fail, presentationTimeUs is 0.");
                this.codec.releaseOutputBuffer(result, this.directSurface != null);
                return;
            }
            this.hasDecodedFirstFrame = true;
            this.firstDecoderQueueFullMs = -1L;
            if (this.directSurface != null) {
                this.deliverToDirectSurface(result, info);
            } else if (this.surfaceTextureHelper != null) {
                this.deliverTextureFrame(result, info);
            } else {
                this.deliverByteFrame(result, info);
            }
            this.deliveredVideoFrame = true;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverDecodedFrame failed", e);
            if (!this.deliveredVideoFrame) {
                this.fallbackByCodecError = true;
            } else if (MediaCodecUtils.isMediaCodecException(e) != VideoCodecStatus.ERROR) {
                this.fallbackByCodecError = true;
            } else {
                this.shouldResetCodec = true;
            }
        }
        catch (Exception e) {
            this.fallbackByCodecError = true;
            Logging.e(TAG, "deliverDecodedFrame error", e);
        }
    }

    private void deliverToDirectSurface(int index, MediaCodec.BufferInfo info) {
        try {
            this.codec.releaseOutputBuffer(index, true);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverToDirectSurface failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTextureFrame(int index, MediaCodec.BufferInfo info) {
        int height;
        int width;
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
        }
        int delaySize = this.decodeTimeStamps.size();
        TimeStamps timeStamps = this.decodeTimeStamps.poll();
        if (timeStamps == null) {
            Logging.e(TAG, "deliverTextureFrame cannot find presentationTimeUs.");
            return;
        }
        int decodeTimeMs = (int)(SystemClock.elapsedRealtime() - timeStamps.prevElapsedRealtime);
        DecodedTextureMetadata newFrame = new DecodedTextureMetadata(index, width, height, timeStamps.rotation, timeStamps.presentationTimeStampUs, decodeTimeMs, delaySize, timeStamps.prevElapsedRealtime, info.presentationTimeUs);
        Object object2 = this.textureMetadataLock;
        synchronized (object2) {
            this.dequeuedSurfaceOutputBuffers.offer(newFrame);
            this.maybeRenderDecodedTextureBuffer();
            if (this.dequeuedSurfaceOutputBuffers.size() >= 3) {
                DecodedTextureMetadata droppedFrame = this.dequeuedSurfaceOutputBuffers.poll();
                HardwareVideoDecoder.debug_log("drop the oldest output frame in cache, pts_us: " + droppedFrame.presentationTimestampUs);
                try {
                    this.codec.releaseOutputBuffer(droppedFrame.outputBufferIndex, false);
                }
                catch (IllegalStateException e) {
                    Logging.e(TAG, "deliverTextureFrame failed", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        CodecSpecificInfo codecSpecificInfo;
        long elapsedRealtime;
        int decodeTimeMs;
        long timestampNs;
        long presentationTimeUs;
        int decodecDelayTimeMs = 0;
        int decodecDelayFrames = this.codecSpecificInfoMap.size();
        Object object = this.textureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata == null) {
                throw new IllegalStateException("Rendered texture metadata was null in onTextureFrameAvailable.");
            }
            presentationTimeUs = this.renderedTextureMetadata.infoPresentationTimeUs;
            timestampNs = this.renderedTextureMetadata.presentationTimestampUs;
            decodeTimeMs = this.renderedTextureMetadata.decodeTimeMs;
            elapsedRealtime = this.renderedTextureMetadata.prevElapsedRealtime;
            int delaySize = this.renderedTextureMetadata.delaySize;
            codecSpecificInfo = this.codecSpecificInfoMap.remove(this.renderedTextureMetadata.presentationTimestampUs);
            this.renderedTextureMetadata = null;
            this.maybeRenderDecodedTextureBuffer();
        }
        if (presentationTimeUs == 0L) {
            presentationTimeUs = timestampNs;
        }
        VideoFrame frameWithModifiedTimeStamp = new VideoFrame(frame.getBuffer(), frame.getRotation(), timestampNs * 1000L);
        FrameExtraInfo frameExtraInfo = this.bframeExtraInfoMap.remove(presentationTimeUs);
        if (frameExtraInfo == null) {
            Logging.e(TAG, "HW frameExtraInfo empty. cannot find: " + presentationTimeUs);
            this.fallbackByCodecError = true;
            frame.release();
            return;
        }
        if (codecSpecificInfo == null) {
            Logging.e(TAG, "HW decodeTimeStamps empty. cannot find: " + presentationTimeUs);
        }
        if ((decodecDelayTimeMs = (int)(SystemClock.elapsedRealtime() - elapsedRealtime)) > this.maxDecodeTimeMs) {
            if (MediaCodecUtils.useHighLatencyStrategy() && this.deliveredCount >= 8) {
                this.highLatencyTrigger = true;
                this.deliveredCount = 0;
            }
            Logging.w(TAG, "Very high decode time: " + decodecDelayTimeMs + "ms.");
            decodecDelayTimeMs = this.maxDecodeTimeMs;
        }
        boolean directOes = false;
        if (codecSpecificInfo != null && codecSpecificInfo.getVideoCodecType() == VideoCodecType.H265 && (codecSpecificInfo.getVideoCodecProfile() == VideoCodecProfile.HEVCMain10 || codecSpecificInfo.getVideoCodecProfile() == VideoCodecProfile.HEVCMain10HDR10 || codecSpecificInfo.getVideoCodecProfile() == VideoCodecProfile.HEVCMain10HDR10Plus) || this.settings.lumaBitDepth == HdrUtil.LumaBitDepth.LUMA10BIT.depth()) {
            directOes = true;
        }
        if (this.deliveredCount == 0) {
            Logging.i(TAG, "directOes: " + directOes + " is10BitLumaDepth:  textureCopy: " + this.textureCopy);
        }
        int supportCodecs = 0;
        if (this.supportCodecInfo != null) {
            supportCodecs = this.supportCodecInfo.getSupportCodecs();
        }
        if (directOes || !this.textureCopy) {
            VideoFrame decodedFrame = new VideoFrame(frameWithModifiedTimeStamp.getBuffer(), frameWithModifiedTimeStamp.getRotation(), frameWithModifiedTimeStamp.getTimestampNs());
            if (this.running) {
                this.callback.onDecodedFrame(decodedFrame, decodeTimeMs, null, decodecDelayTimeMs, decodecDelayFrames, supportCodecs, codecSpecificInfo, frameExtraInfo);
            }
            decodedFrame.release();
            HardwareVideoDecoder.debug_log("frame delivered to native by direct oes, pts_us: " + presentationTimeUs);
            ++this.deliveredCount;
        } else {
            VideoFrame.TextureBuffer textureBufferCopy = this.surfaceTextureHelper.textureCopy((VideoFrame.TextureBuffer)frameWithModifiedTimeStamp.getBuffer());
            if (textureBufferCopy == null) {
                Logging.i(TAG, "failed to copy texture buffer, drop frame");
            } else {
                VideoFrame decodedFrame = new VideoFrame(textureBufferCopy, frameWithModifiedTimeStamp.getRotation(), frameWithModifiedTimeStamp.getTimestampNs());
                if (this.running) {
                    this.callback.onDecodedFrame(decodedFrame, decodeTimeMs, null, decodecDelayTimeMs, decodecDelayFrames, supportCodecs, codecSpecificInfo, frameExtraInfo);
                }
                decodedFrame.release();
                HardwareVideoDecoder.debug_log("frame delivered to native, pts_us: " + presentationTimeUs + "decode delay time: " + decodecDelayTimeMs + " ms, deliveredCount: " + this.deliveredCount);
                ++this.deliveredCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverByteFrame(int result, MediaCodec.BufferInfo info) {
        int decodecDelayTimeMs;
        int sliceHeight;
        int stride;
        int height;
        int width;
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
            stride = this.stride;
            sliceHeight = this.sliceHeight;
        }
        if (this.settings.lumaBitDepth != HdrUtil.LumaBitDepth.LUMA10BIT.depth()) {
            if (info.size < width * height * 3 / 2) {
                Logging.e(TAG, "Insufficient output buffer size: " + info.size);
                return;
            }
            if (info.size < stride * height * 3 / 2 && sliceHeight == height && stride > width) {
                stride = info.size * 2 / (height * 3);
            }
        }
        VideoFrame.Buffer frameBuffer = null;
        ByteBuffer buffer = null;
        try {
            buffer = this.codec.getOutputBuffers()[result];
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "getOutputBuffers failed", e);
        }
        buffer.position(info.offset);
        buffer.limit(info.offset + info.size);
        buffer = buffer.slice();
        frameBuffer = this.colorFormat == 19 ? this.copyI420Buffer(buffer, stride, sliceHeight, width, height) : (this.colorFormat == 54 ? this.copyP010ToIo10Buffer(buffer, stride, sliceHeight, width, height) : (this.isHisiCodec && this.colorFormat == 39 ? this.copyNV21ToI420Buffer(buffer, stride, sliceHeight, width, height) : this.copyNV12ToI420Buffer(buffer, stride, sliceHeight, width, height)));
        try {
            this.codec.releaseOutputBuffer(result, false);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverByteFrame failed", e);
        }
        catch (Exception e) {
            Logging.e(TAG, "deliverByteFrame error", e);
        }
        int decodecDelayFrames = this.decodeTimeStamps.size();
        TimeStamps timeStamps = this.decodeTimeStamps.poll();
        if (timeStamps == null) {
            Logging.e(TAG, "deliverByteFrame cannot find presentationTimeUs.");
            return;
        }
        int decodeTimeMs = (int)(SystemClock.elapsedRealtime() - timeStamps.prevElapsedRealtime);
        long presentationTimeNs = info.presentationTimeUs;
        if (presentationTimeNs == 0L) {
            presentationTimeNs = timeStamps.presentationTimeStampUs;
        }
        VideoFrame frame = new VideoFrame(frameBuffer, timeStamps.rotation, presentationTimeNs * 1000L);
        CodecSpecificInfo codecSpecificInfo = this.codecSpecificInfoMap.remove(presentationTimeNs);
        FrameExtraInfo frameExtraInfo = this.bframeExtraInfoMap.remove(presentationTimeNs);
        if (frameExtraInfo == null) {
            Logging.e(TAG, "HW frameExtraInfo empty. cannot find: " + presentationTimeNs);
            this.fallbackByCodecError = true;
            frame.release();
            return;
        }
        if (codecSpecificInfo == null) {
            Logging.e(TAG, "HW decodeTimeStamps empty. cannot find: " + presentationTimeNs);
        }
        if ((decodecDelayTimeMs = (int)(SystemClock.elapsedRealtime() - timeStamps.prevElapsedRealtime)) > this.maxDecodeTimeMs) {
            if (MediaCodecUtils.useHighLatencyStrategy() && this.deliveredCount >= 8) {
                this.highLatencyTrigger = true;
                this.deliveredCount = 0;
            }
            Logging.w(TAG, "Very high decode time: " + decodecDelayTimeMs + "ms.");
            decodecDelayTimeMs = this.maxDecodeTimeMs;
        }
        int supportCodecs = 0;
        if (this.supportCodecInfo != null) {
            supportCodecs = this.supportCodecInfo.getSupportCodecs();
        }
        if (this.running) {
            this.callback.onDecodedFrame(frame, decodeTimeMs, null, decodecDelayTimeMs, decodecDelayFrames, supportCodecs, codecSpecificInfo, frameExtraInfo);
        }
        frame.release();
        HardwareVideoDecoder.debug_log("frame delivered to native, pts_us: " + timeStamps.presentationTimeStampUs + "decode delay time: " + decodecDelayTimeMs + "ms, deliveredCount: " + this.deliveredCount + " decodecDelayFrames: " + decodecDelayFrames);
        ++this.deliveredCount;
    }

    private VideoFrame.Buffer copyNV21ToI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        return new NV21Buffer(width, height, stride, sliceHeight, buffer, null).toI420();
    }

    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        return new NV12Buffer(width, height, stride, sliceHeight, buffer, null).toI420();
    }

    private VideoFrame.Buffer copyP010ToIo10Buffer(ByteBuffer srcBuffer, int stride, int sliceHeight, int width, int height) {
        boolean startY = false;
        int startUV = stride * sliceHeight * 2;
        srcBuffer.position(0);
        ByteBuffer srcY = srcBuffer.slice();
        srcBuffer.position(startUV);
        ByteBuffer srcUV = srcBuffer.slice();
        JavaI010Buffer dstBuffer = JavaI010Buffer.allocate(width, height);
        YuvHelper.P010ToI010(srcY, stride, srcUV, stride, dstBuffer.getDataY(), dstBuffer.getStrideY(), dstBuffer.getDataU(), dstBuffer.getStrideU(), dstBuffer.getDataV(), dstBuffer.getStrideV(), width, height);
        return dstBuffer;
    }

    private VideoFrame.Buffer copyI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        if (stride % 2 != 0) {
            throw new AssertionError((Object)("Stride is not divisible by two: " + stride));
        }
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = sliceHeight % 2 == 0 ? (height + 1) / 2 : height / 2;
        int uvStride = stride / 2;
        boolean yPos = false;
        int yEnd = 0 + stride * height;
        int uPos = 0 + stride * sliceHeight;
        int uEnd = uPos + uvStride * chromaHeight;
        int vPos = uPos + uvStride * sliceHeight / 2;
        int vEnd = vPos + uvStride * chromaHeight;
        VideoFrame.I420Buffer frameBuffer = this.allocateI420Buffer(width, height);
        buffer.limit(yEnd);
        buffer.position(0);
        this.copyPlane(buffer.slice(), stride, frameBuffer.getDataY(), frameBuffer.getStrideY(), width, height);
        buffer.limit(uEnd);
        buffer.position(uPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataU(), frameBuffer.getStrideU(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(uPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataU = frameBuffer.getDataU();
            dataU.position(frameBuffer.getStrideU() * chromaHeight);
            dataU.put(buffer);
        }
        buffer.limit(vEnd);
        buffer.position(vPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataV(), frameBuffer.getStrideV(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(vPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataV = frameBuffer.getDataV();
            dataV.position(frameBuffer.getStrideV() * chromaHeight);
            dataV.put(buffer);
        }
        return frameBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformat(MediaFormat format) {
        int newHeight;
        int newWidth;
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.i(TAG, "Decoder format changed: " + format.toString());
        if (format.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && format.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
            newWidth = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) - format.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
            newHeight = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) - format.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
        } else {
            newWidth = format.getInteger("width");
            newHeight = format.getInteger("height");
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (this.hasDecodedFirstFrame && (this.width != newWidth || this.height != newHeight)) {
                Logging.w(TAG, "Configured size change, " + this.width + "*" + this.height + ". New " + newWidth + "*" + newHeight);
            }
            this.width = newWidth;
            this.height = newHeight;
        }
        if (this.surfaceTextureHelper == null && this.directSurface == null && format.containsKey("color-format")) {
            int color_format = format.getInteger("color-format");
            Logging.i(TAG, "reformat, Color: 0x" + Integer.toHexString(color_format));
            this.colorFormat = this.isHisiCodec && color_format == 47 && Build.VERSION.SDK_INT >= 21 ? 39 : color_format;
            if (!this.isSupportedColorFormat(this.colorFormat) && !MediaCodecUtils.isSupportedColorFormatHDR(this.colorFormat)) {
                this.stopOnOutputThread(new IllegalStateException("Unsupported color format: " + this.colorFormat));
                return;
            }
        }
        Object object2 = this.dimensionLock;
        synchronized (object2) {
            if (format.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = format.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (format.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                this.sliceHeight = format.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            Logging.i(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            this.stride = Math.max(this.width, this.stride);
            this.sliceHeight = Math.max(this.height, this.sliceHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.i(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media decoder stop failed", e);
        }
        try {
            this.codec.release();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media decoder release failed", e);
            this.shutdownException = e;
        }
        Object object = this.textureMetadataLock;
        synchronized (object) {
            this.dequeuedSurfaceOutputBuffers.clear();
        }
        Logging.i(TAG, "Release on output thread done");
    }

    private void stopOnOutputThread(Exception e) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = e;
    }

    private boolean isSupportedColorFormat(int colorFormat) {
        for (int supported : MediaCodecUtils.DECODER_COLOR_FORMATS) {
            if (supported != colorFormat) continue;
            return true;
        }
        return false;
    }

    private void maybeRenderDecodedTextureBuffer() {
        if (this.renderedTextureMetadata != null) {
            return;
        }
        if (!this.running) {
            Logging.i(TAG, "RenderTexture: Decoder is not running.");
            return;
        }
        DecodedTextureMetadata renderFrame = this.dequeuedSurfaceOutputBuffers.poll();
        if (renderFrame == null) {
            return;
        }
        if (this.surfaceTextureHelper != null) {
            try {
                this.surfaceTextureHelper.setTextureSize(renderFrame.width, renderFrame.height);
                this.surfaceTextureHelper.setFrameRotation(renderFrame.rotation);
            }
            catch (IllegalArgumentException ex) {
                Logging.e(TAG, "setTextureSize:", ex);
            }
        }
        this.renderedTextureMetadata = renderFrame;
        HardwareVideoDecoder.debug_log("render output buffer to surface, pts_us: " + renderFrame.presentationTimestampUs);
        try {
            this.codec.releaseOutputBuffer(renderFrame.outputBufferIndex, true);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverToDirectSurface failed", e);
        }
        catch (Exception e) {
            Logging.e(TAG, "deliverToDirectSurface error", e);
        }
    }

    @Nullable
    protected SurfaceTextureHelper createSurfaceTextureHelper() {
        return SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext, 16, ColorSpace.Transfer.SMPTEST2084.getTransfer());
    }

    protected void releaseSurface() {
        this.surface.release();
    }

    protected VideoFrame.I420Buffer allocateI420Buffer(int width, int height) {
        return JavaI420Buffer.allocate(width, height);
    }

    protected void copyPlane(ByteBuffer src, int srcStride, ByteBuffer dst, int dstStride, int width, int height) {
        YuvHelper.copyPlane(src, srcStride, dst, dstStride, width, height);
    }

    private static final void debug_log(String log) {
    }

    private static class DecodedTextureMetadata {
        final int outputBufferIndex;
        final int width;
        final int height;
        final int rotation;
        final long presentationTimestampUs;
        final Integer decodeTimeMs;
        final int delaySize;
        final long prevElapsedRealtime;
        private final long infoPresentationTimeUs;

        DecodedTextureMetadata(int outputBufferIndex, int width, int height, int rotation, long presentationTimestampUs, Integer decodeTimeMs, int delaySize, long elapsedRealtime, long infoPresentationTimeUs) {
            this.outputBufferIndex = outputBufferIndex;
            this.width = width;
            this.height = height;
            this.rotation = rotation;
            this.presentationTimestampUs = presentationTimestampUs;
            this.decodeTimeMs = decodeTimeMs;
            this.delaySize = delaySize;
            this.prevElapsedRealtime = elapsedRealtime;
            this.infoPresentationTimeUs = infoPresentationTimeUs;
        }
    }

    private static class TimeStamps {
        private final long prevElapsedRealtime;
        private final long presentationTimeStampUs;
        private final int rotation;

        public TimeStamps(long elapsedRealtime, long presentationTimeStampUs, int rotation) {
            this.prevElapsedRealtime = elapsedRealtime;
            this.presentationTimeStampUs = presentationTimeStampUs;
            this.rotation = rotation;
        }
    }
}

