/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import androidx.annotation.Nullable;
import io.agora.base.AlphaStitchMode;
import io.agora.base.ColorSpace;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.GlShader;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.HdrUtil;
import io.agora.base.internal.video.RendererCommon;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class GlGenericDrawer
implements RendererCommon.GlDrawer {
    private static final String TAG = GlGenericDrawer.class.getSimpleName();
    private static float[] g_color601_full = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.344136f, 1.772f, 1.402f, -0.714136f, 0.0f};
    private static float[] g_color601_limit = new float[]{1.164384f, 1.164384f, 1.164384f, 0.0f, -0.391762f, 2.017232f, 1.596027f, -0.812968f, 0.0f};
    private static float[] g_color709_full = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.187324f, 1.8556f, 1.5748f, -0.468124f, 0.0f};
    private static float[] g_color709_limit = new float[]{1.164384f, 1.164384f, 1.164384f, 0.0f, -0.213249f, 2.112402f, 1.792741f, -0.532909f, 0.0f};
    private static float[] g_color2020_full = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.164553f, 1.8814f, 1.4746f, -0.571353f, 0.0f};
    private static float[] g_color2020_limit = new float[]{1.167808f, 1.167808f, 1.167808f, 0.0f, -0.187877f, 2.148072f, 1.683611f, -0.652337f, 0.0f};
    private static final String INPUT_VERTEX_COORDINATE_NAME = "in_pos";
    private static final String INPUT_TEXTURE_COORDINATE_NAME = "in_tc";
    private static final String TEXTURE_MATRIX_NAME = "tex_mat";
    private static final String DEFAULT_VERTEX_SHADER_STRING = "precision mediump float;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nvarying vec2 tc;\nvoid main() {\n  gl_Position = in_pos;\n  tc = (tex_mat * in_tc).xy;\n}\n";
    private static final String ALPHA_VERTEX_SHADER_STRING = "varying vec2 tc;\nvarying vec2 channelCoordinates[4];\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nuniform float texelWidthOffset;\nvoid main() {\n  gl_Position = in_pos;\n  tc = (tex_mat * in_tc).xy;\n  vec2 singleStepOffset = vec2(texelWidthOffset, 0.0);\n  channelCoordinates[0] = tc - 1.5 * singleStepOffset;\n  channelCoordinates[1] = channelCoordinates[0] + singleStepOffset;\n  channelCoordinates[2] = channelCoordinates[1] + singleStepOffset;\n  channelCoordinates[3] = channelCoordinates[2] + singleStepOffset;\n}\n";
    private static final String INVERSE_HLG = "highp vec3 inverse_HLG(highp vec3 rgb) {\n  const highp float B67_a = 0.17883277;\n  const highp float B67_b = 0.28466892;\n  const highp float B67_c = 0.55991073;\n  if (rgb.x <= 0.5) rgb.x=(rgb.x * 2.0) * (rgb.x * 2.0);\n  else rgb.x = exp((rgb.x - B67_c) / B67_a) + B67_b;\n  if (rgb.y <= 0.5) rgb.y=(rgb.y * 2.0) * (rgb.y * 2.0);\n  else rgb.y = exp((rgb.y - B67_c) / B67_a) + B67_b;\n  if (rgb.z <= 0.5) rgb.z=(rgb.z * 2.0) * (rgb.z * 2.0);\n  else rgb.z = exp((rgb.z - B67_c) / B67_a) + B67_b;\n  return rgb;\n}\n";
    private static final String HLG_TO_LINEAR = "highp vec3 HLGToLinear(highp vec3 rgb) {\n  rgb = inverse_HLG(rgb);\n  highp vec3 ootf_2020 = vec3(0.2627, 0.6780, 0.0593);\n  highp float ootf_ys = 2000.0 * dot(ootf_2020, rgb);\n  return rgb *= pow(ootf_ys, 0.2);\n}\n";
    private static final String LINEAR_TO_PQ = "highp vec3 LinearToPQ(highp vec3 rgb, highp float divider) {\n  const highp float ST2084_m1 =  2610.0 / (4096.0 * 4.0);\n  const highp float ST2084_m2 = (2523.0 / 4096.0) * 128.0;\n  const highp float ST2084_c1 =  3424.0 / 4096.0;\n  const highp float ST2084_c2 = (2413.0 / 4096.0) * 32.0;\n  const highp float ST2084_c3 = (2392.0 / 4096.0) * 32.0;\n  rgb /= divider;\n  rgb = pow(rgb, vec3(ST2084_m1));\n  rgb = (ST2084_c1 + ST2084_c2 * rgb) / (1.0 + ST2084_c3 * rgb);\n  return rgb = pow(rgb, vec3(ST2084_m2));\n}\n";
    private static final String RGB2YUV_709 = "vec3 rgb2yuv_709(vec3 rgb) {\n  vec3 yuv;\n  yuv.x = 0.2126 * rgb.x + 0.7152 * rgb.y + 0.0722 * rgb.z;\n  yuv.y = -0.1146 * rgb.x - 0.3854 * rgb.y + 0.5 * rgb.z + 0.5;\n  yuv.z = 0.5 * rgb.x - 0.4542 * rgb.y - 0.0458 * rgb.z + 0.5;\n  return yuv;\n}\n";
    private static final String RGB2YUV_2020 = "vec3 rgb2yuv_2020(vec3 rgb) {\n  vec3 yuv;\n  yuv.x = 0.2627 * rgb.x + 0.678 * rgb.y + 0.0593 * rgb.z;\n  yuv.y = -0.1396 * rgb.x - 0.3604 * rgb.y + 0.5 * rgb.z + 0.5;\n  yuv.z = 0.5 * rgb.x - 0.4598 * rgb.y - 0.0402 * rgb.z + 0.5;\n  return yuv;\n}\n";
    private static final String SDR2HDR_VERTEX_SHADER_STRING = "precision mediump float;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nuniform float texBlurWidthOffset;\nuniform float texBlurHeightOffset;\nvarying vec2 tc;\nvarying vec2 texBlurShift_l1;\nvarying vec2 texBlurShift_l2;\nvarying vec2 texBlurShift_r1;\nvarying vec2 texBlurShift_r2;\nvarying vec2 texBlurShift_u1;\nvarying vec2 texBlurShift_u2;\nvarying vec2 texBlurShift_d1;\nvarying vec2 texBlurShift_d2;\nvoid main() {\n  gl_Position = in_pos;\n  vec2 attUV = (tex_mat * in_tc).xy;\n  tc = attUV;\n  texBlurShift_l1 = vec2(attUV.x, abs(attUV.y - texBlurHeightOffset * 11.0));\n  texBlurShift_l2 = vec2(attUV.x, abs(attUV.y - texBlurHeightOffset * 21.0));\n  texBlurShift_r1 = vec2(attUV.x, attUV.y + texBlurHeightOffset * 11.0);\n  texBlurShift_r2 = vec2(attUV.x, attUV.y + texBlurHeightOffset * 21.0);\n  texBlurShift_u1 = vec2(attUV.x + texBlurWidthOffset * 11.0, attUV.y);\n  texBlurShift_u2 = vec2(attUV.x + texBlurWidthOffset * 21.0, attUV.y);\n  texBlurShift_d1 = vec2(abs(attUV.x - texBlurWidthOffset * 11.0), attUV.y);\n  texBlurShift_d2 = vec2(abs(attUV.x - texBlurWidthOffset * 21.0), attUV.y);\n}\n";
    private static final String LUT_FUNCTION = "vec4 getLutRgb(vec3 yuv_in) {\nvec2 r_floor;\nvec2 r_ceil;\nvec3 Pos = yuv_in * 63.0;\nr_floor.y = floor(floor(Pos.x) * 0.125);\nr_floor.x = floor(Pos.x) - (r_floor.y * 8.0);\nfloat g_floor = floor(Pos.y);\nfloat b_floor = floor(Pos.z);\nr_ceil.y = floor(ceil(Pos.x) * 0.125);\nr_ceil.x = ceil(Pos.x) - (r_ceil.y * 8.0);\nfloat g_ceil = ceil(Pos.y);\nfloat b_ceil = ceil(Pos.z);\nfloat r_fract = fract(Pos.x);\nfloat g_fract = fract(Pos.y);\nfloat b_fract = fract(Pos.z);\nvec4 c000 = texture2D(lutTex, vec2((r_floor * 0.125) + 0.0009766 + (0.00195312 * vec2(g_floor, b_floor))));\nvec4 c001 = texture2D(lutTex, vec2((r_floor * 0.125) + 0.0009766 + (0.00195312 * vec2(g_ceil, b_floor))));\nvec4 c010 = texture2D(lutTex, vec2((r_floor * 0.125) + 0.0009766 + (0.00195312 * vec2(g_floor, b_ceil))));\nvec4 c011 = texture2D(lutTex, vec2((r_floor * 0.125) + 0.0009766 + (0.00195312 * vec2(g_ceil, b_ceil))));\nvec4 c100 = texture2D(lutTex, vec2((r_ceil * 0.125) + 0.0009766 + (0.00195312 * vec2(g_floor, b_floor))));\nvec4 c101 = texture2D(lutTex, vec2((r_ceil * 0.125) + 0.0009766 + (0.00195312 * vec2(g_ceil, b_floor))));\nvec4 c110 = texture2D(lutTex, vec2((r_ceil * 0.125) + 0.0009766 + (0.00195312 * vec2(g_floor, b_ceil))));\nvec4 c111 = texture2D(lutTex, vec2((r_ceil * 0.125) + 0.0009766 + (0.00195312 * vec2(g_ceil, b_ceil))));\nvec4 c00 = mix(c000, c100, r_fract);\nvec4 c01 = mix(c001, c101, r_fract);\nvec4 c10 = mix(c010, c110, r_fract);\nvec4 c11 = mix(c011, c111, r_fract);\nvec4 c0 = mix(c00, c10, b_fract);\nvec4 c1 = mix(c01, c11, b_fract);\nreturn mix(c0, c1, g_fract).bgra;\n}\n";
    private static final String LUT_FUNCTION_SIMPLE = "vec4 getLutRgb(vec3 yuv_in) {\nfloat yColor = yuv_in.r * 63.0;\nvec2 quad1;\nquad1.y = floor(floor(yColor) * 0.125);\nquad1.x = floor(yColor) - (quad1.y * 8.0);\nvec2 quad2;\nquad2.y = floor(ceil(yColor) * 0.125);\nquad2.x = ceil(yColor) - (quad2.y * 8.0);\nvec2 texPos1;\ntexPos1 = (quad1 * 0.125) + 0.0009766 + (0.123047 * yuv_in.gb);\nvec2 texPos2;\ntexPos2 = (quad2 * 0.125) + 0.0009766 + (0.123047 * yuv_in.gb);\nvec3 rgb1 = texture2D(lutTex, texPos1).rgb;\nvec3 rgb2 = texture2D(lutTex, texPos2).rgb;\nvec3 lutrgb = mix(rgb1, rgb2, fract(yColor));\nreturn vec4(lutrgb, 1.0);\n}\n";
    private static final String DEBANDING_FUNCTION = "float oetf_hlg(float x) \n{ \n  x = max(x, 0.0); \n  if (x <= (1.0/2.0)) \n{ \n    x = (x * x) * (1.0 / 3.0); \n} \n  else \n{ \n    x = (exp((x - 0.55991073) / 0.17883277) + 0.28466892) / 12.0; \n} \n  return x; \n} \nvec3 debanding() {\n  vec3 rgb_origin = sample(tc).rgb;\n  vec3 rgb_l1 = sample(texBlurShift_l1).rgb;\n  vec3 rgb_l2 = sample(texBlurShift_l2).rgb;\n  vec3 rgb_r1 = sample(texBlurShift_r1).rgb;\n  vec3 rgb_r2 = sample(texBlurShift_r2).rgb;\n  vec3 rgb_u1 = sample(texBlurShift_u1).rgb;\n  vec3 rgb_u2 = sample(texBlurShift_u2).rgb;\n  vec3 rgb_d1 = sample(texBlurShift_d1).rgb;\n  vec3 rgb_d2 = sample(texBlurShift_d2).rgb;\n  float y_origin = clamp(rgb_origin.r * 0.2627 + rgb_origin.g * 0.678 + rgb_origin.b * 0.0593, 0.0, 1.0); \n  float y_l1 = clamp(rgb_l1.r * 0.2627 + rgb_l1.g * 0.678 + rgb_l1.b * 0.0593, 0.0, 1.0); \n  float y_l2 = clamp(rgb_l2.r * 0.2627 + rgb_l2.g * 0.678 + rgb_l2.b * 0.0593, 0.0, 1.0); \n  float y_r1 = clamp(rgb_r1.r * 0.2627 + rgb_r1.g * 0.678 + rgb_r1.b * 0.0593, 0.0, 1.0); \n  float y_r2 = clamp(rgb_r2.r * 0.2627 + rgb_r2.g * 0.678 + rgb_r2.b * 0.0593, 0.0, 1.0); \n  float y_u1 = clamp(rgb_u1.r * 0.2627 + rgb_u1.g * 0.678 + rgb_u1.b * 0.0593, 0.0, 1.0); \n  float y_u2 = clamp(rgb_u2.r * 0.2627 + rgb_u2.g * 0.678 + rgb_u2.b * 0.0593, 0.0, 1.0); \n  float y_d1 = clamp(rgb_d1.r * 0.2627 + rgb_d1.g * 0.678 + rgb_d1.b * 0.0593, 0.0, 1.0); \n  float y_d2 = clamp(rgb_d2.r * 0.2627 + rgb_d2.g * 0.678 + rgb_d2.b * 0.0593, 0.0, 1.0); \n  float y_temp = y_origin - 1.0 / 255.0; \n  float y_delta = 2.0 * (oetf_hlg(y_origin) - oetf_hlg(y_temp)); \n  float diff_l1 = abs(y_origin - y_l1); \n  float diff_l2 = abs(y_origin - y_l2); \n  float diff_r1 = abs(y_origin - y_r1); \n  float diff_r2 = abs(y_origin - y_r2); \n  float diff_u1 = abs(y_origin - y_u1); \n  float diff_u2 = abs(y_origin - y_u2); \n  float diff_d1 = abs(y_origin - y_d1); \n  float diff_d2 = abs(y_origin - y_d2); \n  float is_less_than_delta = step(y_delta, max(max(max(max(max(max(max(diff_l1, diff_l2), diff_r1), diff_r2), diff_u1), diff_u2), diff_d1), diff_d2)); \n  highp vec3 sum = rgb_origin; \n  sum += rgb_l1; \n  sum += rgb_r1; \n  sum += rgb_u1; \n  sum += rgb_d1; \n  vec3 rgbOut = mix(rgb_origin, sum * 0.2, 1.0 - is_less_than_delta); \n  return rgbOut; \n}\n";
    static String alphaYuvGraphFragmentString = "precision mediump float;\nvarying vec2 tc;\nuniform mat3 colorMatrix;\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\nuniform int alphaStitchMode;\nuniform float colorRangeOffset;\n#define STITCH_MODE_UP   1\n#define STITCH_MODE_DOWN   2\n#define STITCH_MODE_LEFT   3\n#define STITCH_MODE_RIGHT   4\nhighp vec3 yuv,yuv_stitch,rgb;\nvec4 convertTexCoord(vec2 coord, int mode) {\n  if (mode == STITCH_MODE_UP) {\n    return vec4(coord.x, coord.y * 0.5 + 0.5, coord.x, coord.y * 0.5);\n  } else if (mode == STITCH_MODE_DOWN) {\n    return vec4(coord.x, coord.y * 0.5, coord.x, coord.y * 0.5 + 0.5);\n  } else if (mode == STITCH_MODE_LEFT) {\n    return vec4(coord.x * 0.5 + 0.5, coord.y, coord.x * 0.5, coord.y);\n  } else if (mode == STITCH_MODE_RIGHT) {\n    return vec4(coord.x * 0.5, coord.y, coord.x * 0.5 + 0.5, coord.y);\n  } else {\n    return vec4(coord.x, coord.y, coord.x, coord.y);\n  }\n}\nvec4 sample(vec2 p) {\n  vec4 coord = convertTexCoord(p, alphaStitchMode);\n  yuv[0] = clamp(texture2D(y_tex, coord.xy).r, 0.0, 1.0) - colorRangeOffset;\n  yuv[1] = clamp(texture2D(u_tex, coord.xy).r - 0.5, -0.5, 0.5);\n  yuv[2] = clamp(texture2D(v_tex, coord.xy).r - 0.5, -0.5, 0.5);\n  yuv_stitch[0] = clamp(texture2D(y_tex, coord.zw).r, 0.0, 1.0) - colorRangeOffset;\n  yuv_stitch[1] = clamp(texture2D(u_tex, coord.zw).r - 0.5, -0.5, 0.5);\n  yuv_stitch[2] = clamp(texture2D(v_tex, coord.zw).r - 0.5, -0.5, 0.5);\n  rgb = colorMatrix * yuv;\n  rgb = clamp(rgb, 0.0, 1.0);\n  float alpha = clamp(yuv_stitch[0], 0.0, 1.0);\n  return vec4(rgb, alpha);\n}\nvoid main() {\n  gl_FragColor = sample(tc);\n}\n";
    static String alphaRgbTextureGraphFragmentString = "precision mediump float;\nvarying vec2 tc;\nuniform sampler2D tex;\nuniform int alphaStitchMode;\nuniform int yuvMatrixMode;\n#define STITCH_MODE_UP   1\n#define STITCH_MODE_DOWN   2\n#define STITCH_MODE_LEFT   3\n#define STITCH_MODE_RIGHT   4\nvec4 convertTexCoord(vec2 coord, int mode) {\n  if (mode == STITCH_MODE_UP) {\n    return vec4(coord.x, coord.y * 0.5 + 0.5, coord.x, coord.y * 0.5);\n  } else if (mode == STITCH_MODE_DOWN) {\n    return vec4(coord.x, coord.y * 0.5, coord.x, coord.y * 0.5 + 0.5);\n  } else if (mode == STITCH_MODE_LEFT) {\n    return vec4(coord.x * 0.5 + 0.5, coord.y, coord.x * 0.5, coord.y);\n  } else if (mode == STITCH_MODE_RIGHT) {\n    return vec4(coord.x * 0.5, coord.y, coord.x * 0.5 + 0.5, coord.y);\n  } else {\n    return vec4(coord.x, coord.y, coord.x, coord.y);\n  }\n}\nvec4 sample(vec2 p) {\n  vec4 coord = convertTexCoord(p, alphaStitchMode);\n  vec3 rgb = clamp(texture2D(tex, coord.xy).rgb, 0.0, 1.0);\n  float y = 0.2126*rgb.r + 0.7152*rgb.g + 0.0722*rgb.b;\n  if (yuvMatrixMode==601)\n    y = 0.299*rgb.r + 0.587*rgb.g + 0.114*rgb.b;\n  float alpha = clamp(y, 0.0, 1.0);\n  return vec4(rgb, alpha);\n}\nvoid main() {\n  gl_FragColor = sample(tc);\n}";
    private static final FloatBuffer FULL_RECTANGLE_BUFFER = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEXTURE_BUFFER = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private final String genericFragmentSource;
    private String vertexShader;
    private final ShaderCallbacks shaderCallbacks;
    @Nullable
    private ShaderType currentShaderType;
    @Nullable
    private GlShader currentShader;
    private int inPosLocation;
    private int inTcLocation;
    private int texMatrixLocation;
    private FloatBuffer textureCropCoord;
    private int lutTextureId;
    private int texWOffsetLocation;
    private int texHOffsetLocation;

    static String createFragmentShaderString(String genericFragmentSource, ShaderType shaderType, ColorSpace colorSpace, boolean gammaCorrection, int transfer, boolean hasLutTexId) {
        StringBuilder stringBuilder = new StringBuilder();
        if (shaderType == ShaderType.ALPAH_YUV_STITCH_GRAPH) {
            stringBuilder.append(alphaYuvGraphFragmentString);
            return stringBuilder.toString();
        }
        if (shaderType == ShaderType.ALPAH_RGBA_STITCH_GRAPH) {
            stringBuilder.append(alphaRgbTextureGraphFragmentString);
            return stringBuilder.toString();
        }
        if (shaderType == ShaderType.OES || shaderType == ShaderType.OESA) {
            stringBuilder.append("#extension GL_OES_EGL_image_external : require\n");
        }
        stringBuilder.append("precision highp float;\n");
        stringBuilder.append("varying vec2 tc;\n");
        if (shaderType == ShaderType.ALPHA) {
            stringBuilder.append("varying vec2 channelCoordinates[4];\n");
            stringBuilder.append("uniform sampler2D tex;\n");
            stringBuilder.append("highp vec4 outData;\n");
            stringBuilder.append("vec4 sample(vec2 p) {\n");
            stringBuilder.append("  outData[0] = clamp(texture2D(tex, channelCoordinates[0]).a, 0.0, 1.0);\n");
            stringBuilder.append("  outData[1] = clamp(texture2D(tex, channelCoordinates[1]).a, 0.0, 1.0);\n");
            stringBuilder.append("  outData[2] = clamp(texture2D(tex, channelCoordinates[2]).a, 0.0, 1.0);\n");
            stringBuilder.append("  outData[3] = clamp(texture2D(tex, channelCoordinates[3]).a, 0.0, 1.0);\n");
            stringBuilder.append("  return outData;\n");
            stringBuilder.append("}\n");
            stringBuilder.append(genericFragmentSource);
            return stringBuilder.toString();
        }
        if (shaderType == ShaderType.YUV) {
            if (!HdrUtil.isNeedHdrSdrTrans(transfer)) {
                stringBuilder.append("uniform mat3 colorMatrix;\n");
            }
            stringBuilder.append("uniform sampler2D y_tex;\n");
            stringBuilder.append("uniform sampler2D u_tex;\n");
            stringBuilder.append("uniform sampler2D v_tex;\n");
            stringBuilder.append("uniform sampler2D a_tex;\n");
            stringBuilder.append("highp vec3 yuv,rgb;\n");
        } else if (shaderType == ShaderType.OESA || shaderType == ShaderType.RGBA) {
            String samplerName = shaderType == ShaderType.OESA ? "samplerExternalOES" : "sampler2D";
            stringBuilder.append("uniform ").append(samplerName).append(" tex;\n");
            stringBuilder.append("uniform sampler2D a_tex;\n");
            stringBuilder.append("highp vec4 outData;\n");
        } else {
            String samplerName = shaderType == ShaderType.OES ? "samplerExternalOES" : "sampler2D";
            stringBuilder.append("uniform ").append(samplerName).append(" tex;\n");
            stringBuilder.append("highp vec4 outData;\n");
        }
        if (HdrUtil.isNeedTransToSdrVision(transfer) && hasLutTexId) {
            stringBuilder.append("uniform highp sampler2D lutTex;\n");
            stringBuilder.append(LUT_FUNCTION);
            if (shaderType != ShaderType.YUV) {
                stringBuilder.append(RGB2YUV_2020);
            }
        } else if (HdrUtil.isNeedTransToHdrVision(transfer) && hasLutTexId) {
            stringBuilder.append("varying vec2 texBlurShift_l1;\n");
            stringBuilder.append("varying vec2 texBlurShift_l2;\n");
            stringBuilder.append("varying vec2 texBlurShift_r1;\n");
            stringBuilder.append("varying vec2 texBlurShift_r2;\n");
            stringBuilder.append("varying vec2 texBlurShift_u1;\n");
            stringBuilder.append("varying vec2 texBlurShift_u2;\n");
            stringBuilder.append("varying vec2 texBlurShift_d1;\n");
            stringBuilder.append("varying vec2 texBlurShift_d2;\n");
            stringBuilder.append("uniform highp sampler2D lutTex;\n");
            stringBuilder.append(LUT_FUNCTION);
            if (shaderType != ShaderType.YUV) {
                stringBuilder.append(RGB2YUV_709);
            }
        }
        if (shaderType == ShaderType.YUV) {
            if (HdrUtil.is10BitLumaDepth(transfer)) {
                if (transfer == ColorSpace.Transfer.ARIB_STD_B67.getTransfer()) {
                    stringBuilder.append(INVERSE_HLG);
                    stringBuilder.append(HLG_TO_LINEAR);
                    stringBuilder.append(LINEAR_TO_PQ);
                }
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("  vec2 y, u, v;\n");
                stringBuilder.append("  y = texture2D(y_tex, p).ra;\n");
                stringBuilder.append("  u = texture2D(u_tex, p).ra;\n");
                stringBuilder.append("  v = texture2D(v_tex, p).ra;\n");
                stringBuilder.append("  yuv.x = y.x * 0.249266862170088 + y.y * 63.81231671554252;\n");
                stringBuilder.append("  yuv.y = u.x * 0.249266862170088 + u.y * 63.81231671554252;\n");
                stringBuilder.append("  yuv.z = v.x * 0.249266862170088 + v.y * 63.81231671554252;\n");
                if (colorSpace == null || colorSpace.getRange() != ColorSpace.Range.Full) {
                    stringBuilder.append("  yuv.x = clamp((yuv.x - 0.062561) * 1.167808, 0.0, 1.0);\n");
                    stringBuilder.append("  yuv.yz = clamp((yuv.yz - 0.5) * 1.141741 + 0.5, 0.0, 1.0);\n");
                } else {
                    stringBuilder.append("  yuv = clamp(yuv, 0.0, 1.0);\n");
                }
                if (HdrUtil.isNeedTransToSdrVision(transfer) && hasLutTexId) {
                    stringBuilder.append("  rgb = getLutRgb(yuv).xyz;\n");
                } else {
                    stringBuilder.append("  yuv.yz = yuv.yz - 0.5;\n");
                    stringBuilder.append("  rgb = colorMatrix * yuv;\n");
                    if (transfer == ColorSpace.Transfer.ARIB_STD_B67.getTransfer()) {
                        stringBuilder.append("  rgb = HLGToLinear(rgb);\n");
                        stringBuilder.append("  rgb = LinearToPQ(rgb, 1000.0);\n");
                    }
                }
                stringBuilder.append("  return vec4(rgb, clamp(texture2D(a_tex, p).a, 0.0, 1.0));\n");
                stringBuilder.append("}\n");
                stringBuilder.append(genericFragmentSource);
            } else {
                if (HdrUtil.isNeedTransToHdrVision(transfer) && hasLutTexId) {
                    stringBuilder.append(INVERSE_HLG);
                    stringBuilder.append(HLG_TO_LINEAR);
                    stringBuilder.append(LINEAR_TO_PQ);
                }
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                if (colorSpace == null || colorSpace.getRange() != ColorSpace.Range.Full) {
                    if (HdrUtil.isNeedTransToHdrVision(transfer) && hasLutTexId) {
                        stringBuilder.append("  yuv[0] = clamp(1.164384 * (texture2D(y_tex, p).r - 0.0627), 0.0, 1.0);\n");
                    } else {
                        stringBuilder.append("  yuv[0] = clamp(texture2D(y_tex, p).r, 0.0, 1.0) - 0.0627;\n");
                    }
                } else {
                    stringBuilder.append("  yuv[0] = clamp(texture2D(y_tex, p).r, 0.0, 1.0);\n");
                }
                stringBuilder.append("  yuv[1] = clamp(texture2D(u_tex, p).r - 0.5, -0.5, 0.5);\n");
                stringBuilder.append("  yuv[2] = clamp(texture2D(v_tex, p).r - 0.5, -0.5, 0.5);\n");
                if (HdrUtil.isNeedTransToHdrVision(transfer) && hasLutTexId) {
                    stringBuilder.append("  yuv[1] = yuv[1] + 0.5;\n");
                    stringBuilder.append("  yuv[2] = yuv[2] + 0.5;\n");
                    stringBuilder.append("  rgb = getLutRgb(yuv).xyz;\n");
                    stringBuilder.append("  rgb = HLGToLinear(rgb);\n");
                    stringBuilder.append("  return vec4(LinearToPQ(rgb, 1000.0), 1.0);\n");
                    stringBuilder.append("}\n");
                    stringBuilder.append(DEBANDING_FUNCTION);
                    stringBuilder.append("void main() {\n");
                    stringBuilder.append("  gl_FragColor = vec4(debanding(),clamp(texture2D(a_tex, tc).a, 0.0, 1.0));\n");
                    stringBuilder.append("}\n");
                } else {
                    stringBuilder.append("  rgb = colorMatrix * yuv;\n");
                    stringBuilder.append("  return vec4(rgb, clamp(texture2D(a_tex, p).a, 0.0, 1.0));\n");
                    stringBuilder.append("}\n");
                    stringBuilder.append(genericFragmentSource);
                }
            }
        } else {
            if (transfer == ColorSpace.Transfer.ARIB_STD_B67.getTransfer() || HdrUtil.isNeedTransToHdrVision(transfer) && hasLutTexId) {
                stringBuilder.append(INVERSE_HLG);
                stringBuilder.append(HLG_TO_LINEAR);
                stringBuilder.append(LINEAR_TO_PQ);
            }
            if (HdrUtil.isNeedTransToSdrVision(transfer) && hasLutTexId) {
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("  vec3 rgb = texture2D(tex, p).rgb;\n");
                stringBuilder.append("  vec3 yuv = rgb2yuv_2020(rgb);\n");
                stringBuilder.append("  outData = getLutRgb(yuv);\n");
                if (shaderType == ShaderType.OESA || shaderType == ShaderType.RGBA) {
                    stringBuilder.append("  outData[3] = clamp(texture2D(a_tex, p).a, 0.0, 1.0);\n");
                }
                stringBuilder.append("  return outData;\n");
                stringBuilder.append("}\n");
                stringBuilder.append(genericFragmentSource);
            } else if (HdrUtil.isNeedTransToHdrVision(transfer) && hasLutTexId) {
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("  vec3 rgb = texture2D(tex, p).rgb;\n");
                stringBuilder.append("  vec3 yuv = rgb2yuv_709(rgb);\n");
                stringBuilder.append("  yuv = clamp(yuv, 0.0, 1.0);\n");
                stringBuilder.append("  return getLutRgb(yuv);\n");
                stringBuilder.append("}\n");
                stringBuilder.append(DEBANDING_FUNCTION);
                stringBuilder.append("void main() {\n");
                stringBuilder.append("vec3 rgbOut = debanding();\n");
                stringBuilder.append("rgbOut = HLGToLinear(rgbOut);\n");
                stringBuilder.append("rgbOut = LinearToPQ(rgbOut, 1000.0);\n");
                if (shaderType == ShaderType.OESA || shaderType == ShaderType.RGBA) {
                    stringBuilder.append("  gl_FragColor = vec4(rgbOut,clamp(texture2D(a_tex, p).a, 0.0, 1.0));\n");
                } else {
                    stringBuilder.append("  gl_FragColor = vec4(rgbOut, 1.0);\n");
                }
                stringBuilder.append("}\n");
            } else if (shaderType == ShaderType.OESA || shaderType == ShaderType.RGBA) {
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("  outData = texture2D(tex, p);\n");
                if (transfer == ColorSpace.Transfer.ARIB_STD_B67.getTransfer()) {
                    stringBuilder.append("  outData.xyz = HLGToLinear(outData.xyz);\n");
                    stringBuilder.append("  outData.xyz = LinearToPQ(outData.xyz, 1000.0);\n");
                }
                if (shaderType == ShaderType.OESA || shaderType == ShaderType.RGBA) {
                    stringBuilder.append("  outData[3] = clamp(texture2D(a_tex, p).a, 0.0, 1.0);\n");
                }
                stringBuilder.append("  return outData;\n");
                stringBuilder.append("}\n");
                stringBuilder.append(genericFragmentSource);
            } else if (gammaCorrection) {
                stringBuilder.append(genericFragmentSource.replace("gl_FragColor = sample(tc);", "float gamma = 2.2;\nvec4 fragColor = texture2D(tex, tc);\nfragColor.rgb = pow(fragColor.rgb, vec3(1.0/gamma));\ngl_FragColor = fragColor;"));
            } else {
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("  outData = texture2D(tex, p);\n");
                if (transfer == ColorSpace.Transfer.ARIB_STD_B67.getTransfer()) {
                    stringBuilder.append("  outData.xyz = HLGToLinear(outData.xyz);\n");
                    stringBuilder.append("  outData.xyz = LinearToPQ(outData.xyz, 1000.0);\n");
                }
                stringBuilder.append("  outData[3] = 1.0;\n");
                stringBuilder.append("  return outData;\n");
                stringBuilder.append("}\n");
                stringBuilder.append(genericFragmentSource);
            }
        }
        return stringBuilder.toString();
    }

    public GlGenericDrawer(String genericFragmentSource, ShaderCallbacks shaderCallbacks) {
        this(DEFAULT_VERTEX_SHADER_STRING, genericFragmentSource, shaderCallbacks);
    }

    public GlGenericDrawer(String vertexShader, String genericFragmentSource, ShaderCallbacks shaderCallbacks) {
        this.vertexShader = vertexShader;
        this.genericFragmentSource = genericFragmentSource;
        this.shaderCallbacks = shaderCallbacks;
    }

    public GlGenericDrawer(String vertexShader, String genericFragmentSource, FloatBuffer textureCropCoord, ShaderCallbacks shaderCallbacks) {
        this.vertexShader = vertexShader;
        this.genericFragmentSource = genericFragmentSource;
        this.textureCropCoord = textureCropCoord;
        this.shaderCallbacks = shaderCallbacks;
    }

    GlShader createShader(ShaderType shaderType, ColorSpace colorSpace, boolean gammaCorrection, int transfer, boolean hasLutTexId) {
        String shader = GlGenericDrawer.createFragmentShaderString(this.genericFragmentSource, shaderType, colorSpace, gammaCorrection, transfer, hasLutTexId);
        Logging.i(TAG, "shaderType: " + (Object)((Object)shaderType) + " transfer: " + transfer + " hasLutTexId: " + hasLutTexId + " shader: " + shader);
        return new GlShader(this.vertexShader, shader);
    }

    @Override
    public void drawOes(int oesTextureId, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int transfer) {
        this.drawOes(oesTextureId, alphaTexture, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, transfer, AlphaStitchMode.ALPHA_NO_STITCH.value());
    }

    @Override
    public void drawOes(int oesTextureId, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int transfer, int alphaStitchMode) {
        ShaderType chooseShaderType = alphaTexture > 0 ? ShaderType.OESA : ShaderType.OES;
        this.prepareShader(chooseShaderType, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, false, transfer, 0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)oesTextureId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)alphaTexture);
        }
        if (HdrUtil.isNeedHdrSdrTrans(transfer) && this.hasLutTexId()) {
            GLES20.glActiveTexture((int)33988);
            GLES20.glBindTexture((int)3553, (int)this.getLutTexId());
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)36197, (int)0);
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
        }
        if (HdrUtil.isNeedHdrSdrTrans(transfer) && this.hasLutTexId()) {
            GLES20.glActiveTexture((int)33988);
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void drawRgb(int textureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.drawRgb(textureId, 0, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, false, 0, AlphaStitchMode.ALPHA_NO_STITCH.value());
    }

    @Override
    public void drawRgb(int textureId, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int transfer) {
        this.drawRgb(textureId, alphaTexture, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, false, transfer, AlphaStitchMode.ALPHA_NO_STITCH.value());
    }

    @Override
    public void drawRgb(int textureId, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int transfer, int alphaStitchMode) {
        this.drawRgb(textureId, alphaTexture, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, false, transfer, alphaStitchMode);
    }

    @Override
    public void drawRgb(int textureId, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, boolean gammaCorrection, int transfer, int alphaStitchMode) {
        ShaderType chooseShaderType;
        ShaderType shaderType = chooseShaderType = alphaTexture > 0 ? ShaderType.RGBA : ShaderType.RGB;
        if (alphaStitchMode > 0) {
            chooseShaderType = ShaderType.ALPAH_RGBA_STITCH_GRAPH;
        }
        this.prepareShader(chooseShaderType, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, gammaCorrection, transfer, alphaStitchMode);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)alphaTexture);
        }
        if (HdrUtil.isNeedHdrSdrTrans(transfer) && this.hasLutTexId()) {
            GLES20.glActiveTexture((int)33988);
            GLES20.glBindTexture((int)3553, (int)this.getLutTexId());
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
        }
        if (HdrUtil.isNeedHdrSdrTrans(transfer) && this.hasLutTexId()) {
            GLES20.glActiveTexture((int)33988);
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void drawAlpha(int textureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(ShaderType.ALPHA, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, false, 0, 0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] yuvTextures, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int transfer) {
        this.drawYuv(yuvTextures, alphaTexture, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, null, transfer);
    }

    @Override
    public void drawYuv(int[] yuvTextures, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, ColorSpace colorSpace, int transfer) {
        int i;
        this.prepareShader(ShaderType.YUV, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, colorSpace, false, transfer, 0);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)yuvTextures[i]);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        }
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)alphaTexture);
        }
        if (HdrUtil.isNeedHdrSdrTrans(transfer) && this.hasLutTexId()) {
            GLES20.glActiveTexture((int)33988);
            GLES20.glBindTexture((int)3553, (int)this.getLutTexId());
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)0);
        }
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
        }
        if (HdrUtil.isNeedHdrSdrTrans(transfer) && this.hasLutTexId()) {
            GLES20.glActiveTexture((int)33988);
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void drawAlphaStitchGraph(int[] yuvTextures, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, ColorSpace colorSpace, int transfer, int alphaStitchMode) {
        int i;
        this.prepareShader(ShaderType.ALPAH_YUV_STITCH_GRAPH, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, colorSpace, false, transfer, alphaStitchMode);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)yuvTextures[i]);
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void setTextureCropCoord(FloatBuffer fb) {
        if (fb != null) {
            this.textureCropCoord = fb;
        }
    }

    @Override
    public void setLut10Texture(byte[] data) {
        Logging.i(TAG, "setLut10Texture()");
        Bitmap bitmap = null;
        try {
            if (data.length != 0) {
                bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (bitmap == null) {
            return;
        }
        this.lutTextureId = GlUtil.generateTexture(3553);
        GlUtil.checkNoGLES2Error("glGenTextures");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.lutTextureId);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        GlUtil.checkNoGLES2Error("loadImageTexture");
        GLES20.glBindTexture((int)3553, (int)0);
        bitmap.recycle();
    }

    private void prepareShader(ShaderType shaderType, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight, boolean gammaCorrection, int transfer, int alphaStitchMode) {
        this.prepareShader(shaderType, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, null, gammaCorrection, transfer, alphaStitchMode);
    }

    private void prepareShader(ShaderType shaderType, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight, ColorSpace colorSpace, boolean gammaCorrection, int transfer, int alphaStitchMode) {
        GlShader shader;
        if (shaderType.equals((Object)this.currentShaderType)) {
            shader = this.currentShader;
        } else {
            this.currentShaderType = shaderType;
            if (this.currentShader != null) {
                this.currentShader.release();
            }
            this.vertexShader = shaderType == ShaderType.ALPHA ? ALPHA_VERTEX_SHADER_STRING : (HdrUtil.isNeedTransToHdrVision(transfer) && this.hasLutTexId() ? SDR2HDR_VERTEX_SHADER_STRING : DEFAULT_VERTEX_SHADER_STRING);
            this.currentShader = shader = this.createShader(shaderType, colorSpace, gammaCorrection, transfer, this.hasLutTexId());
            shader.useProgram();
            if (shaderType == ShaderType.YUV || shaderType == ShaderType.ALPAH_YUV_STITCH_GRAPH) {
                FloatBuffer colorMat;
                GLES20.glUniform1i((int)shader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.getUniformLocation("v_tex"), (int)2);
                if (shaderType == ShaderType.YUV) {
                    GLES20.glUniform1i((int)shader.getUniformLocation("a_tex"), (int)3);
                }
                if (HdrUtil.isNeedHdrSdrTrans(transfer)) {
                    GLES20.glUniform1i((int)shader.getUniformLocation("lutTex"), (int)4);
                }
                if (colorSpace == null) {
                    colorMat = FloatBuffer.wrap(g_color601_limit);
                } else {
                    ColorSpace.Range range = colorSpace.getRange();
                    ColorSpace.Matrix matrix = colorSpace.getMatrix();
                    switch (matrix) {
                        case SMPTE170M: 
                        case BT470BG: {
                            colorMat = range == ColorSpace.Range.Full ? FloatBuffer.wrap(g_color601_full) : FloatBuffer.wrap(g_color601_limit);
                            break;
                        }
                        case BT709: {
                            colorMat = range == ColorSpace.Range.Full ? FloatBuffer.wrap(g_color709_full) : FloatBuffer.wrap(g_color709_limit);
                            break;
                        }
                        case BT2020_NCL: 
                        case BT2020_CL: {
                            colorMat = FloatBuffer.wrap(g_color2020_full);
                            break;
                        }
                        case Unspecified: {
                            colorMat = range == ColorSpace.Range.Full ? FloatBuffer.wrap(g_color601_full) : FloatBuffer.wrap(g_color601_limit);
                            break;
                        }
                        default: {
                            FloatBuffer floatBuffer = colorMat = range == ColorSpace.Range.Full ? FloatBuffer.wrap(g_color709_full) : FloatBuffer.wrap(g_color709_limit);
                        }
                    }
                }
                if (!HdrUtil.isNeedHdrSdrTrans(transfer)) {
                    GLES20.glUniformMatrix3fv((int)shader.getUniformLocation("colorMatrix"), (int)1, (boolean)false, (FloatBuffer)colorMat);
                }
                if (shaderType == ShaderType.ALPAH_YUV_STITCH_GRAPH) {
                    GLES20.glUniform1i((int)shader.getUniformLocation("alphaStitchMode"), (int)alphaStitchMode);
                    if (colorSpace == null || colorSpace.getRange() != ColorSpace.Range.Full) {
                        GLES20.glUniform1f((int)shader.getUniformLocation("colorRangeOffset"), (float)0.0627f);
                    } else {
                        GLES20.glUniform1f((int)shader.getUniformLocation("colorRangeOffset"), (float)0.0f);
                    }
                }
            } else if (shaderType == ShaderType.ALPHA) {
                GLES20.glUniform1i((int)shader.getUniformLocation("tex"), (int)0);
                GLES20.glUniform1f((int)shader.getUniformLocation("texelWidthOffset"), (float)(1.0f / (float)frameWidth));
            } else {
                if (shaderType == ShaderType.ALPAH_RGBA_STITCH_GRAPH || shaderType == ShaderType.ALPAH_OES_STITCH_GRAPH) {
                    GLES20.glUniform1i((int)shader.getUniformLocation("alphaStitchMode"), (int)alphaStitchMode);
                    int yuvMatrixMode = 601;
                    if (colorSpace != null && colorSpace.getMatrix() == ColorSpace.Matrix.BT709) {
                        yuvMatrixMode = 709;
                    }
                    GLES20.glUniform1i((int)shader.getUniformLocation("yuvMatrixMode"), (int)yuvMatrixMode);
                }
                GLES20.glUniform1i((int)shader.getUniformLocation("tex"), (int)0);
                if (shaderType == ShaderType.OESA || shaderType == ShaderType.RGBA) {
                    GLES20.glUniform1i((int)shader.getUniformLocation("a_tex"), (int)3);
                }
                if (HdrUtil.isNeedHdrSdrTrans(transfer) && this.hasLutTexId()) {
                    GLES20.glUniform1i((int)shader.getUniformLocation("lutTex"), (int)4);
                }
            }
            GlUtil.checkNoGLES2Error("Create shader");
            this.shaderCallbacks.onNewShader(shader);
            this.texMatrixLocation = shader.getUniformLocation(TEXTURE_MATRIX_NAME);
            this.inPosLocation = shader.getAttribLocation(INPUT_VERTEX_COORDINATE_NAME);
            this.inTcLocation = shader.getAttribLocation(INPUT_TEXTURE_COORDINATE_NAME);
            if (HdrUtil.isNeedTransToHdrVision(transfer) && this.hasLutTexId()) {
                this.texWOffsetLocation = shader.getUniformLocation("texBlurWidthOffset");
                this.texHOffsetLocation = shader.getUniformLocation("texBlurHeightOffset");
            }
        }
        shader.useProgram();
        GLES20.glEnableVertexAttribArray((int)this.inPosLocation);
        GLES20.glVertexAttribPointer((int)this.inPosLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_BUFFER);
        GLES20.glEnableVertexAttribArray((int)this.inTcLocation);
        if (this.textureCropCoord != null) {
            GLES20.glVertexAttribPointer((int)this.inTcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.textureCropCoord);
        } else {
            GLES20.glVertexAttribPointer((int)this.inTcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_TEXTURE_BUFFER);
        }
        GLES20.glUniformMatrix4fv((int)this.texMatrixLocation, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        if (HdrUtil.isNeedTransToHdrVision(transfer) && this.hasLutTexId()) {
            float texWOffset = 1.0f / (float)frameWidth;
            float texHOffset = 1.0f / (float)frameHeight;
            GLES20.glUniform1f((int)this.texWOffsetLocation, (float)texWOffset);
            GLES20.glUniform1f((int)this.texHOffsetLocation, (float)texHOffset);
        }
        this.shaderCallbacks.onPrepareShader(shader, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight);
        GlUtil.checkNoGLES2Error("Prepare shader");
    }

    public int getLutTexId() {
        return this.lutTextureId;
    }

    public boolean hasLutTexId() {
        return this.lutTextureId != 0;
    }

    @Override
    public void release() {
        if (this.currentShader != null) {
            this.currentShader.release();
            this.currentShader = null;
            this.currentShaderType = null;
        }
    }

    public static enum ShaderType {
        OES,
        RGB,
        YUV,
        ALPHA,
        OESA,
        RGBA,
        ALPAH_YUV_STITCH_GRAPH,
        ALPAH_OES_STITCH_GRAPH,
        ALPAH_RGBA_STITCH_GRAPH;

    }

    public static interface ShaderCallbacks {
        public void onNewShader(GlShader var1);

        public void onPrepareShader(GlShader var1, float[] var2, int var3, int var4, int var5, int var6);
    }
}

