/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.HardwareVideoEncoderFactory;
import io.agora.base.internal.video.SoftwareVideoEncoderFactory;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoEncoder;
import io.agora.base.internal.video.VideoEncoderFactory;
import io.agora.base.internal.video.VideoEncoderFallback;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class DefaultVideoEncoderFactory
implements VideoEncoderFactory {
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    private final VideoEncoderFactory softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();

    public DefaultVideoEncoderFactory(EglBase.Context eglContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this.hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory(eglContext, enableIntelVp8Encoder, enableH264HighProfile);
    }

    DefaultVideoEncoderFactory(VideoEncoderFactory hardwareVideoEncoderFactory) {
        this.hardwareVideoEncoderFactory = hardwareVideoEncoderFactory;
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info, boolean useTexture) {
        VideoEncoder softwareEncoder = this.softwareVideoEncoderFactory.createEncoder(info, useTexture);
        VideoEncoder hardwareEncoder = this.hardwareVideoEncoderFactory.createEncoder(info, useTexture);
        if (hardwareEncoder != null && softwareEncoder != null) {
            return new VideoEncoderFallback(softwareEncoder, hardwareEncoder);
        }
        return hardwareEncoder != null ? hardwareEncoder : softwareEncoder;
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info, boolean useTexture, boolean preferHWEncoder) {
        if (!preferHWEncoder) {
            return this.softwareVideoEncoderFactory.createEncoder(info, useTexture);
        }
        return this.createEncoder(info, useTexture);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs(boolean useTexture) {
        LinkedHashSet<VideoCodecInfo> supportedCodecInfos = new LinkedHashSet<VideoCodecInfo>();
        supportedCodecInfos.addAll(Arrays.asList(this.softwareVideoEncoderFactory.getSupportedCodecs(useTexture)));
        supportedCodecInfos.addAll(Arrays.asList(this.hardwareVideoEncoderFactory.getSupportedCodecs(useTexture)));
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }
}

