/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import androidx.annotation.Nullable;
import io.agora.base.JavaI010Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.RefCountDelegate;
import io.agora.base.internal.video.YuvHelper;
import java.nio.ByteBuffer;

public class JavaP010Buffer
implements VideoFrame.P010Buffer {
    private final int width;
    private final int height;
    private final int strideY;
    private final int strideUV;
    private final ByteBuffer dataY;
    private final ByteBuffer dataUV;
    private final RefCountDelegate refCountDelegate;
    private static final int BYTE_PER_CHANNEL = 2;

    public JavaP010Buffer(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataUV, int strideUV, @Nullable Runnable releaseCallback) {
        if (!dataY.isDirect()) {
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        this.width = width;
        this.height = height;
        this.strideY = strideY;
        this.strideUV = strideUV;
        this.dataY = dataY;
        this.dataUV = dataUV;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideUV() {
        return this.strideUV;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY;
    }

    @Override
    public ByteBuffer getDataUV() {
        return this.dataUV;
    }

    public static JavaP010Buffer allocate(int width, int height) {
        int srcStrideY = width;
        int srcHeightY = height;
        int srcSizeY = srcStrideY * srcHeightY * 2;
        ByteBuffer srcY = ByteBuffer.allocateDirect(srcSizeY);
        int srcStrideUV = width / 2;
        int srcHeightUV = height / 2;
        int srcSizeUV = srcStrideUV * srcHeightUV * 2 * 2;
        ByteBuffer srcUV = ByteBuffer.allocateDirect(srcSizeUV);
        return new JavaP010Buffer(width, height, srcY, width, srcUV, srcStrideUV, null);
    }

    private static void checkCapacity(ByteBuffer data, int height, int stride) {
        int minCapacity = stride * height * 2;
        if (data.capacity() < minCapacity) {
            throw new IllegalArgumentException("p010 Buffer must be at least " + minCapacity + " bytes, but was " + data.capacity() + "in p010");
        }
    }

    public static JavaP010Buffer wrap(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataUV, int strideUV, @Nullable Runnable releaseCallback) {
        if (dataY == null || dataUV == null) {
            throw new IllegalArgumentException("Data p010 buffers cannot be null.");
        }
        if (!dataY.isDirect() || !dataUV.isDirect()) {
            throw new IllegalArgumentException("Data p010 buffers must be direct byte buffers.");
        }
        int chromaHeight = (height + 1) / 2;
        dataY = dataY.slice();
        dataUV = dataUV.slice();
        JavaP010Buffer.checkCapacity(dataY, height, strideY);
        JavaP010Buffer.checkCapacity(dataUV, chromaHeight, strideUV * 2);
        return new JavaP010Buffer(width, height, dataY, strideY, dataUV, strideUV, releaseCallback);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return this.toI010().toI420();
    }

    @Override
    @Nullable
    public VideoFrame.I010Buffer toI010() {
        JavaI010Buffer dstBuffer = JavaI010Buffer.allocate(this.width, this.height);
        YuvHelper.P010ToI010(this.dataY, this.width, this.dataUV, this.width, dstBuffer.getDataY(), dstBuffer.getStrideY(), dstBuffer.getDataU(), dstBuffer.getStrideU(), dstBuffer.getDataV(), dstBuffer.getStrideV(), this.width, this.height);
        return dstBuffer;
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaP010Buffer newBuffer = JavaP010Buffer.allocate(scaleWidth, scaleHeight);
        YuvHelper.nativeP010CropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight, this.dataY, this.dataUV, this.width, this.height, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataUV(), newBuffer.getStrideUV());
        return newBuffer;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer mirror(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer rotate(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer transform(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int rotation) {
        return null;
    }
}

