/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.utils.internal;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import io.agora.rtm.base.internal.ThreadUtils;
import io.agora.rtm.internal.CalledByNative;
import io.agora.rtm.utils.internal.ConnectionChangeBroadcastReceiver;
import io.agora.rtm.utils.internal.Connectivity;
import io.agora.rtm.utils.internal.DeviceUtils;
import io.agora.rtm.utils.internal.Logging;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

@TargetApi(value=17)
public class CommonUtility {
    private static final String TAG = "CommonUtility";
    static final int UNKNOWN_BATTERY_PERCENTAGE = 255;
    private ConnectivityManager.NetworkCallback mobileNetworkCallback = null;
    private static String mLoadLibraryPath = null;
    private final WeakReference<Context> mContext;
    private final ThreadUtils.ThreadChecker mThreadChecker;
    private final Handler mHandler;
    private volatile int mBatteryPercentage = 255;
    private boolean mDisposed = false;
    private ConnectionChangeBroadcastReceiver mConnectionBroadcastReceiver = null;
    private static boolean ignoreMonitor = false;
    private static CommonUtility sInstance;
    private AtomicInteger reference = new AtomicInteger(0);
    private String lastLocalIp4;
    private String lastLocalIp6;
    private boolean shouldGetIp = true;
    private ArrayList<SystemEventListener> systemEventListeners = new ArrayList();
    private static Handler mProcessInfoHandler;
    static String nativeLibraryPrefix;
    static String nativeLibrarySurffix;

    public static void setIgnoreMonitor(boolean ignore) {
        ignoreMonitor = ignore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void registerSystemEventListener(SystemEventListener eventListener) {
        Log.d((String)TAG, (String)("registerSystemEventListener: " + eventListener.getClass().getName()));
        if (eventListener == null) {
            return;
        }
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            if (this.systemEventListeners.contains(eventListener)) {
                return;
            }
            this.systemEventListeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void unregisterSystemEventListener(SystemEventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            if (this.systemEventListeners.contains(eventListener)) {
                this.systemEventListeners.remove(eventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @CalledByNative
    public static CommonUtility getInstance(Context context) {
        if (sInstance == null) {
            Class<CommonUtility> clazz = CommonUtility.class;
            // MONITORENTER : io.agora.rtm.utils.internal.CommonUtility.class
            if (sInstance == null) {
                sInstance = new CommonUtility(context);
            }
            // MONITOREXIT : clazz
        }
        CommonUtility.sInstance.reference.getAndIncrement();
        return sInstance;
    }

    private CommonUtility(Context context) {
        Logging.d(TAG, "constructor()");
        this.mContext = new WeakReference<Context>(context);
        this.mThreadChecker = new ThreadUtils.ThreadChecker();
        HandlerThread handlerThread = new HandlerThread("RtmUtilityThread");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility.this.startMonitor();
            }
        });
    }

    private CommonUtility(Context context, long handle) {
        Logging.d(TAG, "constructor()");
        this.mContext = new WeakReference<Context>(context);
        this.mThreadChecker = new ThreadUtils.ThreadChecker();
        HandlerThread handlerThread = new HandlerThread("RtmUtilityThread");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility.this.startMonitor();
            }
        });
    }

    @CalledByNative
    public static Object getSystemService(Context context, String serviceName) {
        return context.getSystemService(serviceName);
    }

    void startMonitor() {
        Logging.d(TAG, "startMonitor()");
        if (ignoreMonitor) {
            Logging.e(TAG, "ignoreMonitor in simulator, just for ut");
            return;
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        try {
            this.mConnectionBroadcastReceiver = new ConnectionChangeBroadcastReceiver(this);
            context.registerReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create ConnectionChangeBroadcastReceiver, ", e);
        }
    }

    private void stopMonitor() {
        Logging.d(TAG, "stopMonitor()");
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        try {
            if (this.mobileNetworkCallback != null) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                connectivityManager.unregisterNetworkCallback(this.mobileNetworkCallback);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.mConnectionBroadcastReceiver != null) {
                context.unregisterReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver);
                this.mConnectionBroadcastReceiver = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void dispose() {
        if (sInstance == null || CommonUtility.sInstance.reference.decrementAndGet() > 0) {
            return;
        }
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        Logging.d(TAG, "dispose()");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility.this.stopMonitor();
            }
        });
        if (mProcessInfoHandler != null) {
            mProcessInfoHandler.post(new Runnable(){

                @Override
                public void run() {
                    mProcessInfoHandler.getLooper().quit();
                    mProcessInfoHandler = null;
                }
            });
        }
        final CountDownLatch waitingLatch = new CountDownLatch(1);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                waitingLatch.countDown();
                CommonUtility.this.mHandler.getLooper().quit();
            }
        });
        try {
            waitingLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object object = this;
        synchronized (object) {
            this.systemEventListeners.clear();
        }
        object = CommonUtility.class;
        synchronized (CommonUtility.class) {
            sInstance = null;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    @CalledByNative
    public int getNetworkType() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -1;
        }
        if (CommonUtility.checkAccessNetworkState(context)) {
            return Connectivity.getNetworkType(context);
        }
        Logging.w(TAG, "fail to getNetworkType, permission ACCESS_NETWORK_STATE not granted");
        return -1;
    }

    @CalledByNative
    public int getBatteryLifePercent() {
        return this.mBatteryPercentage;
    }

    @CalledByNative
    public MediaNetworkInfo getNetworkInfo() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return this.getNetworkInfo(context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNetworkChange() {
        if (this.mDisposed) {
            return;
        }
        this.shouldGetIp = true;
        Logging.d(TAG, "onNetworkChange()");
        MediaNetworkInfo info = this.getNetworkInfo((Context)this.mContext.get());
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            for (SystemEventListener eventListener : this.systemEventListeners) {
                Log.d((String)TAG, (String)("onNetworkChange: " + eventListener.getClass().getName()));
                eventListener.onNetworkChange(info);
            }
        }
    }

    @CalledByNative
    public static int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddressBound(String addr) {
        CommonUtility commonUtility = this;
        synchronized (commonUtility) {
            for (SystemEventListener eventListener : this.systemEventListeners) {
                eventListener.onAddressBound(addr);
            }
        }
    }

    @CalledByNative
    public void bindSocket2Network(int socketfd, String address) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        final ConnectivityManager connectivityManager = (ConnectivityManager)((Context)this.mContext.get()).getSystemService("connectivity");
        NetworkRequest requestForCellular = new NetworkRequest.Builder().addTransportType(0).build();
        final int socketFdInner = socketfd;
        final String addressInner = address.toString();
        final CommonUtility comm = this;
        if (this.mobileNetworkCallback != null) {
            connectivityManager.unregisterNetworkCallback(this.mobileNetworkCallback);
        }
        this.mobileNetworkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                LinkProperties prop = connectivityManager.getLinkProperties(network);
                if (prop == null || prop.getLinkAddresses().isEmpty()) {
                    Logging.e(CommonUtility.TAG, "onAvailable: prop is null or empty!");
                    return;
                }
                InetAddress addr = ((LinkAddress)prop.getLinkAddresses().get(0)).getAddress();
                String ip = CommonUtility.inetAddressToIpAddress(addr);
                if (ip != null && ip.equals(addressInner)) {
                    Logging.d(CommonUtility.TAG, "start bindSocket2Network");
                    Logging.d(CommonUtility.TAG, "addressInner" + addressInner);
                    FileDescriptor fileDescriptor = new FileDescriptor();
                    try {
                        Field field = FileDescriptor.class.getDeclaredField("descriptor");
                        field.setAccessible(true);
                        field.setInt(fileDescriptor, socketFdInner);
                        network.bindSocket(fileDescriptor);
                        comm.notifyAddressBound(addressInner);
                        Logging.d(CommonUtility.TAG, "bindSocket2Network success: network" + network + "+socketfd" + socketFdInner);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            connectivityManager.requestNetwork(requestForCellular, this.mobileNetworkCallback);
        }
        catch (Exception e) {
            this.mobileNetworkCallback = null;
            Logging.e(TAG, "requestNetwork failed " + e.toString());
        }
    }

    @CalledByNative
    public static AndroidContextInfo getContextInfo(Context context) {
        if (context == null) {
            Logging.w(TAG, "fail to getContextInfo, context null");
            return null;
        }
        AndroidContextInfo info = new AndroidContextInfo();
        info.device = DeviceUtils.getDeviceId();
        info.configDir = CommonUtility.getAppPrivateStorageDir(context);
        info.dataDir = context.getCacheDir().getAbsolutePath();
        info.pluginDir = context.getApplicationInfo().nativeLibraryDir;
        info.deviceInfo = DeviceUtils.getDeviceInfo();
        info.systemInfo = DeviceUtils.getSystemInfo();
        info.manufacturer = DeviceUtils.getManufacturer();
        info.pkgName = context.getPackageName();
        return info;
    }

    @CalledByNative
    public static String[] getLocalHostList() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<String> ips = new ArrayList<String>();
            for (NetworkInterface intf : interfaces) {
                String interfaceName = intf.getName();
                if (interfaceName.startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = CommonUtility.inetAddressToIpAddress(addr);
                    if (TextUtils.isEmpty((CharSequence)ip)) continue;
                    ips.add(ip + "+" + interfaceName);
                }
            }
            if (!ips.isEmpty()) {
                String[] addresses = new String[ips.size()];
                int i = 0;
                Iterator iterator = ips.iterator();
                while (iterator.hasNext()) {
                    String ip;
                    addresses[i] = ip = (String)iterator.next();
                    ++i;
                }
                return addresses;
            }
        }
        catch (Exception ex) {
            Logging.w(TAG, "fail to getLocalHostList", ex);
        }
        return null;
    }

    @CalledByNative
    public int VPNBehindAddress() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return 1;
        }
        return Connectivity.VPNBehindAddress(context);
    }

    @CalledByNative
    public static String getLocalHost(boolean is_ipv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            StringBuilder first_local_ip = new StringBuilder();
            String public_ip = null;
            for (NetworkInterface inter : interfaces) {
                if (inter.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addresses = Collections.list(inter.getInetAddresses());
                for (InetAddress addr : addresses) {
                    public_ip = CommonUtility.getIpAddressByType(addr, is_ipv4, first_local_ip);
                    if (TextUtils.isEmpty((CharSequence)public_ip)) continue;
                    return public_ip;
                }
            }
            if (first_local_ip.length() > 0) {
                return first_local_ip.toString();
            }
        }
        catch (Exception ex) {
            Logging.w(TAG, "fail to getLocalHost", ex);
        }
        return null;
    }

    private static String getIpAddressByType(InetAddress addr, boolean is_ipv4, StringBuilder first_local_ip) {
        if (is_ipv4 && addr instanceof Inet4Address) {
            String public_ip4 = CommonUtility.getPublicIpAddress(addr);
            if (!TextUtils.isEmpty((CharSequence)public_ip4) && first_local_ip.length() == 0) {
                first_local_ip.append(public_ip4);
            }
            return public_ip4;
        }
        if (!is_ipv4 && addr instanceof Inet6Address) {
            String public_ip6 = CommonUtility.getPublicIpAddress(addr);
            if (!TextUtils.isEmpty((CharSequence)public_ip6) && first_local_ip.length() == 0) {
                first_local_ip.append(public_ip6);
            }
            return public_ip6;
        }
        return null;
    }

    private static String getPublicIpAddress(InetAddress address) {
        if (!(address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isAnyLocalAddress())) {
            return address.getHostAddress();
        }
        return null;
    }

    static boolean checkAccessNetworkState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkPermission("android.permission.ACCESS_NETWORK_STATE", Process.myPid(), Process.myUid());
        return res == 0;
    }

    static boolean checkAccessWifiState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkPermission("android.permission.ACCESS_WIFI_STATE", Process.myPid(), Process.myUid());
        return res == 0;
    }

    private MediaNetworkInfo getNetworkInfo(Context context) {
        MediaNetworkInfo ni = new MediaNetworkInfo();
        if (!CommonUtility.checkAccessNetworkState(context)) {
            Logging.w(TAG, "fail to getNetworkInfo, permission ACCESS_NETWORK_STATE not granted");
            return ni;
        }
        if (this.shouldGetIp) {
            this.lastLocalIp4 = CommonUtility.getLocalHost(true);
            this.lastLocalIp6 = CommonUtility.getLocalHost(false);
            this.shouldGetIp = false;
        }
        if (!TextUtils.isEmpty((CharSequence)this.lastLocalIp4)) {
            ni.localIp4 = this.lastLocalIp4;
        }
        if (!TextUtils.isEmpty((CharSequence)this.lastLocalIp6)) {
            ni.localIp6 = this.lastLocalIp6;
        }
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        ni.networkType = Connectivity.getNetworkType(networkInfo);
        if (networkInfo != null) {
            ni.networkSubtype = networkInfo.getSubtype();
        }
        ni.dnsList = Connectivity.getDnsList();
        ni.ifconfigs = this.getVpnIfconfigs();
        return ni;
    }

    public ArrayList<String> getVpnIfconfigs() {
        ArrayList<String> ifconfigs = new ArrayList<String>();
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                String name = nif.getName();
                if (!name.contains("tun") && !name.contains("ppp") && !name.contains("ipsec") && !name.contains("tap")) continue;
                ifconfigs.add(name);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "Fail to get network interfaces array list. ", e);
        }
        return ifconfigs;
    }

    private static String inetAddressToIpAddress(InetAddress address) {
        if (!address.isLoopbackAddress()) {
            if (address instanceof Inet4Address) {
                Inet4Address address4 = (Inet4Address)address;
                return address4.getHostAddress();
            }
            if (address instanceof Inet6Address) {
                // empty if block
            }
        }
        return null;
    }

    private static InetAddress intToInetAddress(int hostAddress) {
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static String getAppPrivateStorageDir(Context context) {
        File file;
        if ("mounted".equals(Environment.getExternalStorageState()) && (file = context.getExternalFilesDir(null)) != null) {
            return file.getAbsolutePath();
        }
        return context.getFilesDir().getAbsolutePath();
    }

    @CalledByNative
    public static boolean isAppInForeground() {
        return true;
    }

    @CalledByNative
    public static int getCpuTemperature() {
        return DeviceUtils.getCpuTemperature();
    }

    @CalledByNative
    public static int setLoadLibraryPath(String path) {
        mLoadLibraryPath = path;
        return 0;
    }

    static String getNativeLibFullPath(String path, String name) {
        String fullName = nativeLibraryPrefix + name + nativeLibrarySurffix;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return fullName;
        }
        return path.endsWith(File.separator) ? path + fullName : path + File.separator + fullName;
    }

    @CalledByNative
    public static int safeLoadLibrary(String path) {
        Logging.w(TAG, "try load library " + path + " from " + mLoadLibraryPath);
        if (TextUtils.isEmpty((CharSequence)path)) {
            Logging.w(TAG, "load library " + path + " failed for empty");
            return -2;
        }
        int loaded = 0;
        try {
            if (TextUtils.isEmpty((CharSequence)mLoadLibraryPath)) {
                System.loadLibrary(path);
            } else {
                System.load(CommonUtility.getNativeLibFullPath(mLoadLibraryPath, path));
            }
        }
        catch (SecurityException e) {
            loaded = -1;
        }
        catch (UnsatisfiedLinkError e) {
            loaded = -1;
        }
        catch (NullPointerException e) {
            loaded = -1;
        }
        catch (Exception e) {
            loaded = -1;
        }
        Logging.w(TAG, "load library " + path + " " + (loaded == 0 ? "success" : "failed"));
        return loaded;
    }

    static {
        nativeLibraryPrefix = "lib";
        nativeLibrarySurffix = ".so";
    }

    public static class MediaNetworkInfo {
        String localIp4 = "";
        String gatewayIp4 = "";
        String localIp6 = "";
        String gatewayIp6 = "";
        int networkType = -1;
        int networkSubtype = -1;
        int signalLevel = 0;
        int rssi = 0;
        int snr = -100;
        ArrayList<String> dnsList = null;
        int linkspeed = 0;
        int frequency = 0;
        ArrayList<String> ifconfigs = null;

        @CalledByNative(value="MediaNetworkInfo")
        public String getLocalIp4() {
            return this.localIp4;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getGatewayIp4() {
            return this.gatewayIp4;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getLocalIp6() {
            return this.localIp6;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getGatewayIp6() {
            return this.gatewayIp6;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getNetworkType() {
            return this.networkType;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getNetworkSubtype() {
            return this.networkSubtype;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getSignalLevel() {
            return this.signalLevel;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getRssi() {
            return this.rssi;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getAsu() {
            return this.snr;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public ArrayList<String> getDnsList() {
            return this.dnsList;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getLinkspeed() {
            return this.linkspeed;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getFrequency() {
            return this.frequency;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public ArrayList<String> getVpnIfconfigs() {
            return this.ifconfigs;
        }
    }

    public static interface SystemEventListener {
        public void onAudioRoutingPhoneChanged(boolean var1, int var2, int var3);

        public void onNetworkChange(MediaNetworkInfo var1);

        public void onForegroundChanged(boolean var1);

        public void onGravityOriChange(int var1);

        public void onAddressBound(String var1);
    }

    public static class AndroidContextInfo {
        public String device;
        public String configDir;
        public String dataDir;
        public String pluginDir;
        public String deviceInfo;
        public String systemInfo;
        public String manufacturer;
        public String pkgName;

        @CalledByNative(value="AndroidContextInfo")
        public String getDevice() {
            return this.device;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getConfigDir() {
            return this.configDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getDataDir() {
            return this.dataDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getPluginDir() {
            return this.pluginDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getDeviceInfo() {
            return this.deviceInfo;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getSystemInfo() {
            return this.systemInfo;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getManufacturer() {
            return this.manufacturer;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getPkgName() {
            return this.pkgName;
        }
    }
}

