/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.rtm.ErrorInfo;
import io.agora.rtm.Metadata;
import io.agora.rtm.MetadataOptions;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmStorage;
import io.agora.rtm.internal.RequestInfo;
import io.agora.rtm.internal.RtmClientImpl;

class RtmStorageImpl
extends RtmStorage {
    private static final String TAG = RtmStorageImpl.class.getSimpleName();
    private long mNativeStorage = 0L;
    private final RtmClientImpl mRtmClient;

    RtmStorageImpl(long nativeHandle, RtmClientImpl rtmClient) {
        this.mNativeStorage = nativeHandle;
        this.mRtmClient = rtmClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setChannelMetadata(String channelName, RtmConstants.RtmChannelType channelType, Metadata data, MetadataOptions options, String lockName, ResultCallback<Void> resultCallback) {
        if (this.mNativeStorage == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "setChannelMetadata");
            return;
        }
        if (data == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.STORAGE_INVALID_METADATA_INSTANCE, "setChannelMetadata");
            return;
        }
        if (options == null) {
            options = new MetadataOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeSetChannelMetadata(this.mNativeStorage, channelName, RtmConstants.RtmChannelType.getValue(channelType), data, options, lockName, requestInfo);
            this.mRtmClient.mModifyMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateChannelMetadata(String channelName, RtmConstants.RtmChannelType channelType, Metadata data, MetadataOptions options, String lockName, ResultCallback<Void> resultCallback) {
        if (this.mNativeStorage == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "updateChannelMetadata");
            return;
        }
        if (data == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.STORAGE_INVALID_METADATA_INSTANCE, "updateChannelMetadata");
            return;
        }
        if (options == null) {
            options = new MetadataOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeUpdateChannelMetadata(this.mNativeStorage, channelName, RtmConstants.RtmChannelType.getValue(channelType), data, options, lockName, requestInfo);
            this.mRtmClient.mModifyMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeChannelMetadata(String channelName, RtmConstants.RtmChannelType channelType, Metadata data, MetadataOptions options, String lockName, ResultCallback<Void> resultCallback) {
        if (this.mNativeStorage == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "removeChannelMetadata");
            return;
        }
        if (data == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.STORAGE_INVALID_METADATA_INSTANCE, "removeChannelMetadata");
            return;
        }
        if (options == null) {
            options = new MetadataOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeRemoveChannelMetadata(this.mNativeStorage, channelName, RtmConstants.RtmChannelType.getValue(channelType), data, options, lockName, requestInfo);
            this.mRtmClient.mModifyMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getChannelMetadata(String channelName, RtmConstants.RtmChannelType channelType, ResultCallback<Metadata> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativeStorage == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "getChannelMetadata"));
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeGetChannelMetadata(this.mNativeStorage, channelName, RtmConstants.RtmChannelType.getValue(channelType), requestInfo);
            this.mRtmClient.mGetMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setUserMetadata(String userId, Metadata data, MetadataOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeStorage == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "setUserMetadata");
            return;
        }
        if (data == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.STORAGE_INVALID_METADATA_INSTANCE, "setUserMetadata");
            return;
        }
        if (options == null) {
            options = new MetadataOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeSetUserMetadata(this.mNativeStorage, userId, data, options, requestInfo);
            this.mRtmClient.mModifyMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateUserMetadata(String userId, Metadata data, MetadataOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeStorage == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "updateUserMetadata");
            return;
        }
        if (data == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.STORAGE_INVALID_METADATA_INSTANCE, "updateUserMetadata");
            return;
        }
        if (options == null) {
            options = new MetadataOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeUpdateUserMetadata(this.mNativeStorage, userId, data, options, requestInfo);
            this.mRtmClient.mModifyMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeUserMetadata(String userId, Metadata data, MetadataOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeStorage == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "removeUserMetadata");
            return;
        }
        if (data == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.STORAGE_INVALID_METADATA_INSTANCE, "removeUserMetadata");
            return;
        }
        if (options == null) {
            options = new MetadataOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeRemoveUserMetadata(this.mNativeStorage, userId, data, options, requestInfo);
            this.mRtmClient.mModifyMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getUserMetadata(String userId, ResultCallback<Metadata> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativeStorage == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "getUserMetadata"));
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeGetUserMetadata(this.mNativeStorage, userId, requestInfo);
            this.mRtmClient.mGetMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void subscribeUserMetadata(String userId, ResultCallback<Void> resultCallback) {
        if (this.mNativeStorage == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "subscribeUserMetadata");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeSubscribeUserMetadata(this.mNativeStorage, userId, requestInfo);
            this.mRtmClient.mSubUserMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unsubscribeUserMetadata(String userId, ResultCallback<Void> resultCallback) {
        if (this.mNativeStorage == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "unsubscribeUserMetadata");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeUnsubscribeUserMetadata(this.mNativeStorage, userId, requestInfo);
            this.mRtmClient.mUnsubUserMetadataCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private native void nativeSetChannelMetadata(long var1, String var3, int var4, Metadata var5, MetadataOptions var6, String var7, RequestInfo var8);

    private native void nativeUpdateChannelMetadata(long var1, String var3, int var4, Metadata var5, MetadataOptions var6, String var7, RequestInfo var8);

    private native void nativeRemoveChannelMetadata(long var1, String var3, int var4, Metadata var5, MetadataOptions var6, String var7, RequestInfo var8);

    private native void nativeGetChannelMetadata(long var1, String var3, int var4, RequestInfo var5);

    private native void nativeSetUserMetadata(long var1, String var3, Metadata var4, MetadataOptions var5, RequestInfo var6);

    private native void nativeUpdateUserMetadata(long var1, String var3, Metadata var4, MetadataOptions var5, RequestInfo var6);

    private native void nativeRemoveUserMetadata(long var1, String var3, Metadata var4, MetadataOptions var5, RequestInfo var6);

    private native void nativeGetUserMetadata(long var1, String var3, RequestInfo var4);

    private native void nativeSubscribeUserMetadata(long var1, String var3, RequestInfo var4);

    private native void nativeUnsubscribeUserMetadata(long var1, String var3, RequestInfo var4);
}

