/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.TopicInfo;
import io.agora.rtm.internal.CalledByNative;
import java.util.ArrayList;
import java.util.Arrays;

public class TopicEvent {
    private final RtmConstants.RtmTopicEventType type;
    private final String channelName;
    private final String publisher;
    private final ArrayList<TopicInfo> topicInfos;
    private final long timestamp;

    public RtmConstants.RtmTopicEventType getType() {
        return this.type;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public ArrayList<TopicInfo> getTopicInfos() {
        return this.topicInfos;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @CalledByNative
    public TopicEvent(String channelName, int type, String publisher, TopicInfo[] topicInfos, long timestamp) {
        this.type = RtmConstants.RtmTopicEventType.getEnum(type);
        this.channelName = channelName;
        this.publisher = publisher;
        this.topicInfos = new ArrayList<TopicInfo>(Arrays.asList(topicInfos));
        this.timestamp = timestamp;
    }

    public String toString() {
        return "TopicEvent {channelName: " + this.channelName + ", type: " + (Object)((Object)this.type) + ", publisher: " + this.publisher + ", topicInfos: " + this.topicInfos + ", timestamp: " + this.timestamp + "}";
    }
}

