/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmEncryptionConfig;
import io.agora.rtm.RtmEventListener;
import io.agora.rtm.RtmLogConfig;
import io.agora.rtm.RtmPrivateConfig;
import io.agora.rtm.RtmProxyConfig;
import io.agora.rtm.internal.CalledByNative;
import java.util.EnumSet;

public class RtmConfig {
    private final String appId;
    private final String userId;
    private final RtmEventListener eventListener;
    private final EnumSet<RtmConstants.RtmAreaCode> areaCode;
    private final RtmConstants.RtmProtocolType protocolType;
    private final int presenceTimeout;
    private final int heartbeatInterval;
    private final int reconnectTimeout;
    private final boolean useStringUserId;
    private final boolean multipath;
    private final boolean ispPolicyEnabled;
    private final RtmLogConfig logConfig;
    private final RtmProxyConfig proxyConfig;
    private final RtmEncryptionConfig encryptionConfig;
    private final RtmPrivateConfig privateConfig;

    private RtmConfig(Builder builder) {
        this.appId = builder.appId;
        this.userId = builder.userId;
        this.eventListener = builder.eventListener;
        this.areaCode = builder.areaCode;
        this.protocolType = builder.protocolType;
        this.presenceTimeout = builder.presenceTimeout;
        this.heartbeatInterval = builder.heartbeatInterval;
        this.reconnectTimeout = builder.reconnectTimeout;
        this.useStringUserId = builder.useStringUserId;
        this.multipath = builder.multipath;
        this.ispPolicyEnabled = builder.ispPolicyEnabled;
        this.logConfig = builder.logConfig;
        this.proxyConfig = builder.proxyConfig;
        this.encryptionConfig = builder.encryptionConfig;
        this.privateConfig = builder.privateConfig;
    }

    public RtmEventListener getEventListener() {
        return this.eventListener;
    }

    @CalledByNative
    public String getAppId() {
        return this.appId;
    }

    @CalledByNative
    public String getUserId() {
        return this.userId;
    }

    @CalledByNative
    public int getAreaCode() {
        int val = 0;
        for (RtmConstants.RtmAreaCode code : this.areaCode) {
            val |= RtmConstants.RtmAreaCode.getValue(code);
        }
        return val;
    }

    @CalledByNative
    public int getProtocolType() {
        return RtmConstants.RtmProtocolType.getValue(this.protocolType);
    }

    @CalledByNative
    public int getPresenceTimeout() {
        return this.presenceTimeout;
    }

    @CalledByNative
    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @CalledByNative
    public int getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    @CalledByNative
    public boolean isUseStringUserId() {
        return this.useStringUserId;
    }

    @CalledByNative
    public boolean isMultipath() {
        return this.multipath;
    }

    @CalledByNative
    public boolean isIspPolicyEnabled() {
        return this.ispPolicyEnabled;
    }

    @CalledByNative
    public RtmLogConfig getLogConfig() {
        return this.logConfig;
    }

    @CalledByNative
    public RtmProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @CalledByNative
    public RtmEncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    @CalledByNative
    public RtmPrivateConfig getPrivateConfig() {
        return this.privateConfig;
    }

    public String toString() {
        return "RtmConfig {appId: " + this.appId + ", userId: " + this.userId + ", areaCode: " + this.areaCode + ", protocolType" + (Object)((Object)this.protocolType) + ", presenceTimeout: " + this.presenceTimeout + ", heartbeatInterval: " + this.heartbeatInterval + ", reconnectTimeout: " + this.reconnectTimeout + ", useStringUserId: " + this.useStringUserId + ", multipath: " + this.multipath + ", ispPolicyEnabled: " + this.ispPolicyEnabled + ", logConfig: " + this.logConfig + ", proxyConfig: " + this.proxyConfig + ", encryptionConfig: " + this.encryptionConfig + ", privateConfig" + this.privateConfig + "}";
    }

    public static class Builder {
        private final String appId;
        private final String userId;
        private RtmEventListener eventListener;
        private EnumSet<RtmConstants.RtmAreaCode> areaCode = EnumSet.of(RtmConstants.RtmAreaCode.GLOB);
        private RtmConstants.RtmProtocolType protocolType = RtmConstants.RtmProtocolType.TCP_UDP;
        private int presenceTimeout = 300;
        private int heartbeatInterval = 5;
        private int reconnectTimeout = 0;
        private boolean useStringUserId = true;
        private boolean multipath = false;
        private boolean ispPolicyEnabled = false;
        private RtmLogConfig logConfig = new RtmLogConfig();
        private RtmProxyConfig proxyConfig = new RtmProxyConfig();
        private RtmEncryptionConfig encryptionConfig = new RtmEncryptionConfig();
        private RtmPrivateConfig privateConfig = new RtmPrivateConfig();

        public Builder(String appId, String userId) {
            this.appId = appId;
            this.userId = userId;
        }

        public Builder eventListener(RtmEventListener val) {
            this.eventListener = val;
            return this;
        }

        public Builder areaCode(EnumSet<RtmConstants.RtmAreaCode> val) {
            this.areaCode = val;
            return this;
        }

        public Builder protocolType(RtmConstants.RtmProtocolType val) {
            this.protocolType = val;
            return this;
        }

        public Builder presenceTimeout(int val) {
            this.presenceTimeout = val;
            return this;
        }

        public Builder heartbeatInterval(int val) {
            this.heartbeatInterval = val;
            return this;
        }

        public Builder reconnectTimeout(int val) {
            this.reconnectTimeout = val;
            return this;
        }

        public Builder useStringUserId(boolean val) {
            this.useStringUserId = val;
            return this;
        }

        public Builder multipath(boolean val) {
            this.multipath = val;
            return this;
        }

        public Builder ispPolicyEnabled(boolean val) {
            this.ispPolicyEnabled = val;
            return this;
        }

        public Builder logConfig(RtmLogConfig val) {
            this.logConfig = val;
            return this;
        }

        public Builder proxyConfig(RtmProxyConfig val) {
            this.proxyConfig = val;
            return this;
        }

        public Builder encryptionConfig(RtmEncryptionConfig val) {
            this.encryptionConfig = val;
            return this;
        }

        public Builder privateConfig(RtmPrivateConfig val) {
            this.privateConfig = val;
            return this;
        }

        public RtmConfig build() {
            return new RtmConfig(this);
        }
    }
}

