/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.rtm.ChannelInfo;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.GetMessagesResult;
import io.agora.rtm.GetOnlineUsersResult;
import io.agora.rtm.HistoryMessage;
import io.agora.rtm.LinkStateEvent;
import io.agora.rtm.LockDetail;
import io.agora.rtm.LockEvent;
import io.agora.rtm.MessageEvent;
import io.agora.rtm.Metadata;
import io.agora.rtm.PresenceEvent;
import io.agora.rtm.PublishOptions;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmClient;
import io.agora.rtm.RtmConfig;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmEventListener;
import io.agora.rtm.RtmHistory;
import io.agora.rtm.RtmLock;
import io.agora.rtm.RtmPresence;
import io.agora.rtm.RtmStorage;
import io.agora.rtm.StorageEvent;
import io.agora.rtm.StreamChannel;
import io.agora.rtm.SubscribeOptions;
import io.agora.rtm.SubscribeTopicResult;
import io.agora.rtm.TokenEvent;
import io.agora.rtm.TopicEvent;
import io.agora.rtm.UserState;
import io.agora.rtm.WhoNowResult;
import io.agora.rtm.base.internal.BuildConfig;
import io.agora.rtm.internal.IRtmEventHandler;
import io.agora.rtm.internal.RequestInfo;
import io.agora.rtm.internal.RtmHistoryImpl;
import io.agora.rtm.internal.RtmLockImpl;
import io.agora.rtm.internal.RtmPresenceImpl;
import io.agora.rtm.internal.RtmStorageImpl;
import io.agora.rtm.internal.StreamChannelImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArraySet;

public class RtmClientImpl
extends RtmClient {
    private static final String TAG = RtmClientImpl.class.getSimpleName();
    private static boolean sLibLoaded = false;
    static String nativeLibraryNameMixed = "agora-rtc-sdk";
    static String nativeLibraryNameIndependent = "agora-rtm-sdk";
    static String nativeLibraryPrefix = "lib";
    static String nativeLibrarySuffix = ".so";
    private long mNativeClient = 0L;
    private RtmStorageImpl mRtmStorage;
    private RtmLockImpl mRtmLock;
    private RtmPresenceImpl mRtmPresence;
    private RtmHistoryImpl mRtmHistory;
    private RtmEventHandler mRtmEventHandler;
    private final CopyOnWriteArraySet<StreamChannel> mChannels = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<RtmEventListener> mRtmEventListeners = new CopyOnWriteArraySet();
    public final byte[] mRtmCallbackLock = new byte[0];
    private final HashMap<Long, ResultCallback<Void>> mLoginCallback = new HashMap();
    private final HashMap<Long, ResultCallback<Void>> mLogoutCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mRenewTokenCallback = new HashMap();
    private final HashMap<Long, ResultCallback<Void>> mPublishCallback = new HashMap();
    private final HashMap<Long, ResultCallback<Void>> mSubscribeCallback = new HashMap();
    private final HashMap<Long, ResultCallback<Void>> mUnsubscribeCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mJoinCallback = new HashMap();
    public Deque<ResultCallback<Void>> mLeaveCallback = new LinkedList<ResultCallback<Void>>();
    public Deque<ResultCallback<Void>> mJoinTopicCallback = new LinkedList<ResultCallback<Void>>();
    public Deque<ResultCallback<Void>> mLeaveTopicCallback = new LinkedList<ResultCallback<Void>>();
    public Deque<ResultCallback<SubscribeTopicResult>> mSubTopicCallback = new LinkedList<ResultCallback<SubscribeTopicResult>>();
    public HashMap<Long, ResultCallback<Void>> mUnsubTopicCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mPubTopicMsgCallback = new HashMap();
    public HashMap<Long, ResultCallback<ArrayList<String>>> mGetSubUsersCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mModifyMetadataCallback = new HashMap();
    public HashMap<Long, ResultCallback<Metadata>> mGetMetadataCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mSubUserMetadataCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mUnsubUserMetadataCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mModifyLockCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mAcquireLockCallback = new HashMap();
    public HashMap<Long, ResultCallback<ArrayList<LockDetail>>> mGetLocksCallback = new HashMap();
    public HashMap<Long, ResultCallback<WhoNowResult>> mWhoNowCallback = new HashMap();
    public HashMap<Long, ResultCallback<ArrayList<ChannelInfo>>> mWhereNowCallback = new HashMap();
    public HashMap<Long, ResultCallback<GetOnlineUsersResult>> mGetOnlineUsersCallback = new HashMap();
    public HashMap<Long, ResultCallback<ArrayList<ChannelInfo>>> mGetUserChannelsCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mModifyStateCallback = new HashMap();
    public HashMap<Long, ResultCallback<UserState>> mGetStateCallback = new HashMap();
    public HashMap<Long, ResultCallback<GetMessagesResult>> mGetMessagesCallback = new HashMap();

    public static synchronized boolean initializeNativeLibs() {
        return RtmClientImpl.initializeNativeLibs(null);
    }

    public static synchronized boolean initializeNativeLibs(String libPath) {
        if (!sLibLoaded) {
            for (int i = 0; i < BuildConfig.so_list.size(); ++i) {
                sLibLoaded = RtmClientImpl.safeLoadLibrary(libPath, BuildConfig.so_list.get(i));
                if (sLibLoaded) continue;
                return sLibLoaded;
            }
            sLibLoaded = RtmClientImpl.safeLoadLibrary(libPath, nativeLibraryNameIndependent);
        }
        return sLibLoaded;
    }

    private static boolean safeLoadLibrary(String path, String name) {
        boolean loaded = true;
        try {
            if (path == null || path.length() == 0) {
                System.loadLibrary(name);
            } else {
                System.load(RtmClientImpl.getNativeLibFullPath(path, name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            loaded = false;
        }
        return loaded;
    }

    static String getNativeLibFullPath(String path, String name) {
        String fullName = nativeLibraryPrefix + name + nativeLibrarySuffix;
        if (path == null || path.length() == 0) {
            return fullName;
        }
        return path.endsWith(File.separator) ? path + fullName : path + File.separator + fullName;
    }

    public void addChannel(StreamChannel channel) {
        if (channel != null) {
            this.mChannels.add(channel);
        }
    }

    public void removeChannel(StreamChannel channel) {
        if (channel != null) {
            this.mChannels.remove(channel);
        }
    }

    @Override
    protected synchronized RtmConstants.RtmErrorCode initialize(RtmConfig config) {
        if (config == null) {
            throw new NullPointerException("eventListener is null");
        }
        if (this.mNativeClient != 0L) {
            return RtmConstants.RtmErrorCode.OK;
        }
        this.mNativeClient = this.nativeObjectInit();
        if (this.mNativeClient == 0L) {
            throw new IllegalArgumentException("create native rtm client failed");
        }
        if (config.getEventListener() != null) {
            this.mRtmEventListeners.add(config.getEventListener());
        }
        this.mRtmEventHandler = new RtmEventHandler();
        int ret = this.nativeCreateRtmClient(this.mNativeClient, config, this.mRtmEventHandler);
        return RtmConstants.RtmErrorCode.getEnum(ret);
    }

    @Override
    protected synchronized RtmConstants.RtmErrorCode releaseClient() {
        if (this.mNativeClient != 0L) {
            for (StreamChannel channel : this.mChannels) {
                if (channel == null) continue;
                channel.release();
            }
            RtmClientImpl.nativeDestroy(this.mNativeClient);
            this.mNativeClient = 0L;
        }
        this.mChannels.clear();
        return RtmConstants.RtmErrorCode.OK;
    }

    @Override
    public synchronized void addEventListener(RtmEventListener listener) {
        if (listener == null) {
            return;
        }
        this.mRtmEventListeners.add(listener);
    }

    @Override
    public synchronized void removeEventListener(RtmEventListener listener) {
        if (listener == null) {
            return;
        }
        this.mRtmEventListeners.remove(listener);
    }

    @Override
    public synchronized RtmStorage getStorage() {
        if (this.mNativeClient == 0L) {
            return null;
        }
        if (this.mRtmStorage == null) {
            long handle = this.nativeGetStorage(this.mNativeClient);
            if (handle == 0L) {
                return null;
            }
            this.mRtmStorage = new RtmStorageImpl(handle, this);
        }
        return this.mRtmStorage;
    }

    @Override
    public synchronized RtmLock getLock() {
        if (this.mNativeClient == 0L) {
            return null;
        }
        if (this.mRtmLock == null) {
            long handle = this.nativeGetLock(this.mNativeClient);
            if (handle == 0L) {
                return null;
            }
            this.mRtmLock = new RtmLockImpl(handle, this);
        }
        return this.mRtmLock;
    }

    @Override
    public synchronized RtmPresence getPresence() {
        if (this.mNativeClient == 0L) {
            return null;
        }
        if (this.mRtmPresence == null) {
            long handle = this.nativeGetPresence(this.mNativeClient);
            if (handle == 0L) {
                return null;
            }
            this.mRtmPresence = new RtmPresenceImpl(handle, this);
        }
        return this.mRtmPresence;
    }

    @Override
    public synchronized RtmHistory getHistory() {
        if (this.mNativeClient == 0L) {
            return null;
        }
        if (this.mRtmHistory == null) {
            long handle = this.nativeGetHistory(this.mNativeClient);
            if (handle == 0L) {
                return null;
            }
            this.mRtmHistory = new RtmHistoryImpl(handle, this);
        }
        return this.mRtmHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void login(String token, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "login");
            return;
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeLogin(this.mNativeClient, token, requestInfo);
            this.mLoginCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void logout(ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "logout");
            return;
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeLogout(this.mNativeClient, requestInfo);
            this.mLogoutCallback.put(requestInfo.requestId, resultCallback);
            this.mChannels.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void renewToken(String token, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "renewToken");
            return;
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeRenewToken(this.mNativeClient, token, requestInfo);
            this.mRenewTokenCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publish(String channelName, String message, PublishOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "publish");
            return;
        }
        if (options == null) {
            options = new PublishOptions();
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativePublishStringMessage(this.mNativeClient, channelName, message, options, requestInfo);
            this.mPublishCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publish(String channelName, byte[] message, PublishOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "publish");
            return;
        }
        if (options == null) {
            options = new PublishOptions();
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativePublishBinaryMessage(this.mNativeClient, channelName, message, options, requestInfo);
            this.mPublishCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void subscribe(String channelName, SubscribeOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "subscribe");
            return;
        }
        if (options == null) {
            options = new SubscribeOptions();
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeSubscribe(this.mNativeClient, channelName, options, requestInfo);
            this.mSubscribeCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unsubscribe(String channelName, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "unsubscribe");
            return;
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeUnsubscribe(this.mNativeClient, channelName, requestInfo);
            this.mUnsubscribeCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized RtmConstants.RtmErrorCode setParameters(String parameters) {
        if (this.mNativeClient == 0L) {
            return RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED;
        }
        int ret = this.nativeSetParameters(this.mNativeClient, parameters);
        return RtmConstants.RtmErrorCode.getEnum(ret);
    }

    @Override
    public synchronized StreamChannel createStreamChannel(String channelName) {
        if (this.mNativeClient == 0L) {
            throw new NullPointerException("native client is null");
        }
        for (StreamChannel channel : this.mChannels) {
            if (channel == null || !channel.getChannelName().equals(channelName)) continue;
            return channel;
        }
        int[] errorCode = new int[1];
        long handle = this.nativeCreateStreamChannel(this.mNativeClient, channelName, errorCode);
        if (handle == 0L || errorCode[0] != 0) {
            throw new IllegalArgumentException(this.getErrorReason(errorCode[0]));
        }
        StreamChannelImpl channel = new StreamChannelImpl(handle);
        this.mChannels.add(channel);
        channel.attach(this);
        return channel;
    }

    @Override
    public String getErrorReason(RtmConstants.RtmErrorCode errorCode) {
        return this.getErrorReason(RtmConstants.RtmErrorCode.getValue(errorCode));
    }

    public String getErrorReason(int errorCode) {
        if (this.mNativeClient == 0L) {
            return "";
        }
        return this.nativeGetErrorReason(this.mNativeClient, errorCode);
    }

    public void processCallback(int code, ResultCallback<Void> callback, String methodName) {
        if (callback == null) {
            return;
        }
        RtmConstants.RtmErrorCode errorCode = RtmConstants.RtmErrorCode.getEnum(code);
        if (errorCode == RtmConstants.RtmErrorCode.OK) {
            callback.onSuccess(null);
        } else {
            callback.onFailure(new ErrorInfo(errorCode, this.getErrorReason(errorCode), methodName));
        }
    }

    public void processFailureCallback(ResultCallback<Void> callback, RtmConstants.RtmErrorCode errorCode, String methodName) {
        if (callback == null) {
            return;
        }
        callback.onFailure(new ErrorInfo(errorCode, this.getErrorReason(errorCode), methodName));
    }

    public static native String nativeGetVersion();

    private native long nativeObjectInit();

    private static native int nativeDestroy(long var0);

    private native int nativeCreateRtmClient(long var1, RtmConfig var3, Object var4);

    private native long nativeCreateStreamChannel(long var1, String var3, int[] var4);

    private native long nativeGetStorage(long var1);

    private native long nativeGetLock(long var1);

    private native long nativeGetPresence(long var1);

    private native long nativeGetHistory(long var1);

    private native void nativeLogin(long var1, String var3, RequestInfo var4);

    private native void nativeLogout(long var1, RequestInfo var3);

    private native void nativeRenewToken(long var1, String var3, RequestInfo var4);

    private native void nativePublishStringMessage(long var1, String var3, String var4, PublishOptions var5, RequestInfo var6);

    private native void nativePublishBinaryMessage(long var1, String var3, byte[] var4, PublishOptions var5, RequestInfo var6);

    private native void nativeSubscribe(long var1, String var3, SubscribeOptions var4, RequestInfo var5);

    private native void nativeUnsubscribe(long var1, String var3, RequestInfo var4);

    private native int nativeSetParameters(long var1, String var3);

    private native String nativeGetErrorReason(long var1, int var3);

    private class RtmEventHandler
    implements IRtmEventHandler {
        private RtmEventHandler() {
        }

        @Override
        public void onLinkStateEvent(LinkStateEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onLinkStateEvent(event);
            }
        }

        @Override
        public void onMessageEvent(MessageEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onMessageEvent(event);
            }
        }

        @Override
        public void onPresenceEvent(PresenceEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onPresenceEvent(event);
            }
        }

        @Override
        public void onTopicEvent(TopicEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onTopicEvent(event);
            }
        }

        @Override
        public void onLockEvent(LockEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onLockEvent(event);
            }
        }

        @Override
        public void onStorageEvent(StorageEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onStorageEvent(event);
            }
        }

        @Override
        public void onTokenEvent(TokenEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onTokenEvent(event);
            }
        }

        @Override
        public void onConnectionStateChanged(String channelName, int state, int reason) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onConnectionStateChanged(channelName, RtmConstants.RtmConnectionState.getEnum(state), RtmConstants.RtmConnectionChangeReason.getEnum(reason));
            }
        }

        @Override
        public void onTokenPrivilegeWillExpire(String channelName) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onTokenPrivilegeWillExpire(channelName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJoinResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mJoinCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "join");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mLeaveCallback.pollFirst();
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "leave");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJoinTopicResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mJoinTopicCallback.pollFirst();
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "joinTopic");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveTopicResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mLeaveTopicCallback.pollFirst();
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "leaveTopic");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribeTopicResult(long requestId, String[] succeedUsers, String[] failedUsers, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<SubscribeTopicResult> callback = RtmClientImpl.this.mSubTopicCallback.pollFirst();
                // ** MonitorExit[var7_5] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    SubscribeTopicResult res = new SubscribeTopicResult(new ArrayList<String>(Arrays.asList(succeedUsers)), new ArrayList<String>(Arrays.asList(failedUsers)));
                    callback.onSuccess(res);
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "subscribeTopic"));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnsubscribeTopicResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mUnsubTopicCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "unsubscribeTopic");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPublishTopicMessageResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mPubTopicMsgCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "publishTopicMessage");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetSubscribedUserListResult(long requestId, String[] users, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<ArrayList<String>> callback = RtmClientImpl.this.mGetSubUsersCallback.remove(requestId);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    callback.onSuccess(new ArrayList<String>(Arrays.asList(users)));
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getSubscribedUserList"));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribeResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback callback = (ResultCallback)RtmClientImpl.this.mSubscribeCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "subscribe");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnsubscribeResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback callback = (ResultCallback)RtmClientImpl.this.mUnsubscribeCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "unsubscribe");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPublishResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback callback = (ResultCallback)RtmClientImpl.this.mPublishCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "publish");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoginResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback callback = (ResultCallback)RtmClientImpl.this.mLoginCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "login");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLogoutResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback callback = (ResultCallback)RtmClientImpl.this.mLogoutCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "logout");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRenewTokenResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mRenewTokenCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "renewToken");
                return;
            }
        }

        @Override
        public void onSetChannelMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "setChannelMetadata");
        }

        @Override
        public void onUpdateChannelMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "updateChannelMetadata");
        }

        @Override
        public void onRemoveChannelMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "removeChannelMetadata");
        }

        @Override
        public void onGetChannelMetadataResult(long requestId, Metadata data, int errorCode) {
            this.onGetMetadataResult(requestId, data, errorCode, "getChannelMetadata");
        }

        @Override
        public void onSetUserMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "setUserMetadata");
        }

        @Override
        public void onUpdateUserMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "updateUserMetadata");
        }

        @Override
        public void onRemoveUserMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "removeUserMetadata");
        }

        @Override
        public void onGetUserMetadataResult(long requestId, Metadata data, int errorCode) {
            this.onGetMetadataResult(requestId, data, errorCode, "getUserMetadata");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribeUserMetadataResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mSubUserMetadataCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "subscribeUserMetadata");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnsubscribeUserMetadataResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mUnsubUserMetadataCallback.remove(requestId);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                this.processCallback(callback, errorCode, "unsubscribeUserMetadata");
                return;
            }
        }

        @Override
        public void onSetLockResult(long requestId, int errorCode) {
            this.onModifyLockResult(requestId, errorCode, "setLock");
        }

        @Override
        public void onRemoveLockResult(long requestId, int errorCode) {
            this.onModifyLockResult(requestId, errorCode, "removeLock");
        }

        @Override
        public void onReleaseLockResult(long requestId, int errorCode) {
            this.onModifyLockResult(requestId, errorCode, "releaseLock");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAcquireLockResult(long requestId, String errorDetails, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mAcquireLockCallback.remove(requestId);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "acquireLock"));
                }
                return;
            }
        }

        @Override
        public void onRevokeLockResult(long requestId, int errorCode) {
            this.onModifyLockResult(requestId, errorCode, "revokeLock");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetLocksResult(long requestId, LockDetail[] lockDetailList, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<ArrayList<LockDetail>> callback = RtmClientImpl.this.mGetLocksCallback.remove(requestId);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    callback.onSuccess(new ArrayList<LockDetail>(Arrays.asList(lockDetailList)));
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getLocks"));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhoNowResult(long requestId, UserState[] userStateList, long userCount, String nextPage, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<WhoNowResult> callback = RtmClientImpl.this.mWhoNowCallback.remove(requestId);
                // ** MonitorExit[var9_6] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    WhoNowResult res = new WhoNowResult(nextPage, new ArrayList<UserState>(Arrays.asList(userStateList)), (int)userCount);
                    callback.onSuccess(res);
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "whoNow"));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhereNowResult(long requestId, ChannelInfo[] channels, long channelCount, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<ArrayList<ChannelInfo>> callback = RtmClientImpl.this.mWhereNowCallback.remove(requestId);
                // ** MonitorExit[var8_5] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    callback.onSuccess(new ArrayList<ChannelInfo>(Arrays.asList(channels)));
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "whereNow"));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetOnlineUsersResult(long requestId, UserState[] userStateList, long userCount, String nextPage, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<GetOnlineUsersResult> callback = RtmClientImpl.this.mGetOnlineUsersCallback.remove(requestId);
                // ** MonitorExit[var9_6] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    GetOnlineUsersResult res = new GetOnlineUsersResult(nextPage, new ArrayList<UserState>(Arrays.asList(userStateList)), (int)userCount);
                    callback.onSuccess(res);
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getOnlineUsers"));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetUserChannelsResult(long requestId, ChannelInfo[] channels, long channelCount, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<ArrayList<ChannelInfo>> callback = RtmClientImpl.this.mGetUserChannelsCallback.remove(requestId);
                // ** MonitorExit[var8_5] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    callback.onSuccess(new ArrayList<ChannelInfo>(Arrays.asList(channels)));
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getUserChannels"));
                }
                return;
            }
        }

        @Override
        public void onPresenceSetStateResult(long requestId, int errorCode) {
            this.onModifyStateResult(requestId, errorCode, "setState");
        }

        @Override
        public void onPresenceRemoveStateResult(long requestId, int errorCode) {
            this.onModifyStateResult(requestId, errorCode, "removeState");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPresenceGetStateResult(long requestId, UserState state, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<UserState> callback = RtmClientImpl.this.mGetStateCallback.remove(requestId);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    callback.onSuccess(state);
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getState"));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetHistoryMessagesResult(long requestId, HistoryMessage[] messageList, long newStart, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<GetMessagesResult> callback = RtmClientImpl.this.mGetMessagesCallback.remove(requestId);
                // ** MonitorExit[var8_5] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    GetMessagesResult res = new GetMessagesResult(newStart, new ArrayList<HistoryMessage>(Arrays.asList(messageList)));
                    callback.onSuccess(res);
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getMessages"));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onModifyMetadataResult(long requestId, int errorCode, String methodName) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mModifyMetadataCallback.remove(requestId);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                this.processCallback(callback, errorCode, methodName);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onGetMetadataResult(long requestId, Metadata data, int errorCode, String methodName) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Metadata> callback = RtmClientImpl.this.mGetMetadataCallback.remove(requestId);
                // ** MonitorExit[var7_5] (shouldn't be in output)
                if (callback == null) {
                    return;
                }
                if (errorCode == 0) {
                    callback.onSuccess(data);
                } else {
                    callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), methodName));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onModifyLockResult(long requestId, int errorCode, String methodName) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mModifyLockCallback.remove(requestId);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                this.processCallback(callback, errorCode, methodName);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onModifyStateResult(long requestId, int errorCode, String methodName) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<Void> callback = RtmClientImpl.this.mModifyStateCallback.remove(requestId);
                // ** MonitorExit[var6_4] (shouldn't be in output)
                this.processCallback(callback, errorCode, methodName);
                return;
            }
        }

        private void processCallback(ResultCallback<Void> callback, int errorCode, String methodName) {
            if (callback == null) {
                return;
            }
            if (errorCode == 0) {
                callback.onSuccess(null);
            } else {
                callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), methodName));
            }
        }
    }
}

