/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;
import java.util.ArrayList;
import java.util.EnumSet;

public class RtmPrivateConfig {
    private EnumSet<RtmConstants.RtmServiceType> serviceType;
    private ArrayList<String> accessPointHosts;

    public RtmPrivateConfig() {
        this.serviceType = EnumSet.of(RtmConstants.RtmServiceType.NONE);
        this.accessPointHosts = new ArrayList();
    }

    public RtmPrivateConfig(EnumSet<RtmConstants.RtmServiceType> serviceType, ArrayList<String> accessPointHosts) {
        this.serviceType = serviceType;
        this.accessPointHosts = accessPointHosts;
    }

    public void setServiceType(EnumSet<RtmConstants.RtmServiceType> serviceType) {
        this.serviceType = serviceType;
    }

    public void setAccessPointHosts(ArrayList<String> accessPointHosts) {
        this.accessPointHosts = accessPointHosts;
    }

    @CalledByNative
    public int getServiceType() {
        int val = 0;
        for (RtmConstants.RtmServiceType type : this.serviceType) {
            val |= RtmConstants.RtmServiceType.getValue(type);
        }
        return val;
    }

    @CalledByNative
    public ArrayList<String> getAccessPointHosts() {
        return this.accessPointHosts;
    }

    public String toString() {
        return "RtmPrivateConfig{serviceType: " + this.serviceType + ", accessPointHosts: " + this.accessPointHosts + '}';
    }
}

