/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import java.util.HashMap;
import java.util.Map;

public class RtmConstants {
    public static final String LOGIN_API_STR = "login";
    public static final String LOGOUT_API_STR = "logout";
    public static final String RENEW_TOKEN_API_STR = "renewToken";
    public static final String PUBLISH_API_STR = "publish";
    public static final String SUBSCRIBE_API_STR = "subscribe";
    public static final String UNSUBSCRIBE_API_STR = "unsubscribe";
    public static final String JOIN_API_STR = "join";
    public static final String LEAVE_API_STR = "leave";
    public static final String JOIN_TOPIC_API_STR = "joinTopic";
    public static final String LEAVE_TOPIC_API_STR = "leaveTopic";
    public static final String PUBLISH_TOPIC_MESSAGE_API_STR = "publishTopicMessage";
    public static final String SUBSCRIBE_TOPIC_API_STR = "subscribeTopic";
    public static final String UNSUBSCRIBE_TOPIC_API_STR = "unsubscribeTopic";
    public static final String GET_SUBSCRIBED_USER_LIST_API_STR = "getSubscribedUserList";
    public static final String SET_PARAMETERS_API_STR = "setParameters";
    public static final String WHO_NOW_API_STR = "whoNow";
    public static final String WHERE_NOW_API_STR = "whereNow";
    public static final String GET_ONLINE_USERS_API_STR = "getOnlineUsers";
    public static final String GET_USER_CHANNELS_API_STR = "getUserChannels";
    public static final String SET_STATE_API_STR = "setState";
    public static final String GET_STATE_API_STR = "getState";
    public static final String REMOVE_STATE_API_STR = "removeState";
    public static final String SET_CHANNEL_METADATA_API_STR = "setChannelMetadata";
    public static final String GET_CHANNEL_METADATA_API_STR = "getChannelMetadata";
    public static final String UPDATE_CHANNEL_METADATA_API_STR = "updateChannelMetadata";
    public static final String REMOVE_CHANNEL_METADATA_API_STR = "removeChannelMetadata";
    public static final String SET_USER_METADATA_API_STR = "setUserMetadata";
    public static final String UPDATE_USER_METADATA_API_STR = "updateUserMetadata";
    public static final String REMOVE_USER_METADATA_API_STR = "removeUserMetadata";
    public static final String GET_USER_METADATA_API_STR = "getUserMetadata";
    public static final String SUBSCRIBE_USER_METADATA_API_STR = "subscribeUserMetadata";
    public static final String UNSUBSCRIBE_USER_METADATA_API_STR = "unsubscribeUserMetadata";
    public static final String SET_LOCK_API_STR = "setLock";
    public static final String GET_LOCKS_API_STR = "getLocks";
    public static final String REMOVE_LOCK_API_STR = "removeLock";
    public static final String ACQUIRE_LOCK_API_STR = "acquireLock";
    public static final String RELEASE_LOCK_API_STR = "releaseLock";
    public static final String REVOKE_LOCK_API_STR = "revokeLock";
    public static final String GET_MESSAGES_API_STR = "getMessages";

    public static enum RtmPresenceEventType {
        NONE(0),
        SNAPSHOT(1),
        INTERVAL(2),
        REMOTE_JOIN(3),
        REMOTE_LEAVE(4),
        REMOTE_TIMEOUT(5),
        REMOTE_STATE_CHANGED(6),
        ERROR_OUT_OF_SERVICE(7);

        private final int value;

        public static int getValue(RtmPresenceEventType type) {
            if (type != null) {
                return type.value;
            }
            return RtmPresenceEventType.NONE.value;
        }

        public static RtmPresenceEventType getEnum(int value) {
            for (RtmPresenceEventType type : RtmPresenceEventType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return NONE;
        }

        private RtmPresenceEventType(int value) {
            this.value = value;
        }
    }

    public static enum RtmStorageEventType {
        NONE(0),
        SNAPSHOT(1),
        SET(2),
        UPDATE(3),
        REMOVE(4);

        private final int value;

        public static int getValue(RtmStorageEventType type) {
            if (type != null) {
                return type.value;
            }
            return RtmStorageEventType.NONE.value;
        }

        public static RtmStorageEventType getEnum(int value) {
            for (RtmStorageEventType type : RtmStorageEventType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return NONE;
        }

        private RtmStorageEventType(int value) {
            this.value = value;
        }
    }

    public static enum RtmStorageType {
        NONE(0),
        USER(1),
        CHANNEL(2);

        private final int value;

        public static int getValue(RtmStorageType type) {
            if (type != null) {
                return type.value;
            }
            return RtmStorageType.NONE.value;
        }

        public static RtmStorageType getEnum(int value) {
            for (RtmStorageType type : RtmStorageType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return NONE;
        }

        private RtmStorageType(int value) {
            this.value = value;
        }
    }

    public static enum RtmLockEventType {
        NONE(0),
        SNAPSHOT(1),
        SET(2),
        REMOVED(3),
        ACQUIRED(4),
        RELEASED(5),
        EXPIRED(6);

        private final int value;

        public static int getValue(RtmLockEventType type) {
            if (type != null) {
                return type.value;
            }
            return RtmLockEventType.NONE.value;
        }

        public static RtmLockEventType getEnum(int value) {
            for (RtmLockEventType type : RtmLockEventType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return NONE;
        }

        private RtmLockEventType(int value) {
            this.value = value;
        }
    }

    public static enum RtmEncryptionMode {
        NONE(0),
        AES_128_GCM(1),
        AES_256_GCM(2);

        private final int value;

        public static int getValue(RtmEncryptionMode mode) {
            if (mode != null) {
                return mode.value;
            }
            return RtmEncryptionMode.NONE.value;
        }

        private RtmEncryptionMode(int value) {
            this.value = value;
        }
    }

    public static enum RtmProxyType {
        NONE(0),
        HTTP(1),
        CLOUD_TCP(2);

        private final int value;

        public static int getValue(RtmProxyType type) {
            if (type != null) {
                return type.value;
            }
            return RtmProxyType.NONE.value;
        }

        private RtmProxyType(int value) {
            this.value = value;
        }
    }

    public static enum RtmTopicEventType {
        NONE(0),
        SNAPSHOT(1),
        REMOTE_JOIN(2),
        REMOTE_LEAVE(3);

        private final int value;

        public static int getValue(RtmTopicEventType type) {
            if (type != null) {
                return type.value;
            }
            return RtmTopicEventType.NONE.value;
        }

        public static RtmTopicEventType getEnum(int value) {
            for (RtmTopicEventType type : RtmTopicEventType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return NONE;
        }

        private RtmTopicEventType(int value) {
            this.value = value;
        }
    }

    public static enum RtmChannelType {
        NONE(0),
        MESSAGE(1),
        STREAM(2),
        USER(3);

        private final int value;

        public static int getValue(RtmChannelType type) {
            if (type != null) {
                return type.value;
            }
            return RtmChannelType.NONE.value;
        }

        public static RtmChannelType getEnum(int value) {
            for (RtmChannelType type : RtmChannelType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return NONE;
        }

        private RtmChannelType(int value) {
            this.value = value;
        }
    }

    public static enum RtmMessageType {
        BINARY(0),
        STRING(1);

        private final int value;

        public static int getValue(RtmMessageType type) {
            if (type != null) {
                return type.value;
            }
            return RtmMessageType.BINARY.value;
        }

        public static RtmMessageType getEnum(int value) {
            for (RtmMessageType type : RtmMessageType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return BINARY;
        }

        private RtmMessageType(int value) {
            this.value = value;
        }
    }

    public static enum RtmMessagePriority {
        HIGHEST(0),
        HIGH(1),
        NORMAL(4),
        LOW(8);

        private final int value;

        public static int getValue(RtmMessagePriority type) {
            if (type != null) {
                return type.value;
            }
            return RtmMessagePriority.NORMAL.value;
        }

        private RtmMessagePriority(int value) {
            this.value = value;
        }
    }

    public static enum RtmLinkStateChangeReason {
        UNKNOWN(0),
        LOGIN(1),
        LOGIN_SUCCESS(2),
        LOGIN_TIMEOUT(3),
        LOGIN_NOT_AUTHORIZED(4),
        LOGIN_REJECTED(5),
        RELOGIN(6),
        LOGOUT(7),
        AUTO_RECONNECT(8),
        RECONNECT_TIMEOUT(9),
        RECONNECT_SUCCESS(10),
        JOIN(11),
        JOIN_SUCCESS(12),
        JOIN_FAILED(13),
        REJOIN(14),
        LEAVE(15),
        INVALID_TOKEN(16),
        TOKEN_EXPIRED(17),
        INCONSISTENT_APP_ID(18),
        INVALID_CHANNEL_NAME(19),
        INVALID_USER_ID(20),
        NOT_INITIALIZED(21),
        RTM_SERVICE_NOT_CONNECTED(22),
        CHANNEL_INSTANCE_EXCEED_LIMITATION(23),
        OPERATION_RATE_EXCEED_LIMITATION(24),
        CHANNEL_IN_ERROR_STATE(25),
        PRESENCE_NOT_CONNECTED(26),
        SAME_UID_LOGIN(27),
        KICKED_OUT_BY_SERVER(28),
        KEEP_ALIVE_TIMEOUT(29),
        CONNECTION_ERROR(30),
        PRESENCE_NOT_READY(31),
        NETWORK_CHANGE(32),
        SERVICE_NOT_SUPPORTED(33),
        STREAM_CHANNEL_NOT_AVAILABLE(34),
        STORAGE_NOT_AVAILABLE(35),
        LOCK_NOT_AVAILABLE(36),
        LOGIN_TOO_FREQUENT(37);

        private final int value;
        private static final Map<Integer, RtmLinkStateChangeReason> cache;

        public static int getValue(RtmLinkStateChangeReason reason) {
            if (reason != null) {
                return reason.value;
            }
            return RtmLinkStateChangeReason.UNKNOWN.value;
        }

        public static RtmLinkStateChangeReason getEnum(Integer value) {
            if (cache.containsKey(value)) {
                return cache.get(value);
            }
            return UNKNOWN;
        }

        private RtmLinkStateChangeReason(int value) {
            this.value = value;
        }

        static {
            cache = new HashMap<Integer, RtmLinkStateChangeReason>();
            for (RtmLinkStateChangeReason reason : RtmLinkStateChangeReason.values()) {
                cache.put(RtmLinkStateChangeReason.getValue(reason), reason);
            }
        }
    }

    public static enum RtmConnectionChangeReason {
        CONNECTING(0),
        JOIN_SUCCESS(1),
        INTERRUPTED(2),
        BANNED_BY_SERVER(3),
        JOIN_FAILED(4),
        LEAVE_CHANNEL(5),
        INVALID_APP_ID(6),
        INVALID_CHANNEL_NAME(7),
        INVALID_TOKEN(8),
        TOKEN_EXPIRED(9),
        REJECTED_BY_SERVER(10),
        SETTING_PROXY_SERVER(11),
        RENEW_TOKEN(12),
        CLIENT_IP_ADDRESS_CHANGED(13),
        KEEP_ALIVE_TIMEOUT(14),
        REJOIN_SUCCESS(15),
        LOST(16),
        ECHO_TEST(17),
        CLIENT_IP_ADDRESS_CHANGED_BY_USER(18),
        SAME_UID_LOGIN(19),
        TOO_MANY_BROADCASTERS(20),
        LICENSE_VALIDATION_FAILURE(21),
        CERTIFICATION_VERIFY_FAILURE(22),
        STREAM_CHANNEL_NOT_AVAILABLE(23),
        INCONSISTENT_APPID(24),
        LOGIN_SUCCESS(10001),
        LOGOUT(10002),
        PRESENCE_NOT_READY(10003);

        private final int value;
        private static final Map<Integer, RtmConnectionChangeReason> cache;

        public static int getValue(RtmConnectionChangeReason reason) {
            if (reason != null) {
                return reason.value;
            }
            return RtmConnectionChangeReason.CONNECTING.value;
        }

        public static RtmConnectionChangeReason getEnum(Integer value) {
            if (cache.containsKey(value)) {
                return cache.get(value);
            }
            return CONNECTING;
        }

        private RtmConnectionChangeReason(int value) {
            this.value = value;
        }

        static {
            cache = new HashMap<Integer, RtmConnectionChangeReason>();
            for (RtmConnectionChangeReason reason : RtmConnectionChangeReason.values()) {
                cache.put(RtmConnectionChangeReason.getValue(reason), reason);
            }
        }
    }

    public static enum RtmConnectionState {
        DISCONNECTED(1),
        CONNECTING(2),
        CONNECTED(3),
        RECONNECTING(4),
        FAILED(5);

        private final int value;

        public static int getValue(RtmConnectionState state) {
            if (state != null) {
                return state.value;
            }
            return RtmConnectionState.DISCONNECTED.value;
        }

        public static RtmConnectionState getEnum(int value) {
            for (RtmConnectionState state : RtmConnectionState.values()) {
                if (state.value != value) continue;
                return state;
            }
            return DISCONNECTED;
        }

        private RtmConnectionState(int value) {
            this.value = value;
        }
    }

    public static enum RtmMessageQos {
        UNORDERED(0),
        ORDERED(1);

        private final int value;

        public static int getValue(RtmMessageQos qos) {
            if (qos != null) {
                return qos.value;
            }
            return RtmMessageQos.UNORDERED.value;
        }

        private RtmMessageQos(int value) {
            this.value = value;
        }
    }

    public static enum RtmLogLevel {
        NONE(0),
        INFO(1),
        WARN(2),
        ERROR(4),
        FATAL(8);

        private final int value;

        public static int getValue(RtmLogLevel level) {
            if (level != null) {
                return level.value;
            }
            return RtmLogLevel.NONE.value;
        }

        private RtmLogLevel(int value) {
            this.value = value;
        }
    }

    public static enum RtmAreaCode {
        CN(1),
        NA(2),
        EU(4),
        AS(8),
        JP(16),
        IN(32),
        GLOB(-1);

        private final int value;

        public static int getValue(RtmAreaCode code) {
            if (code != null) {
                return code.value;
            }
            return RtmAreaCode.GLOB.value;
        }

        private RtmAreaCode(int value) {
            this.value = value;
        }
    }

    public static enum RtmProtocolType {
        TCP_UDP(0),
        TCP_ONLY(1);

        private final int value;

        public static int getValue(RtmProtocolType type) {
            if (type != null) {
                return type.value;
            }
            return RtmProtocolType.TCP_UDP.value;
        }

        public static RtmProtocolType getEnum(int value) {
            for (RtmProtocolType type : RtmProtocolType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return TCP_UDP;
        }

        private RtmProtocolType(int value) {
            this.value = value;
        }
    }

    public static enum RtmServiceType {
        NONE(0),
        MESSAGE(1),
        STREAM(2);

        private final int value;

        public static int getValue(RtmServiceType type) {
            if (type != null) {
                return type.value;
            }
            return RtmServiceType.MESSAGE.value;
        }

        public static RtmServiceType getEnum(int value) {
            for (RtmServiceType type : RtmServiceType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return MESSAGE;
        }

        private RtmServiceType(int value) {
            this.value = value;
        }
    }

    public static enum RtmLinkOperation {
        LOGIN(0),
        LOGOUT(1),
        JOIN(2),
        LEAVE(3),
        SERVER_REJECT(4),
        AUTO_RECONNECT(5),
        RECONNECTED(6),
        HEARTBEAT_LOST(7),
        SERVER_TIMEOUT(8),
        NETWORK_CHANGE(9);

        private final int value;

        public static int getValue(RtmLinkOperation operation) {
            if (operation != null) {
                return operation.value;
            }
            return RtmLinkOperation.LOGIN.value;
        }

        public static RtmLinkOperation getEnum(int value) {
            for (RtmLinkOperation operation : RtmLinkOperation.values()) {
                if (operation.value != value) continue;
                return operation;
            }
            return LOGIN;
        }

        private RtmLinkOperation(int value) {
            this.value = value;
        }
    }

    public static enum RtmLinkState {
        IDLE(0),
        CONNECTING(1),
        CONNECTED(2),
        DISCONNECTED(3),
        SUSPENDED(4),
        FAILED(5);

        private final int value;

        public static int getValue(RtmLinkState state) {
            if (state != null) {
                return state.value;
            }
            return RtmLinkState.IDLE.value;
        }

        public static RtmLinkState getEnum(int value) {
            for (RtmLinkState state : RtmLinkState.values()) {
                if (state.value != value) continue;
                return state;
            }
            return IDLE;
        }

        private RtmLinkState(int value) {
            this.value = value;
        }
    }

    public static enum RtmTokenEventType {
        WILL_EXPIRE(1),
        READ_PERMISSION_REVOKED(2);

        private final int value;

        public static int getValue(RtmTokenEventType type) {
            if (type != null) {
                return type.value;
            }
            return RtmTokenEventType.WILL_EXPIRE.value;
        }

        public static RtmTokenEventType getEnum(int value) {
            for (RtmTokenEventType type : RtmTokenEventType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return WILL_EXPIRE;
        }

        private RtmTokenEventType(int value) {
            this.value = value;
        }
    }

    public static enum RtmErrorCode {
        OK(0),
        NOT_INITIALIZED(-10001),
        NOT_LOGIN(-10002),
        INVALID_APP_ID(-10003),
        INVALID_EVENT_HANDLER(-10004),
        INVALID_TOKEN(-10005),
        INVALID_USER_ID(-10006),
        INIT_SERVICE_FAILED(-10007),
        INVALID_CHANNEL_NAME(-10008),
        TOKEN_EXPIRED(-10009),
        LOGIN_NO_SERVER_RESOURCES(-10010),
        LOGIN_TIMEOUT(-10011),
        LOGIN_REJECTED(-10012),
        LOGIN_ABORTED(-10013),
        INVALID_PARAMETER(-10014),
        LOGIN_NOT_AUTHORIZED(-10015),
        INCONSISTENT_APPID(-10016),
        DUPLICATE_OPERATION(-10017),
        INSTANCE_ALREADY_RELEASED(-10018),
        INVALID_CHANNEL_TYPE(-10019),
        INVALID_ENCRYPTION_PARAMETER(-10020),
        OPERATION_RATE_EXCEED_LIMITATION(-10021),
        SERVICE_NOT_SUPPORTED(-10022),
        LOGIN_CANCELED(-10023),
        INVALID_PRIVATE_CONFIG(-10024),
        NOT_CONNECTED(-10025),
        RENEW_TOKEN_TIMEOUT(-10026),
        CHANNEL_NOT_JOINED(-11001),
        CHANNEL_NOT_SUBSCRIBED(-11002),
        CHANNEL_EXCEED_TOPIC_USER_LIMITATION(-11003),
        CHANNEL_IN_REUSE(-11004),
        CHANNEL_INSTANCE_EXCEED_LIMITATION(-11005),
        CHANNEL_IN_ERROR_STATE(-11006),
        CHANNEL_JOIN_FAILED(-11007),
        CHANNEL_INVALID_TOPIC_NAME(-11008),
        CHANNEL_INVALID_MESSAGE(-11009),
        CHANNEL_MESSAGE_LENGTH_EXCEED_LIMITATION(-11010),
        CHANNEL_INVALID_USER_LIST(-11011),
        CHANNEL_NOT_AVAILABLE(-11012),
        CHANNEL_TOPIC_NOT_SUBSCRIBED(-11013),
        CHANNEL_EXCEED_TOPIC_LIMITATION(-11014),
        CHANNEL_JOIN_TOPIC_FAILED(-11015),
        CHANNEL_TOPIC_NOT_JOINED(-11016),
        CHANNEL_TOPIC_NOT_EXIST(-11017),
        CHANNEL_INVALID_TOPIC_META(-11018),
        CHANNEL_SUBSCRIBE_TIMEOUT(-11019),
        CHANNEL_SUBSCRIBE_TOO_FREQUENT(-11020),
        CHANNEL_SUBSCRIBE_FAILED(-11021),
        CHANNEL_UNSUBSCRIBE_FAILED(-11022),
        CHANNEL_ENCRYPT_MESSAGE_FAILED(-11023),
        CHANNEL_PUBLISH_MESSAGE_FAILED(-11024),
        CHANNEL_PUBLISH_MESSAGE_TOO_FREQUENT(-11025),
        CHANNEL_PUBLISH_MESSAGE_TIMEOUT(-11026),
        CHANNEL_NOT_CONNECTED(-11027),
        CHANNEL_LEAVE_FAILED(-11028),
        CHANNEL_CUSTOM_TYPE_LENGTH_OVERFLOW(-11029),
        CHANNEL_INVALID_CUSTOM_TYPE(-11030),
        CHANNEL_UNSUPPORTED_MESSAGE_TYPE(-11031),
        CHANNEL_PRESENCE_NOT_READY(-11032),
        CHANNEL_RECEIVER_OFFLINE(-11033),
        CHANNEL_JOIN_CANCELED(-11034),
        CHANNEL_RECEIVER_OFFLINE_BUT_STORE_SUCCEEDED(-11035),
        CHANNEL_RECEIVER_OFFLINE_AND_STORE_FAILED(-11036),
        CHANNEL_MESSAGE_DELIVERED_BUT_STORE_FAILED(-11037),
        CHANNEL_SUBSCRIBE_PERMISSION_DENIED(-11038),
        CHANNEL_PUBLISH_PERMISSION_DENIED(-11039),
        STORAGE_OPERATION_FAILED(-12001),
        STORAGE_METADATA_ITEM_EXCEED_LIMITATION(-12002),
        STORAGE_INVALID_METADATA_ITEM(-12003),
        STORAGE_INVALID_ARGUMENT(-12004),
        STORAGE_INVALID_REVISION(-12005),
        STORAGE_METADATA_LENGTH_OVERFLOW(-12006),
        STORAGE_INVALID_LOCK_NAME(-12007),
        STORAGE_LOCK_NOT_ACQUIRED(-12008),
        STORAGE_INVALID_KEY(-12009),
        STORAGE_INVALID_VALUE(-12010),
        STORAGE_KEY_LENGTH_OVERFLOW(-12011),
        STORAGE_VALUE_LENGTH_OVERFLOW(-12012),
        STORAGE_DUPLICATE_KEY(-12013),
        STORAGE_OUTDATED_REVISION(-12014),
        STORAGE_NOT_SUBSCRIBE(-12015),
        STORAGE_INVALID_METADATA_INSTANCE(-12016),
        STORAGE_SUBSCRIBE_USER_EXCEED_LIMITATION(-12017),
        STORAGE_OPERATION_TIMEOUT(-12018),
        STORAGE_NOT_AVAILABLE(-12019),
        STORAGE_PERMISSION_DENIED(-12020),
        PRESENCE_NOT_CONNECTED(-13001),
        PRESENCE_NOT_WRITABLE(-13002),
        PRESENCE_INVALID_ARGUMENT(-13003),
        PRESENCE_CACHED_TOO_MANY_STATES(-13004),
        PRESENCE_STATE_COUNT_OVERFLOW(-13005),
        PRESENCE_INVALID_STATE_KEY(-13006),
        PRESENCE_INVALID_STATE_VALUE(-13007),
        PRESENCE_STATE_KEY_SIZE_OVERFLOW(-13008),
        PRESENCE_STATE_VALUE_SIZE_OVERFLOW(-13009),
        PRESENCE_STATE_DUPLICATE_KEY(-13010),
        PRESENCE_USER_NOT_EXIST(-13011),
        PRESENCE_OPERATION_TIMEOUT(-13012),
        PRESENCE_OPERATION_FAILED(-13013),
        LOCK_OPERATION_FAILED(-14001),
        LOCK_OPERATION_TIMEOUT(-14002),
        LOCK_OPERATION_PERFORMING(-14003),
        LOCK_ALREADY_EXIST(-14004),
        LOCK_INVALID_NAME(-14005),
        LOCK_NOT_ACQUIRED(-14006),
        LOCK_ACQUIRE_FAILED(-14007),
        LOCK_NOT_EXIST(-14008),
        LOCK_NOT_AVAILABLE(-14009),
        LOCK_PERMISSION_DENIED(-14010),
        HISTORY_OPERATION_FAILED(-15001),
        HISTORY_INVALID_TIMESTAMP(-15002),
        HISTORY_OPERATION_TIMEOUT(-15003),
        HISTORY_OPERATION_NOT_PERMITTED(-15004),
        HISTORY_NOT_AVAILABLE(-15005),
        HISTORY_PERMISSION_DENIED(-15006);

        private final int value;
        private static final Map<Integer, RtmErrorCode> cache;

        public static int getValue(RtmErrorCode code) {
            if (code != null) {
                return code.value;
            }
            return RtmErrorCode.OK.value;
        }

        public static RtmErrorCode getEnum(Integer value) {
            if (cache.containsKey(value)) {
                return cache.get(value);
            }
            return OK;
        }

        private RtmErrorCode(int value) {
            this.value = value;
        }

        static {
            cache = new HashMap<Integer, RtmErrorCode>();
            for (RtmErrorCode code : RtmErrorCode.values()) {
                cache.put(RtmErrorCode.getValue(code), code);
            }
        }
    }
}

