/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.PublishOptions;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmConfig;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmEventListener;
import io.agora.rtm.RtmHistory;
import io.agora.rtm.RtmLock;
import io.agora.rtm.RtmPresence;
import io.agora.rtm.RtmStorage;
import io.agora.rtm.StreamChannel;
import io.agora.rtm.SubscribeOptions;
import io.agora.rtm.internal.RtmClientImpl;

public abstract class RtmClient {
    private static RtmClient mInstance = null;

    protected abstract RtmConstants.RtmErrorCode initialize(RtmConfig var1);

    protected abstract RtmConstants.RtmErrorCode releaseClient();

    public static synchronized RtmClient create(RtmConfig config) throws Exception {
        RtmConstants.RtmErrorCode errorCode;
        if (!RtmClientImpl.initializeNativeLibs()) {
            throw new UnsatisfiedLinkError("load native libraries failed");
        }
        if (mInstance == null) {
            mInstance = new RtmClientImpl();
        }
        if (mInstance != null && (errorCode = mInstance.initialize(config)) != RtmConstants.RtmErrorCode.OK) {
            RtmClient.release();
            throw new IllegalArgumentException(errorCode.name());
        }
        return mInstance;
    }

    public static synchronized RtmClient getInstance() {
        return mInstance;
    }

    public static synchronized void release() {
        if (mInstance == null) {
            return;
        }
        mInstance.releaseClient();
        mInstance = null;
    }

    public static String getVersion() {
        if (!RtmClientImpl.initializeNativeLibs()) {
            return "";
        }
        return RtmClientImpl.nativeGetVersion();
    }

    public abstract void addEventListener(RtmEventListener var1);

    public abstract void removeEventListener(RtmEventListener var1);

    public abstract void login(String var1, ResultCallback<Void> var2);

    public abstract void logout(ResultCallback<Void> var1);

    public abstract RtmStorage getStorage();

    public abstract RtmLock getLock();

    public abstract RtmPresence getPresence();

    public abstract RtmHistory getHistory();

    public abstract String getErrorReason(RtmConstants.RtmErrorCode var1);

    public abstract void renewToken(String var1, ResultCallback<Void> var2);

    public abstract void publish(String var1, String var2, PublishOptions var3, ResultCallback<Void> var4);

    public abstract void publish(String var1, byte[] var2, PublishOptions var3, ResultCallback<Void> var4);

    public abstract void subscribe(String var1, SubscribeOptions var2, ResultCallback<Void> var3);

    public abstract void unsubscribe(String var1, ResultCallback<Void> var2);

    public abstract RtmConstants.RtmErrorCode setParameters(String var1);

    public abstract StreamChannel createStreamChannel(String var1) throws Exception;
}

