/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.LockDetail;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;
import java.util.ArrayList;
import java.util.Arrays;

public class LockEvent {
    private final RtmConstants.RtmChannelType channelType;
    private final RtmConstants.RtmLockEventType eventType;
    private final String channelName;
    private final ArrayList<LockDetail> lockDetailList;
    private final long timestamp;

    @CalledByNative
    public LockEvent(String channelName, int channelType, int eventType, LockDetail[] lockDetails, long timestamp) {
        this.channelType = RtmConstants.RtmChannelType.getEnum(channelType);
        this.eventType = RtmConstants.RtmLockEventType.getEnum(eventType);
        this.channelName = channelName;
        this.lockDetailList = new ArrayList<LockDetail>(Arrays.asList(lockDetails));
        this.timestamp = timestamp;
    }

    public RtmConstants.RtmChannelType getChannelType() {
        return this.channelType;
    }

    public RtmConstants.RtmLockEventType getEventType() {
        return this.eventType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public ArrayList<LockDetail> getLockDetailList() {
        return this.lockDetailList;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "LockEvent {channelName: " + this.channelName + ", channelType: " + (Object)((Object)this.channelType) + ", eventType: " + (Object)((Object)this.eventType) + ", lockDetailList: " + this.lockDetailList + ", timestamp: " + this.timestamp + "}";
    }
}

