/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;
import java.util.ArrayList;
import java.util.Arrays;

public class LinkStateEvent {
    private final RtmConstants.RtmLinkState currentState;
    private final RtmConstants.RtmLinkState previousState;
    private final RtmConstants.RtmServiceType serviceType;
    private final RtmConstants.RtmLinkOperation operation;
    private final RtmConstants.RtmLinkStateChangeReason reasonCode;
    private final String reason;
    private final ArrayList<String> affectedChannels;
    private final ArrayList<String> unrestoredChannels;
    private final boolean isResumed;
    private final long timestamp;

    public RtmConstants.RtmLinkState getCurrentState() {
        return this.currentState;
    }

    public RtmConstants.RtmLinkState getPreviousState() {
        return this.previousState;
    }

    public RtmConstants.RtmServiceType getServiceType() {
        return this.serviceType;
    }

    public RtmConstants.RtmLinkOperation getOperation() {
        return this.operation;
    }

    public RtmConstants.RtmLinkStateChangeReason getReasonCode() {
        return this.reasonCode;
    }

    public String getReason() {
        return this.reason;
    }

    public ArrayList<String> getAffectedChannels() {
        return this.affectedChannels;
    }

    public ArrayList<String> getUnrestoredChannels() {
        return this.unrestoredChannels;
    }

    public boolean getIsResumed() {
        return this.isResumed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @CalledByNative
    public LinkStateEvent(int currentState, int previousState, int serviceType, int operation, int reasonCode, String reason, String[] affectedChannels, String[] unrestoredChannels, boolean isResumed, long timestamp) {
        this.currentState = RtmConstants.RtmLinkState.getEnum(currentState);
        this.previousState = RtmConstants.RtmLinkState.getEnum(previousState);
        this.serviceType = RtmConstants.RtmServiceType.getEnum(serviceType);
        this.operation = RtmConstants.RtmLinkOperation.getEnum(operation);
        this.reasonCode = RtmConstants.RtmLinkStateChangeReason.getEnum(reasonCode);
        this.reason = reason;
        this.affectedChannels = new ArrayList<String>(Arrays.asList(affectedChannels));
        this.unrestoredChannels = new ArrayList<String>(Arrays.asList(unrestoredChannels));
        this.isResumed = isResumed;
        this.timestamp = timestamp;
    }

    public String toString() {
        return "LinkStateEvent {currentState: " + (Object)((Object)this.currentState) + ", previousState: " + (Object)((Object)this.previousState) + ", serviceType: " + (Object)((Object)this.serviceType) + ", operation: " + (Object)((Object)this.operation) + ", reasonCode: " + (Object)((Object)this.reasonCode) + ", reason: " + this.reason + ", affectedChannels: " + this.affectedChannels + ", unrestoredChannels: " + this.unrestoredChannels + ", isResumed: " + this.isResumed + ", timestamp: " + this.timestamp + "}";
    }
}

